#ifndef _USB_STRINGS_H
#define _USB_STRINGS_H

/* THIS FILE IS AUTOGENERATED, DO NOT MODIFY MANUALLY */

#include <stdint.h>
#include <usb/common/core/USBGenericDescriptor.h>
#define ARRAY_SIZE(x) (sizeof(x) / sizeof((x)[0]))

/* All standard descriptors have these 2 fields at the beginning */

struct usb_descriptor_header {
	uint8_t bLength;
	uint8_t bDescriptorType;
} __attribute__ ((packed));

static const struct {
	struct usb_descriptor_header hdr;
	uint16_t wData[];
} __attribute__((packed)) string0 = {
	.hdr = {
		.bLength = USBStringDescriptor_LENGTH(1),
		.bDescriptorType = USBGenericDescriptor_STRING,
	},
	.wData = {0x0409 /* English */ },
};

/* String 1 "sysmocom - systems for mobile communications GmbH" */
static const struct {
	struct usb_descriptor_header hdr;
	uint16_t wData[];
} __attribute__((packed)) string1 = {
	.hdr = {
		.bLength = USBStringDescriptor_LENGTH(49),
		.bDescriptorType = USBGenericDescriptor_STRING,
	},
	.wData = {	0x0073, 0x0079, 0x0073, 0x006d, 0x006f, 0x0063,
			0x006f, 0x006d, 0x0020, 0x002d, 0x0020, 0x0073,
			0x0079, 0x0073, 0x0074, 0x0065, 0x006d, 0x0073,
			0x0020, 0x0066, 0x006f, 0x0072, 0x0020, 0x006d,
			0x006f, 0x0062, 0x0069, 0x006c, 0x0065, 0x0020,
			0x0063, 0x006f, 0x006d, 0x006d, 0x0075, 0x006e,
			0x0069, 0x0063, 0x0061, 0x0074, 0x0069, 0x006f,
			0x006e, 0x0073, 0x0020, 0x0047, 0x006d, 0x0062,
			0x0048, },
};

/* String 2 "OsmoSDR Software Defined Radio" */
static const struct {
	struct usb_descriptor_header hdr;
	uint16_t wData[];
} __attribute__((packed)) string2 = {
	.hdr = {
		.bLength = USBStringDescriptor_LENGTH(30),
		.bDescriptorType = USBGenericDescriptor_STRING,
	},
	.wData = {	0x004f, 0x0073, 0x006d, 0x006f, 0x0053, 0x0044,
			0x0052, 0x0020, 0x0053, 0x006f, 0x0066, 0x0074,
			0x0077, 0x0061, 0x0072, 0x0065, 0x0020, 0x0044,
			0x0065, 0x0066, 0x0069, 0x006e, 0x0065, 0x0064,
			0x0020, 0x0052, 0x0061, 0x0064, 0x0069, 0x006f,
},
};

/* String 3 "OsmoSDR Device Firmware Upgrade" */
static const struct {
	struct usb_descriptor_header hdr;
	uint16_t wData[];
} __attribute__((packed)) string3 = {
	.hdr = {
		.bLength = USBStringDescriptor_LENGTH(31),
		.bDescriptorType = USBGenericDescriptor_STRING,
	},
	.wData = {	0x004f, 0x0073, 0x006d, 0x006f, 0x0053, 0x0044,
			0x0052, 0x0020, 0x0044, 0x0065, 0x0076, 0x0069,
			0x0063, 0x0065, 0x0020, 0x0046, 0x0069, 0x0072,
			0x006d, 0x0077, 0x0061, 0x0072, 0x0065, 0x0020,
			0x0055, 0x0070, 0x0067, 0x0072, 0x0061, 0x0064,
			0x0065, },
};

/* String 4 "OsmoSDR DFU Interface - Application Partition" */
static const struct {
	struct usb_descriptor_header hdr;
	uint16_t wData[];
} __attribute__((packed)) string4 = {
	.hdr = {
		.bLength = USBStringDescriptor_LENGTH(45),
		.bDescriptorType = USBGenericDescriptor_STRING,
	},
	.wData = {	0x004f, 0x0073, 0x006d, 0x006f, 0x0053, 0x0044,
			0x0052, 0x0020, 0x0044, 0x0046, 0x0055, 0x0020,
			0x0049, 0x006e, 0x0074, 0x0065, 0x0072, 0x0066,
			0x0061, 0x0063, 0x0065, 0x0020, 0x002d, 0x0020,
			0x0041, 0x0070, 0x0070, 0x006c, 0x0069, 0x0063,
			0x0061, 0x0074, 0x0069, 0x006f, 0x006e, 0x0020,
			0x0050, 0x0061, 0x0072, 0x0074, 0x0069, 0x0074,
			0x0069, 0x006f, 0x006e, },
};

/* String 5 "OsmoSDR DFU Interface - Bootloader Partition" */
static const struct {
	struct usb_descriptor_header hdr;
	uint16_t wData[];
} __attribute__((packed)) string5 = {
	.hdr = {
		.bLength = USBStringDescriptor_LENGTH(44),
		.bDescriptorType = USBGenericDescriptor_STRING,
	},
	.wData = {	0x004f, 0x0073, 0x006d, 0x006f, 0x0053, 0x0044,
			0x0052, 0x0020, 0x0044, 0x0046, 0x0055, 0x0020,
			0x0049, 0x006e, 0x0074, 0x0065, 0x0072, 0x0066,
			0x0061, 0x0063, 0x0065, 0x0020, 0x002d, 0x0020,
			0x0042, 0x006f, 0x006f, 0x0074, 0x006c, 0x006f,
			0x0061, 0x0064, 0x0065, 0x0072, 0x0020, 0x0050,
			0x0061, 0x0072, 0x0074, 0x0069, 0x0074, 0x0069,
			0x006f, 0x006e, },
};

/* String 6 "OsmoSDR DFU Interface - RAM" */
static const struct {
	struct usb_descriptor_header hdr;
	uint16_t wData[];
} __attribute__((packed)) string6 = {
	.hdr = {
		.bLength = USBStringDescriptor_LENGTH(27),
		.bDescriptorType = USBGenericDescriptor_STRING,
	},
	.wData = {	0x004f, 0x0073, 0x006d, 0x006f, 0x0053, 0x0044,
			0x0052, 0x0020, 0x0044, 0x0046, 0x0055, 0x0020,
			0x0049, 0x006e, 0x0074, 0x0065, 0x0072, 0x0066,
			0x0061, 0x0063, 0x0065, 0x0020, 0x002d, 0x0020,
			0x0052, 0x0041, 0x004d, },
};

/* String 7 "OsmoSDR DFU Interface - FPGA" */
static const struct {
	struct usb_descriptor_header hdr;
	uint16_t wData[];
} __attribute__((packed)) string7 = {
	.hdr = {
		.bLength = USBStringDescriptor_LENGTH(28),
		.bDescriptorType = USBGenericDescriptor_STRING,
	},
	.wData = {	0x004f, 0x0073, 0x006d, 0x006f, 0x0053, 0x0044,
			0x0052, 0x0020, 0x0044, 0x0046, 0x0055, 0x0020,
			0x0049, 0x006e, 0x0074, 0x0065, 0x0072, 0x0066,
			0x0061, 0x0063, 0x0065, 0x0020, 0x002d, 0x0020,
			0x0046, 0x0050, 0x0047, 0x0041, },
};

#define USB_STRINGS_GENERATED				\
	(const unsigned char *) &string0,		\
	(const unsigned char *) &string1,		\
	(const unsigned char *) &string2,		\
	(const unsigned char *) &string3,		\
	(const unsigned char *) &string4,		\
	(const unsigned char *) &string5,		\
	(const unsigned char *) &string6,		\
	(const unsigned char *) &string7,		\

#endif /* _USB_STRINGS_H */
