/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.TreeUI;
import javax.swing.text.Caret;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.FixedHeightLayoutCache;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BasicTreeUI
extends TreeUI {
    protected transient Icon collapsedIcon;
    protected transient Icon expandedIcon;
    protected int leftChildIndent;
    protected int rightChildIndent;
    protected int totalChildIndent;
    protected int lastSelectedRow;
    protected JTree tree;
    protected transient TreeCellRenderer currentCellRenderer;
    protected boolean createdRenderer;
    protected transient TreeCellEditor cellEditor;
    protected boolean createdCellEditor;
    protected boolean stopEditingInCompleteEditing;
    protected CellRendererPane rendererPane;
    protected Dimension preferredSize;
    protected Dimension preferredMinSize;
    protected boolean validCachedPreferredSize;
    protected AbstractLayoutCache treeState;
    protected Hashtable drawingCache;
    protected boolean largeModel;
    protected AbstractLayoutCache.NodeDimensions nodeDimensions;
    protected TreeModel treeModel;
    protected TreeSelectionModel treeSelectionModel;
    protected int depthOffset;
    protected Component editingComponent;
    protected TreePath editingPath;
    protected int editingRow;
    protected boolean editorHasDifferentSize;
    Timer editorTimer;
    Object newVal;
    TreeAction action;
    boolean isEditing;
    Rectangle bounds;
    TreePath currentVisiblePath;
    int gap;
    private PropertyChangeListener propertyChangeListener;
    private FocusListener focusListener;
    private TreeSelectionListener treeSelectionListener;
    private MouseListener mouseListener;
    private KeyListener keyListener;
    private PropertyChangeListener selectionModelPropertyChangeListener;
    private ComponentListener componentListener;
    CellEditorListener cellEditorListener;
    private TreeExpansionListener treeExpansionListener;
    private TreeModelListener treeModelListener;

    public static ComponentUI createUI(JComponent c) {
        return new BasicTreeUI();
    }

    protected Color getHashColor() {
        return UIManager.getLookAndFeelDefaults().getColor("Tree.hash");
    }

    protected void setHashColor(Color color) {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        defaults.put("Tree.hash", color);
    }

    public void setLeftChildIndent(int newAmount) {
        this.leftChildIndent = newAmount;
    }

    public int getLeftChildIndent() {
        return this.leftChildIndent;
    }

    public void setRightChildIndent(int newAmount) {
        this.rightChildIndent = newAmount;
    }

    public int getRightChildIndent() {
        return this.rightChildIndent;
    }

    public void setExpandedIcon(Icon newG) {
        this.expandedIcon = newG;
    }

    public Icon getExpandedIcon() {
        return this.expandedIcon;
    }

    public void setCollapsedIcon(Icon newG) {
        this.collapsedIcon = newG;
    }

    public Icon getCollapsedIcon() {
        return this.collapsedIcon;
    }

    protected void setLargeModel(boolean largeModel) {
        if (largeModel != this.largeModel) {
            this.tree.removeComponentListener(this.componentListener);
            this.largeModel = largeModel;
            this.tree.addComponentListener(this.componentListener);
        }
    }

    protected boolean isLargeModel() {
        return this.largeModel;
    }

    protected void setRowHeight(int rowHeight) {
        this.treeState.setRowHeight(rowHeight);
    }

    protected int getRowHeight() {
        return this.treeState.getRowHeight();
    }

    protected void setCellRenderer(TreeCellRenderer tcr) {
        this.currentCellRenderer = tcr;
        this.updateRenderer();
    }

    protected TreeCellRenderer getCellRenderer() {
        if (this.currentCellRenderer != null) {
            return this.currentCellRenderer;
        }
        return this.createDefaultCellRenderer();
    }

    protected void setModel(TreeModel model) {
        this.tree.setModel(model);
        this.treeModel = this.tree.getModel();
    }

    protected TreeModel getModel() {
        return this.treeModel;
    }

    protected void setRootVisible(boolean newValue) {
        this.tree.setRootVisible(newValue);
    }

    protected boolean isRootVisible() {
        return this.tree.isRootVisible();
    }

    protected void setShowsRootHandles(boolean newValue) {
        this.tree.setShowsRootHandles(newValue);
    }

    protected boolean getShowsRootHandles() {
        return this.tree.getShowsRootHandles();
    }

    protected void setCellEditor(TreeCellEditor editor) {
        this.cellEditor = editor;
        this.createdCellEditor = true;
    }

    protected TreeCellEditor getCellEditor() {
        return this.cellEditor;
    }

    protected void setEditable(boolean newValue) {
        this.tree.setEditable(newValue);
    }

    protected boolean isEditable() {
        return this.tree.isEditable();
    }

    protected void setSelectionModel(TreeSelectionModel newLSM) {
        if (newLSM != null) {
            this.treeSelectionModel = newLSM;
            this.tree.setSelectionModel(this.treeSelectionModel);
        }
    }

    protected TreeSelectionModel getSelectionModel() {
        return this.treeSelectionModel;
    }

    public Rectangle getPathBounds(JTree tree, TreePath path) {
        if (path != null) {
            Object cell = path.getLastPathComponent();
            if (this.treeModel != null) {
                Object root = this.treeModel.getRoot();
                if (!tree.isRootVisible() && tree.isExpanded(new TreePath(root))) {
                    root = this.getNextNode(root);
                }
                Point loc = this.getCellLocation(0, 0, tree, this.treeModel, cell, root);
                return this.getCellBounds(loc.x, loc.y, cell);
            }
        }
        return null;
    }

    public TreePath getPathForRow(JTree tree, int row) {
        Object[] nodes;
        if (this.treeModel != null && this.currentVisiblePath != null && row < (nodes = this.currentVisiblePath.getPath()).length) {
            return new TreePath(this.getPathToRoot(nodes[row], 0));
        }
        return null;
    }

    public int getRowForPath(JTree tree, TreePath path) {
        int row = 0;
        Object dest = path.getLastPathComponent();
        int rowCount = this.getRowCount(tree);
        if (this.currentVisiblePath != null) {
            Object[] nodes = this.currentVisiblePath.getPath();
            while (row < rowCount) {
                if (dest.equals(nodes[row])) {
                    return row;
                }
                ++row;
            }
        }
        return -1;
    }

    public int getRowCount(JTree tree) {
        if (this.currentVisiblePath != null) {
            return this.currentVisiblePath.getPathCount();
        }
        return 0;
    }

    public TreePath getClosestPathForLocation(JTree tree, int x, int y) {
        int row = Math.round(y / this.getRowHeight());
        TreePath path = this.getPathForRow(tree, row);
        while (row > 0 && path == null) {
            path = this.getPathForRow(tree, --row);
        }
        return path;
    }

    public boolean isEditing(JTree tree) {
        return this.isEditing;
    }

    public boolean stopEditing(JTree tree) {
        if (this.isEditing(tree)) {
            this.completeEditing(true, false, false);
        }
        return this.isEditing(tree) ^ true;
    }

    public void cancelEditing(JTree tree) {
        if (this.isEditing(tree)) {
            this.completeEditing(false, true, false);
        }
    }

    public void startEditingAtPath(JTree tree, TreePath path) {
        this.startEditing(path, null);
    }

    public TreePath getEditingPath(JTree tree) {
        return this.editingPath;
    }

    protected void prepareForUIInstall() {
    }

    protected void completeUIInstall() {
    }

    protected void completeUIUninstall() {
    }

    protected void installComponents() {
        this.currentCellRenderer = this.createDefaultCellRenderer();
        this.rendererPane = this.createCellRendererPane();
        this.createdRenderer = true;
        this.setCellRenderer(this.currentCellRenderer);
    }

    protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
        return new NodeDimensionsHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler();
    }

    protected PropertyChangeListener createSelectionModelPropertyChangeListener() {
        return new SelectionModelPropertyChangeHandler();
    }

    protected TreeSelectionListener createTreeSelectionListener() {
        return new TreeSelectionHandler();
    }

    protected CellEditorListener createCellEditorListener() {
        return new CellEditorHandler();
    }

    protected ComponentListener createComponentListener() {
        return new ComponentHandler();
    }

    protected TreeExpansionListener createTreeExpansionListener() {
        return new TreeExpansionHandler();
    }

    protected AbstractLayoutCache createLayoutCache() {
        return new FixedHeightLayoutCache();
    }

    protected CellRendererPane createCellRendererPane() {
        return new CellRendererPane();
    }

    protected TreeCellEditor createDefaultCellEditor() {
        if (this.currentCellRenderer != null) {
            return new DefaultTreeCellEditor(this.tree, (DefaultTreeCellRenderer)this.currentCellRenderer, this.cellEditor);
        }
        return new DefaultTreeCellEditor(this.tree, (DefaultTreeCellRenderer)this.createDefaultCellRenderer(), this.cellEditor);
    }

    protected TreeCellRenderer createDefaultCellRenderer() {
        return new DefaultTreeCellRenderer();
    }

    protected TreeModelListener createTreeModelListener() {
        return new TreeModelHandler();
    }

    protected void uninstallListeners() {
        this.tree.removePropertyChangeListener(this.propertyChangeListener);
        this.tree.removeFocusListener(this.focusListener);
        this.tree.removeTreeSelectionListener(this.treeSelectionListener);
        this.tree.removeMouseListener(this.mouseListener);
        this.tree.removeKeyListener(this.keyListener);
        this.tree.removePropertyChangeListener(this.selectionModelPropertyChangeListener);
        this.tree.removeComponentListener(this.componentListener);
        this.tree.removeTreeExpansionListener(this.treeExpansionListener);
        TreeCellEditor tce = this.tree.getCellEditor();
        if (tce != null) {
            tce.removeCellEditorListener(this.cellEditorListener);
        }
        if (this.treeModel != null) {
            this.treeModel.removeTreeModelListener(this.treeModelListener);
        }
    }

    protected void uninstallKeyboardActions() {
    }

    protected void uninstallComponents() {
        this.currentCellRenderer = null;
        this.rendererPane = null;
        this.createdRenderer = false;
        this.setCellRenderer(this.currentCellRenderer);
    }

    protected int getVerticalLegBuffer() {
        return this.getRowHeight() / 2;
    }

    protected int getHorizontalLegBuffer() {
        return this.rightChildIndent / 2;
    }

    protected void updateLayoutCacheExpandedNodes() {
        if (this.treeModel != null) {
            this.updateExpandedDescendants(new TreePath(this.treeModel.getRoot()));
        }
    }

    protected void updateExpandedDescendants(TreePath path) {
        Enumeration expanded = this.tree.getExpandedDescendants(path);
        while (expanded.hasMoreElements()) {
            this.treeState.setExpandedState((TreePath)expanded.nextElement(), true);
        }
    }

    protected TreePath getLastChildPath(TreePath parent) {
        return (TreePath)parent.getLastPathComponent();
    }

    protected void updateDepthOffset() {
        this.depthOffset += this.getVerticalLegBuffer();
    }

    protected void updateCellEditor() {
        if (this.tree.isEditable() && this.cellEditor == null) {
            this.setCellEditor(this.createDefaultCellEditor());
        }
        this.createdCellEditor = true;
    }

    protected void updateRenderer() {
        if (this.tree != null && this.tree.getCellRenderer() == null) {
            if (this.currentCellRenderer == null) {
                this.currentCellRenderer = this.createDefaultCellRenderer();
            }
            this.tree.setCellRenderer(this.currentCellRenderer);
        }
    }

    protected void configureLayoutCache() {
        this.treeState = this.createLayoutCache();
    }

    protected void updateSize() {
        this.preferredSize = null;
        this.updateCachedPreferredSize();
        this.tree.treeDidChange();
    }

    protected void updateCachedPreferredSize() {
        int maxWidth = 0;
        boolean isLeaf = false;
        if (this.currentVisiblePath != null) {
            Object[] path = this.currentVisiblePath.getPath();
            int i = 0;
            while (i < path.length) {
                TreePath curr = new TreePath(this.getPathToRoot(path[i], 0));
                Rectangle bounds = this.getPathBounds(this.tree, curr);
                if (this.treeModel != null) {
                    isLeaf = this.treeModel.isLeaf(path[i]);
                }
                if (!isLeaf && this.hasControlIcons()) {
                    bounds.width += this.getCurrentControlIcon(curr).getIconWidth();
                }
                maxWidth = Math.max(maxWidth, bounds.x + bounds.width);
                ++i;
            }
            this.preferredSize = new Dimension(maxWidth, this.getRowHeight() * path.length);
        } else {
            this.preferredSize = new Dimension(0, 0);
        }
        this.validCachedPreferredSize = true;
    }

    protected void pathWasExpanded(TreePath path) {
        this.validCachedPreferredSize = false;
        this.tree.revalidate();
        this.tree.repaint();
    }

    protected void pathWasCollapsed(TreePath path) {
        this.validCachedPreferredSize = false;
        this.tree.revalidate();
        this.tree.repaint();
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.tree, "Tree.background", "Tree.foreground", "Tree.font");
        this.tree.setOpaque(true);
        this.rightChildIndent = UIManager.getInt("Tree.rightChildIndent");
        this.leftChildIndent = UIManager.getInt("Tree.leftChildIndent");
        this.setRowHeight(UIManager.getInt("Tree.rowHeight"));
        this.tree.setRowHeight(UIManager.getInt("Tree.rowHeight"));
        this.tree.requestFocusInWindow(false);
        this.tree.setScrollsOnExpand(UIManager.getBoolean("Tree.scrollsOnExpand"));
        this.setExpandedIcon(UIManager.getIcon("Tree.expandedIcon"));
        this.setCollapsedIcon(UIManager.getIcon("Tree.collapsedIcon"));
    }

    protected void installKeyboardActions() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        InputMap focusInputMap = (InputMap)defaults.get("Tree.focusInputMap");
        InputMapUIResource parentInputMap = new InputMapUIResource();
        ActionMap parentActionMap = new ActionMap();
        this.action = new TreeAction();
        KeyStroke[] keys = focusInputMap.allKeys();
        int i = 0;
        while (i < keys.length) {
            parentInputMap.put(KeyStroke.getKeyStroke(keys[i].getKeyCode(), this.convertModifiers(keys[i].getModifiers())), (String)focusInputMap.get(keys[i]));
            parentInputMap.put(KeyStroke.getKeyStroke(keys[i].getKeyCode(), keys[i].getModifiers()), (String)focusInputMap.get(keys[i]));
            parentActionMap.put((String)focusInputMap.get(keys[i]), new ActionListenerProxy(this.action, (String)focusInputMap.get(keys[i])));
            ++i;
        }
        parentInputMap.setParent(this.tree.getInputMap(1).getParent());
        parentActionMap.setParent(this.tree.getActionMap().getParent());
        this.tree.getInputMap(1).setParent(parentInputMap);
        this.tree.getActionMap().setParent(parentActionMap);
    }

    private final int convertModifiers(int mod) {
        if ((mod & 0x40) != 0) {
            mod |= 1;
            mod &= 0xFFFFFFBF;
        }
        if ((mod & 0x80) != 0) {
            mod |= 2;
            mod &= 0xFFFFFF7F;
        }
        if ((mod & 0x100) != 0) {
            mod |= 4;
            mod &= 0xFFFFFEFF;
        }
        if ((mod & 0x200) != 0) {
            mod |= 8;
            mod &= 0xFFFFFDFF;
        }
        if ((mod & 0x2000) != 0) {
            mod |= 0x20;
            mod &= 0xFFFFDFFF;
        }
        return mod;
    }

    protected void installListeners() {
        this.tree.addPropertyChangeListener(this.propertyChangeListener);
        this.tree.addFocusListener(this.focusListener);
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
        this.tree.addMouseListener(this.mouseListener);
        this.tree.addKeyListener(this.keyListener);
        this.tree.addPropertyChangeListener(this.selectionModelPropertyChangeListener);
        this.tree.addComponentListener(this.componentListener);
        this.tree.addTreeExpansionListener(this.treeExpansionListener);
        if (this.treeModel != null) {
            this.treeModel.addTreeModelListener(this.treeModelListener);
        }
    }

    public void installUI(JComponent c) {
        TreePath path;
        this.tree = (JTree)c;
        this.prepareForUIInstall();
        super.installUI(c);
        this.installDefaults();
        this.installComponents();
        this.installKeyboardActions();
        this.installListeners();
        this.setCellEditor(this.createDefaultCellEditor());
        this.createdCellEditor = true;
        this.isEditing = false;
        TreeModel mod = this.tree.getModel();
        this.setModel(mod);
        if (mod != null && !this.tree.isExpanded(path = new TreePath(mod.getRoot()))) {
            this.toggleExpandState(path);
        }
        this.treeSelectionModel = this.tree.getSelectionModel();
        this.completeUIInstall();
    }

    protected void uninstallDefaults() {
        this.tree.setFont(null);
        this.tree.setForeground(null);
        this.tree.setBackground(null);
    }

    public void uninstallUI(JComponent c) {
        this.prepareForUIUninstall();
        this.uninstallDefaults();
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.tree = null;
        this.uninstallComponents();
        this.completeUIUninstall();
    }

    public void paint(Graphics g, JComponent c) {
        JTree tree = (JTree)c;
        if (this.currentVisiblePath == null) {
            this.updateCurrentVisiblePath();
        }
        if (this.treeModel != null) {
            Object root = this.treeModel.getRoot();
            this.paintRecursive(g, 0, 0, 0, tree, this.treeModel, root);
            if (this.hasControlIcons()) {
                this.paintControlIcons(g, 0, 0, 0, tree, this.treeModel, root);
            }
        }
    }

    protected void ensureRowsAreVisible(int beginRow, int endRow) {
        int i;
        if (beginRow < endRow) {
            int temp = endRow;
            endRow = beginRow;
            beginRow = i;
        }
        i = beginRow;
        while (i < endRow) {
            TreePath path = this.getPathForRow(this.tree, i);
            if (!this.tree.isVisible(path)) {
                this.tree.makeVisible(path);
            }
            ++i;
        }
    }

    public void setPreferredMinSize(Dimension newSize) {
        this.preferredMinSize = newSize;
    }

    public Dimension getPreferredMinSize() {
        return this.preferredMinSize;
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.getPreferredSize(c, false);
    }

    public Dimension getPreferredSize(JComponent c, boolean checkConsistancy) {
        if (!this.validCachedPreferredSize) {
            this.updateCachedPreferredSize();
        }
        return this.preferredSize;
    }

    public Dimension getMinimumSize(JComponent c) {
        Dimension min = this.getPreferredMinSize();
        if (min == null) {
            return new Dimension();
        }
        return min;
    }

    public Dimension getMaximumSize(JComponent c) {
        if (c instanceof JTree) {
            return ((JTree)c).getPreferredSize();
        }
        return new Dimension();
    }

    protected void completeEditing() {
        this.completeEditing(false, true, false);
    }

    protected void completeEditing(boolean messageStop, boolean messageCancel, boolean messageTree) {
        if (messageStop) {
            this.getCellEditor().stopCellEditing();
            this.stopEditingInCompleteEditing = true;
        }
        if (messageCancel) {
            this.getCellEditor().cancelCellEditing();
            this.stopEditingInCompleteEditing = true;
        }
        if (messageTree) {
            this.treeModel.valueForPathChanged(this.tree.getLeadSelectionPath(), this.newVal);
        }
    }

    protected boolean startEditing(TreePath path, MouseEvent event) {
        if (event == null) {
            this.bounds = this.getPathBounds(this.tree, path);
            int x = this.bounds.x;
            int y = this.bounds.y;
        } else {
            int x = event.getX();
            int y = event.getY();
        }
        this.updateCellEditor();
        TreeCellEditor ed = this.getCellEditor();
        if (ed != null && ed.shouldSelectCell(event) && ed.isCellEditable(event)) {
            this.editingPath = path;
            this.editingRow = this.tree.getRowForPath(this.editingPath);
            Object val = this.editingPath.getLastPathComponent();
            this.cellEditor.addCellEditorListener(this.cellEditorListener);
            this.stopEditingInCompleteEditing = false;
            boolean expanded = this.tree.isExpanded(this.editingPath);
            this.isEditing = true;
            this.editingComponent = ed.getTreeCellEditorComponent(this.tree, val, true, expanded, this.isLeaf(this.editingRow), this.editingRow);
            this.editingComponent.getParent().setVisible(true);
            this.editingComponent.getParent().validate();
            this.tree.add(this.editingComponent.getParent());
            this.editingComponent.getParent().validate();
            this.validCachedPreferredSize = false;
            this.tree.revalidate();
            ((JTextField)this.editingComponent).requestFocusInWindow(false);
            this.editorTimer.start();
            return true;
        }
        return false;
    }

    protected void checkForClickInExpandControl(TreePath path, int mouseX, int mouseY) {
        if (this.isLocationInExpandControl(path, mouseX, mouseY)) {
            this.toggleExpandState(path);
        }
    }

    protected boolean isLocationInExpandControl(TreePath path, int mouseX, int mouseY) {
        boolean cntlClick = false;
        int row = this.getRowForPath(this.tree, path);
        if (!this.isLeaf(row)) {
            this.bounds = this.getPathBounds(this.tree, path);
            if (this.hasControlIcons() && mouseX < this.bounds.x && mouseX > this.bounds.x - this.getCurrentControlIcon(path).getIconWidth() - this.gap) {
                cntlClick = true;
            }
        }
        return cntlClick;
    }

    protected void handleExpandControlClick(TreePath path, int mouseX, int mouseY) {
        this.toggleExpandState(path);
    }

    protected void toggleExpandState(TreePath path) {
        if (this.tree.isExpanded(path)) {
            this.tree.collapsePath(path);
        } else {
            this.tree.expandPath(path);
        }
        this.updateCurrentVisiblePath();
    }

    protected boolean isToggleSelectionEvent(MouseEvent event) {
        boolean bl = false;
        if (this.tree.getSelectionModel().getSelectionMode() == 1) {
            bl = true;
        }
        return bl;
    }

    protected boolean isMultiSelectEvent(MouseEvent event) {
        boolean bl = false;
        if (this.tree.getSelectionModel().getSelectionMode() == 2) {
            bl = true;
        }
        return bl;
    }

    protected boolean isToggleEvent(MouseEvent event) {
        return true;
    }

    protected void selectPathForEvent(TreePath path, MouseEvent event) {
        if (this.isToggleSelectionEvent(event)) {
            if (this.tree.isPathSelected(path)) {
                this.tree.removeSelectionPath(path);
            } else {
                this.tree.addSelectionPath(path);
                this.tree.setAnchorSelectionPath(path);
            }
        } else if (this.isMultiSelectEvent(event)) {
            TreePath anchor = this.tree.getAnchorSelectionPath();
            if (anchor != null) {
                int aRow = this.getRowForPath(this.tree, anchor);
                this.tree.addSelectionInterval(aRow, this.getRowForPath(this.tree, path));
            } else {
                this.tree.addSelectionPath(path);
            }
        } else {
            this.tree.addSelectionPath(path);
        }
    }

    protected boolean isLeaf(int row) {
        TreePath pathForRow = this.getPathForRow(this.tree, row);
        if (pathForRow == null) {
            return true;
        }
        Object node2 = pathForRow.getLastPathComponent();
        return this.treeModel.isLeaf(node2);
    }

    Rectangle getCellBounds(int x, int y, Object cell) {
        if (cell != null) {
            String s = cell.toString();
            Font f = this.tree.getFont();
            FontMetrics fm = this.tree.getToolkit().getFontMetrics(f);
            if (s != null) {
                return new Rectangle(x, y, SwingUtilities.computeStringWidth(fm, s), fm.getHeight());
            }
        }
        return new Rectangle(x, y, 0, 0);
    }

    Point getCellLocation(int x, int y, JTree tree, TreeModel mod, Object node2, Object startNode) {
        int rowHeight = this.getRowHeight();
        if (startNode == null || startNode.equals(node2)) {
            int level = this.getLevel(node2);
            if (level == 0) {
                return new Point(x, y);
            }
            if (!tree.isRootVisible() && tree.isExpanded(new TreePath(mod.getRoot()))) {
                return new Point(x + (level - 1) * this.rightChildIndent, y);
            }
            return new Point(x + level * this.rightChildIndent, y);
        }
        return this.getCellLocation(x, y + rowHeight, tree, mod, node2, this.getNextVisibleNode(startNode));
    }

    int paintRecursive(Graphics g, int indentation, int descent, int depth, JTree tree, TreeModel mod, Object curr) {
        Rectangle clip = tree.getVisibleRect();
        if (indentation > clip.x + clip.width + this.rightChildIndent || descent > clip.y + clip.height + this.getRowHeight()) {
            return descent;
        }
        TreePath path = new TreePath(this.getPathToRoot(curr, 0));
        int halfHeight = this.getRowHeight() / 2;
        int halfWidth = this.rightChildIndent / 2;
        int y0 = descent + halfHeight;
        int heightOfLine = descent + halfHeight;
        int row = this.getRowForPath(tree, path);
        boolean isRootVisible = tree.isRootVisible();
        boolean isExpanded = tree.isExpanded(path);
        boolean isLeaf = mod.isLeaf(curr);
        Rectangle bounds = this.getPathBounds(tree, path);
        Object root = mod.getRoot();
        if (isLeaf) {
            this.paintRow(g, clip, null, bounds, path, row, true, false, true);
            descent += this.getRowHeight();
        } else {
            if (depth > 0 || isRootVisible) {
                this.paintRow(g, clip, null, bounds, path, row, isExpanded, false, false);
                descent += this.getRowHeight();
                y0 += halfHeight;
            }
            int max = mod.getChildCount(curr);
            if (isExpanded) {
                int i = 0;
                while (i < max) {
                    int indent = indentation + this.rightChildIndent;
                    if (!isRootVisible && depth == 0) {
                        indent = 0;
                    } else if (isRootVisible || !isRootVisible && !curr.equals(root)) {
                        g.setColor(this.getHashColor());
                        heightOfLine = descent + halfHeight;
                        this.paintHorizontalLine(g, tree, heightOfLine, indentation + halfWidth, indentation + this.rightChildIndent);
                    }
                    descent = this.paintRecursive(g, indent, descent, depth + 1, tree, mod, mod.getChild(curr, i));
                    ++i;
                }
            }
        }
        if (isExpanded && y0 != heightOfLine && !isLeaf && mod.getChildCount(curr) > 0) {
            g.setColor(this.getHashColor());
            this.paintVerticalLine(g, tree, indentation + halfWidth, y0, heightOfLine);
        }
        return descent;
    }

    int paintControlIcons(Graphics g, int indentation, int descent, int depth, JTree tree, TreeModel mod, Object node2) {
        int rowHeight = this.getRowHeight();
        TreePath path = new TreePath(this.getPathToRoot(node2, 0));
        Icon icon = this.getCurrentControlIcon(path);
        Rectangle clip = tree.getVisibleRect();
        if (indentation > clip.x + clip.width + this.rightChildIndent || descent > clip.y + clip.height + this.getRowHeight()) {
            return descent;
        }
        if (mod.isLeaf(node2)) {
            descent += rowHeight;
        } else {
            if (!node2.equals(mod.getRoot()) && (tree.isRootVisible() || this.getLevel(node2) != 1)) {
                int width = icon.getIconWidth();
                int height = icon.getIconHeight() + 2;
                int posX = indentation - this.rightChildIndent;
                int posY = descent;
                posX = width > this.rightChildIndent ? (posX -= this.gap) : (posX += width / 2);
                if (height < rowHeight) {
                    posY += height / 2;
                }
                icon.paintIcon(tree, g, posX, posY);
            }
            if (depth > 0 || tree.isRootVisible()) {
                descent += rowHeight;
            }
            if (tree.isExpanded(path)) {
                int max = 0;
                if (!mod.isLeaf(node2)) {
                    max = mod.getChildCount(node2);
                }
                int i = 0;
                while (i < max) {
                    int indent = indentation + this.rightChildIndent;
                    if (depth == 0 && !tree.isRootVisible()) {
                        indent = 1;
                    }
                    descent = this.paintControlIcons(g, indent, descent, depth + 1, tree, mod, mod.getChild(node2, i));
                    ++i;
                }
            }
        }
        return descent;
    }

    boolean hasControlIcons() {
        return this.expandedIcon != null || this.collapsedIcon != null;
    }

    Icon getCurrentControlIcon(TreePath path) {
        if (this.tree.isExpanded(path)) {
            return this.expandedIcon;
        }
        return this.collapsedIcon;
    }

    Object getParent(Object root, Object node2) {
        if (root == null || node2 == null) {
            return null;
        }
        if (node2 instanceof TreeNode) {
            return ((TreeNode)node2).getParent();
        }
        return this.findNode(root, node2);
    }

    private final Object findNode(Object root, Object node2) {
        int size = 0;
        if (!this.treeModel.isLeaf(root)) {
            size = this.treeModel.getChildCount(root);
        }
        int i = 0;
        while (i < size) {
            if (this.treeModel.getIndexOfChild(root, node2) != -1) {
                return root;
            }
            Object n = this.findNode(this.treeModel.getChild(root, i), node2);
            if (n != null) {
                return n;
            }
            ++i;
        }
        return null;
    }

    Object getPreviousVisibleNode(Object node2) {
        if (this.currentVisiblePath != null) {
            Object[] nodes = this.currentVisiblePath.getPath();
            int i = 0;
            while (i < nodes.length && !node2.equals(nodes[i])) {
                ++i;
            }
            if (i - 1 > 0) {
                return nodes[i - 1];
            }
        }
        return null;
    }

    Object getNextNode(Object curr) {
        if (!this.treeModel.isLeaf(curr) && this.treeModel.getChildCount(curr) > 0) {
            return this.treeModel.getChild(curr, 0);
        }
        Object node2 = curr;
        Object sibling = null;
        do {
            sibling = this.getNextSibling(node2);
            node2 = this.getParent(this.treeModel.getRoot(), node2);
        } while (sibling == null && node2 != null);
        return sibling;
    }

    Object getPreviousNode(Object node2) {
        Object parent = this.getParent(this.treeModel.getRoot(), node2);
        if (parent == null) {
            return null;
        }
        Object sibling = this.getPreviousSibling(node2);
        if (sibling == null) {
            return parent;
        }
        int size = 0;
        if (!this.treeModel.isLeaf(sibling)) {
            size = this.treeModel.getChildCount(sibling);
        }
        while (size > 0) {
            size = !this.treeModel.isLeaf(sibling = this.treeModel.getChild(sibling, size - 1)) ? this.treeModel.getChildCount(sibling) : 0;
        }
        return sibling;
    }

    Object getNextSibling(Object node2) {
        Object parent = this.getParent(this.treeModel.getRoot(), node2);
        if (parent == null) {
            return null;
        }
        int index = this.treeModel.getIndexOfChild(parent, node2) + 1;
        int size = 0;
        if (!this.treeModel.isLeaf(parent)) {
            size = this.treeModel.getChildCount(parent);
        }
        if (index == 0 || index >= size) {
            return null;
        }
        return this.treeModel.getChild(parent, index);
    }

    Object getPreviousSibling(Object node2) {
        Object parent = this.getParent(this.treeModel.getRoot(), node2);
        if (parent == null) {
            return null;
        }
        int index = this.treeModel.getIndexOfChild(parent, node2) - 1;
        int size = 0;
        if (!this.treeModel.isLeaf(parent)) {
            size = this.treeModel.getChildCount(parent);
        }
        if (index < 0 || index >= size) {
            return null;
        }
        return this.treeModel.getChild(parent, index);
    }

    void selectPath(JTree tree, TreePath path) {
        if (path != null) {
            if (tree.getSelectionModel().getSelectionMode() == 1) {
                tree.getSelectionModel().clearSelection();
                tree.addSelectionPath(path);
                tree.setLeadSelectionPath(path);
            } else if (tree.getSelectionModel().getSelectionMode() != 2) {
                tree.addSelectionPath(path);
                tree.setLeadSelectionPath(path);
                tree.getSelectionModel().setSelectionMode(4);
            }
        }
    }

    Object[] getPathToRoot(Object node2, int depth) {
        if (node2 == null) {
            if (depth == 0) {
                return null;
            }
            return new Object[depth];
        }
        Object[] path = this.getPathToRoot(this.getParent(this.treeModel.getRoot(), node2), depth + 1);
        path[path.length - depth - 1] = node2;
        return path;
    }

    int getLevel(Object node2) {
        int count = -1;
        Object current = node2;
        do {
            current = this.getParent(this.treeModel.getRoot(), current);
            ++count;
        } while (current != null);
        return count;
    }

    protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
        g.drawLine(x, top, x, bottom);
    }

    protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right) {
        g.drawLine(left, y, right, y);
    }

    protected void drawCentered(Component c, Graphics g, Icon icon, int x, int y) {
        int beginPositionX = x - icon.getIconWidth() / 2;
        int beginPositionY = y - icon.getIconHeight() / 2;
        icon.paintIcon(c, g, beginPositionX, beginPositionY);
    }

    protected void drawDashedHorizontalLine(Graphics g, int y, int x1, int x2) {
        int i = x1;
        while (i < x2) {
            g.drawLine(i, y, i + 1, y);
            i += 2;
        }
    }

    protected void drawDashedVerticalLine(Graphics g, int x, int y1, int y2) {
        int i = y1;
        while (i < y2) {
            g.drawLine(x, i, x, i + 1);
            i += 2;
        }
    }

    protected void paintExpandControl(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (this.treeModel != null && this.hasControlIcons()) {
            this.paintControlIcons(g, 0, 0, 0, this.tree, this.treeModel, path.getLastPathComponent());
        }
    }

    protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
    }

    protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
    }

    protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        boolean selected = this.tree.isPathSelected(path);
        boolean hasIcons = false;
        Object node2 = path.getLastPathComponent();
        if (this.tree.isVisible(path)) {
            bounds.width = this.preferredSize.width;
            bounds.x += this.gap;
            if (this.editingComponent != null && this.editingPath != null && this.isEditing(this.tree) && node2.equals(this.editingPath.getLastPathComponent())) {
                this.rendererPane.paintComponent(g, this.editingComponent.getParent(), null, bounds);
            } else {
                TreeCellRenderer dtcr = this.tree.getCellRenderer();
                if (dtcr == null) {
                    dtcr = this.createDefaultCellRenderer();
                }
                Component c = dtcr.getTreeCellRendererComponent(this.tree, node2, selected, isExpanded, isLeaf, row, false);
                this.rendererPane.paintComponent(g, c, c.getParent(), bounds);
            }
        }
    }

    protected void prepareForUIUninstall() {
    }

    protected boolean shouldPaintExpandControl(TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        Object node2 = path.getLastPathComponent();
        return this.treeModel != null && !isLeaf && !node2.equals(this.treeModel.getRoot()) && (this.tree.isRootVisible() || this.getLevel(node2) != 1);
    }

    void updateCurrentVisiblePath() {
        if (this.treeModel == null) {
            return;
        }
        Object next = this.treeModel.getRoot();
        Rectangle bounds = this.getCellBounds(0, 0, next);
        if (bounds.width == 0 && bounds.height == 0 || !this.isRootVisible() && this.tree.isExpanded(new TreePath(next))) {
            next = this.getNextNode(next);
        }
        TreePath current = null;
        while (next != null) {
            current = current == null ? new TreePath(next) : current.pathByAddingChild(next);
            while ((next = this.getNextNode(next)) != null && !this.tree.isVisible(new TreePath(this.getPathToRoot(next, 0)))) {
            }
        }
        this.currentVisiblePath = current;
        this.tree.setVisibleRowCount(this.getRowCount(this.tree));
        if (this.tree.getSelectionModel() != null && this.tree.getSelectionCount() == 0 && this.currentVisiblePath != null) {
            this.tree.addSelectionRow(0);
        }
    }

    Object getNextVisibleNode(Object node2) {
        if (this.currentVisiblePath != null) {
            Object[] nodes = this.currentVisiblePath.getPath();
            int i = 0;
            while (i < nodes.length && !node2.equals(nodes[i])) {
                ++i;
            }
            if (i + 1 < nodes.length) {
                return nodes[i + 1];
            }
        }
        return null;
    }

    private final /* synthetic */ void this() {
        this.editorTimer = new EditorUpdateTimer();
        this.gap = 4;
    }

    public BasicTreeUI() {
        this.this();
        this.validCachedPreferredSize = false;
        this.drawingCache = new Hashtable();
        this.nodeDimensions = this.createNodeDimensions();
        this.configureLayoutCache();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.focusListener = this.createFocusListener();
        this.treeSelectionListener = this.createTreeSelectionListener();
        this.mouseListener = this.createMouseListener();
        this.keyListener = this.createKeyListener();
        this.selectionModelPropertyChangeListener = this.createSelectionModelPropertyChangeListener();
        this.componentListener = this.createComponentListener();
        this.cellEditorListener = this.createCellEditorListener();
        this.treeExpansionListener = this.createTreeExpansionListener();
        this.treeModelListener = this.createTreeModelListener();
        this.editingRow = -1;
        this.lastSelectedRow = -1;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class NodeDimensionsHandler
    extends AbstractLayoutCache.NodeDimensions {
        public Rectangle getNodeDimensions(Object value, int row, int depth, boolean expanded, Rectangle size) {
            return null;
        }

        protected int getRowX(int row, int depth) {
            return 0;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent event) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        public void mousePressed(MouseEvent e) {
            Point click = e.getPoint();
            TreePath path = BasicTreeUI.this.getClosestPathForLocation(BasicTreeUI.this.tree, click.x, click.y);
            if (path != null) {
                boolean inBounds;
                Icon tmp;
                BasicTreeUI.this.bounds = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, path);
                int row = BasicTreeUI.this.getRowForPath(BasicTreeUI.this.tree, path);
                boolean cntlClick = BasicTreeUI.this.isLocationInExpandControl(path, click.x, click.y);
                boolean isLeaf = BasicTreeUI.this.isLeaf(row);
                TreeCellRenderer tcr = BasicTreeUI.this.getCellRenderer();
                Icon icon = isLeaf ? UIManager.getIcon("Tree.leafIcon") : (BasicTreeUI.this.tree.isExpanded(path) ? UIManager.getIcon("Tree.openIcon") : UIManager.getIcon("Tree.closedIcon"));
                if (tcr instanceof DefaultTreeCellRenderer && (tmp = ((DefaultTreeCellRenderer)tcr).getIcon()) != null) {
                    icon = tmp;
                }
                if (icon != null) {
                    BasicTreeUI.this.bounds.width += icon.getIconWidth() + BasicTreeUI.this.gap * 2;
                }
                if (((inBounds = BasicTreeUI.this.bounds.contains(click.x, click.y)) || cntlClick) && BasicTreeUI.this.tree.isVisible(path)) {
                    BasicTreeUI.this.selectPath(BasicTreeUI.this.tree, path);
                    if (inBounds && e.getClickCount() == 2 && !BasicTreeUI.this.isLeaf(row)) {
                        BasicTreeUI.this.toggleExpandState(path);
                    }
                    if (cntlClick) {
                        BasicTreeUI.this.handleExpandControlClick(path, click.x, click.y);
                        if (BasicTreeUI.this.cellEditor != null) {
                            BasicTreeUI.this.cellEditor.cancelCellEditing();
                        }
                    } else if (BasicTreeUI.this.tree.isEditable()) {
                        BasicTreeUI.this.startEditing(path, e);
                    }
                }
            }
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class KeyHandler
    extends KeyAdapter {
        protected Action repeatKeyAction;
        protected boolean isKeyDown;

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class SelectionModelPropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent event) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class TreeSelectionHandler
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent event) {
            if (BasicTreeUI.this.tree.isEditing()) {
                BasicTreeUI.this.tree.cancelEditing();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class CellEditorHandler
    implements CellEditorListener {
        public void editingStopped(ChangeEvent e) {
            BasicTreeUI.this.editingPath = null;
            BasicTreeUI.this.editingRow = -1;
            BasicTreeUI.this.stopEditingInCompleteEditing = false;
            if (BasicTreeUI.this.editingComponent != null) {
                BasicTreeUI.this.tree.remove(BasicTreeUI.this.editingComponent.getParent());
                BasicTreeUI.this.editingComponent = null;
            }
            if (BasicTreeUI.this.cellEditor != null) {
                BasicTreeUI.this.newVal = ((JTextField)BasicTreeUI.this.getCellEditor().getCellEditorValue()).getText();
                BasicTreeUI.this.completeEditing(false, false, true);
                if (BasicTreeUI.this.cellEditor instanceof DefaultTreeCellEditor) {
                    BasicTreeUI.this.tree.removeTreeSelectionListener((DefaultTreeCellEditor)BasicTreeUI.this.cellEditor);
                }
                BasicTreeUI.this.cellEditor.removeCellEditorListener(BasicTreeUI.this.cellEditorListener);
                BasicTreeUI.this.setCellEditor(null);
                BasicTreeUI.this.createdCellEditor = false;
            }
            BasicTreeUI.this.isEditing = false;
            BasicTreeUI.this.tree.requestFocusInWindow(false);
            BasicTreeUI.this.editorTimer.stop();
            BasicTreeUI.this.validCachedPreferredSize = false;
            BasicTreeUI.this.tree.revalidate();
            BasicTreeUI.this.tree.repaint();
        }

        public void editingCanceled(ChangeEvent e) {
            BasicTreeUI.this.editingPath = null;
            BasicTreeUI.this.editingRow = -1;
            BasicTreeUI.this.stopEditingInCompleteEditing = false;
            if (BasicTreeUI.this.editingComponent != null) {
                BasicTreeUI.this.tree.remove(BasicTreeUI.this.editingComponent.getParent());
            }
            BasicTreeUI.this.editingComponent = null;
            if (BasicTreeUI.this.cellEditor != null) {
                if (BasicTreeUI.this.cellEditor instanceof DefaultTreeCellEditor) {
                    BasicTreeUI.this.tree.removeTreeSelectionListener((DefaultTreeCellEditor)BasicTreeUI.this.cellEditor);
                }
                BasicTreeUI.this.cellEditor.removeCellEditorListener(BasicTreeUI.this.cellEditorListener);
                BasicTreeUI.this.setCellEditor(null);
                BasicTreeUI.this.createdCellEditor = false;
            }
            BasicTreeUI.this.tree.requestFocusInWindow(false);
            BasicTreeUI.this.editorTimer.stop();
            BasicTreeUI.this.isEditing = false;
            BasicTreeUI.this.validCachedPreferredSize = false;
            BasicTreeUI.this.tree.revalidate();
            BasicTreeUI.this.tree.repaint();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ComponentHandler
    extends ComponentAdapter
    implements ActionListener {
        protected Timer timer;
        protected JScrollBar scrollBar;

        public void componentMoved(ComponentEvent e) {
        }

        protected void startTimer() {
        }

        protected JScrollPane getScrollPane() {
            return null;
        }

        public void actionPerformed(ActionEvent ae) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class TreeExpansionHandler
    implements TreeExpansionListener {
        public void treeExpanded(TreeExpansionEvent event) {
            BasicTreeUI.this.validCachedPreferredSize = false;
            BasicTreeUI.this.updateCurrentVisiblePath();
            BasicTreeUI.this.tree.revalidate();
            BasicTreeUI.this.tree.repaint();
        }

        public void treeCollapsed(TreeExpansionEvent event) {
            BasicTreeUI.this.validCachedPreferredSize = false;
            BasicTreeUI.this.updateCurrentVisiblePath();
            BasicTreeUI.this.tree.revalidate();
            BasicTreeUI.this.tree.repaint();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class TreeModelHandler
    implements TreeModelListener {
        public void treeNodesChanged(TreeModelEvent e) {
            BasicTreeUI.this.validCachedPreferredSize = false;
            BasicTreeUI.this.updateCurrentVisiblePath();
            BasicTreeUI.this.tree.revalidate();
            BasicTreeUI.this.tree.repaint();
        }

        public void treeNodesInserted(TreeModelEvent e) {
            BasicTreeUI.this.validCachedPreferredSize = false;
            BasicTreeUI.this.updateCurrentVisiblePath();
            BasicTreeUI.this.tree.revalidate();
            BasicTreeUI.this.tree.repaint();
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            BasicTreeUI.this.validCachedPreferredSize = false;
            BasicTreeUI.this.updateCurrentVisiblePath();
            BasicTreeUI.this.tree.revalidate();
            BasicTreeUI.this.tree.repaint();
        }

        public void treeStructureChanged(TreeModelEvent e) {
            BasicTreeUI.this.validCachedPreferredSize = false;
            BasicTreeUI.this.updateCurrentVisiblePath();
            BasicTreeUI.this.tree.revalidate();
            BasicTreeUI.this.tree.repaint();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class TreeAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            TreePath lead = BasicTreeUI.this.tree.getLeadSelectionPath();
            if (e.getActionCommand().equals("selectPreviousChangeLead") || e.getActionCommand().equals("selectPreviousExtendSelection") || e.getActionCommand().equals("selectPrevious") || e.getActionCommand().equals("selectNext") || e.getActionCommand().equals("selectNextExtendSelection") || e.getActionCommand().equals("selectNextChangeLead")) {
                new TreeIncrementAction(0, "").actionPerformed(e);
            } else if (e.getActionCommand().equals("selectParent") || e.getActionCommand().equals("selectChild")) {
                new TreeTraverseAction(0, "").actionPerformed(e);
            } else if (e.getActionCommand().equals("selectAll")) {
                TreePath[] paths = new TreePath[BasicTreeUI.this.tree.getVisibleRowCount()];
                Object curr = BasicTreeUI.this.getNextVisibleNode(BasicTreeUI.this.treeModel.getRoot());
                int i = 0;
                while (curr != null && i < paths.length) {
                    paths[i] = new TreePath(BasicTreeUI.this.getPathToRoot(curr, 0));
                    ++i;
                }
                BasicTreeUI.this.tree.addSelectionPaths(paths);
            } else if (e.getActionCommand().equals("startEditing")) {
                BasicTreeUI.this.tree.startEditingAtPath(lead);
            } else if (e.getActionCommand().equals("toggle")) {
                if (BasicTreeUI.this.tree.isEditing()) {
                    BasicTreeUI.this.tree.stopEditing();
                } else {
                    Object last = lead.getLastPathComponent();
                    TreePath path = new TreePath(BasicTreeUI.this.getPathToRoot(last, 0));
                    if (!BasicTreeUI.this.treeModel.isLeaf(last)) {
                        BasicTreeUI.this.toggleExpandState(path);
                    }
                }
            } else if (e.getActionCommand().equals("clearSelection")) {
                BasicTreeUI.this.tree.clearSelection();
            }
            if (BasicTreeUI.this.tree.isEditing() && !e.getActionCommand().equals("startEditing")) {
                BasicTreeUI.this.tree.cancelEditing();
            }
            BasicTreeUI.this.tree.scrollPathToVisible(lead);
        }

        TreeAction() {
        }
    }

    private static class ActionListenerProxy
    extends AbstractAction {
        ActionListener target;
        String bindingCommandName;

        public void actionPerformed(ActionEvent e) {
            ActionEvent derivedEvent = new ActionEvent(e.getSource(), e.getID(), this.bindingCommandName, e.getModifiers());
            this.target.actionPerformed(derivedEvent);
        }

        public ActionListenerProxy(ActionListener li, String cmd) {
            this.target = li;
            this.bindingCommandName = cmd;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class EditorUpdateTimer
    extends Timer
    implements ActionListener {
        public void actionPerformed(ActionEvent ev) {
            Caret c = ((JTextField)BasicTreeUI.this.editingComponent).getCaret();
            if (c != null) {
                c.setVisible(c.isVisible() ^ true);
            }
            BasicTreeUI.this.tree.repaint();
        }

        public void update() {
            this.stop();
            Caret c = ((JTextField)BasicTreeUI.this.editingComponent).getCaret();
            if (c != null) {
                this.setDelay(c.getBlinkRate());
                if (((JTextField)BasicTreeUI.this.editingComponent).isEditable()) {
                    this.start();
                } else {
                    c.setVisible(false);
                }
            }
        }

        public EditorUpdateTimer() {
            super(300, null);
            this.addActionListener(this);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class TreeTraverseAction
    extends AbstractAction {
        protected int direction;

        public void actionPerformed(ActionEvent e) {
            Object last = BasicTreeUI.this.tree.getLeadSelectionPath().getLastPathComponent();
            if (e.getActionCommand().equals("selectParent")) {
                TreePath path = new TreePath(BasicTreeUI.this.getPathToRoot(last, 0));
                Object p = BasicTreeUI.this.getParent(BasicTreeUI.this.treeModel.getRoot(), last);
                if (!BasicTreeUI.this.treeModel.isLeaf(last)) {
                    BasicTreeUI.this.toggleExpandState(path);
                } else if (p != null) {
                    BasicTreeUI.this.selectPath(BasicTreeUI.this.tree, new TreePath(BasicTreeUI.this.getPathToRoot(p, 0)));
                }
            } else if (e.getActionCommand().equals("selectChild")) {
                TreePath path = new TreePath(BasicTreeUI.this.getPathToRoot(last, 0));
                if (!BasicTreeUI.this.treeModel.isLeaf(last)) {
                    BasicTreeUI.this.toggleExpandState(path);
                } else {
                    Object next = BasicTreeUI.this.getNextVisibleNode(last);
                    if (next != null) {
                        BasicTreeUI.this.selectPath(BasicTreeUI.this.tree, new TreePath(BasicTreeUI.this.getPathToRoot(next, 0)));
                    }
                }
            }
        }

        public boolean isEnabled() {
            return false;
        }

        public TreeTraverseAction(int direction, String name) {
            this.direction = direction;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class TreeToggleAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
        }

        public boolean isEnabled() {
            return false;
        }

        public TreeToggleAction(String name) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class TreePageAction
    extends AbstractAction {
        protected int direction;

        public void actionPerformed(ActionEvent e) {
        }

        public boolean isEnabled() {
            return false;
        }

        public TreePageAction(int direction, String name) {
            this.direction = direction;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class TreeIncrementAction
    extends AbstractAction {
        protected int direction;

        public void actionPerformed(ActionEvent e) {
            Object next;
            Object last = BasicTreeUI.this.tree.getLeadSelectionPath().getLastPathComponent();
            if (e.getActionCommand().equals("selectPreviousChangeLead")) {
                Object prev = BasicTreeUI.this.getPreviousVisibleNode(last);
                if (prev != null) {
                    TreePath newPath = new TreePath(BasicTreeUI.this.getPathToRoot(prev, 0));
                    BasicTreeUI.this.selectPath(BasicTreeUI.this.tree, newPath);
                    BasicTreeUI.this.tree.setLeadSelectionPath(newPath);
                }
            } else if (e.getActionCommand().equals("selectPreviousExtendSelection")) {
                Object prev = BasicTreeUI.this.getPreviousVisibleNode(last);
                if (prev != null) {
                    TreePath newPath = new TreePath(BasicTreeUI.this.getPathToRoot(prev, 0));
                    BasicTreeUI.this.tree.addSelectionPath(newPath);
                    BasicTreeUI.this.tree.setLeadSelectionPath(newPath);
                }
            } else if (e.getActionCommand().equals("selectPrevious")) {
                Object prev = BasicTreeUI.this.getPreviousVisibleNode(last);
                if (prev != null) {
                    TreePath newPath = new TreePath(BasicTreeUI.this.getPathToRoot(prev, 0));
                    BasicTreeUI.this.selectPath(BasicTreeUI.this.tree, newPath);
                }
            } else if (e.getActionCommand().equals("selectNext")) {
                Object next2 = BasicTreeUI.this.getNextVisibleNode(last);
                if (next2 != null) {
                    TreePath newPath = new TreePath(BasicTreeUI.this.getPathToRoot(next2, 0));
                    BasicTreeUI.this.selectPath(BasicTreeUI.this.tree, newPath);
                }
            } else if (e.getActionCommand().equals("selectNextExtendSelection")) {
                Object next3 = BasicTreeUI.this.getNextVisibleNode(last);
                if (next3 != null) {
                    TreePath newPath = new TreePath(BasicTreeUI.this.getPathToRoot(next3, 0));
                    BasicTreeUI.this.tree.addSelectionPath(newPath);
                    BasicTreeUI.this.tree.setLeadSelectionPath(newPath);
                }
            } else if (e.getActionCommand().equals("selectNextChangeLead") && (next = BasicTreeUI.this.getNextVisibleNode(last)) != null) {
                TreePath newPath = new TreePath(BasicTreeUI.this.getPathToRoot(next, 0));
                BasicTreeUI.this.selectPath(BasicTreeUI.this.tree, newPath);
                BasicTreeUI.this.tree.setLeadSelectionPath(newPath);
            }
        }

        public boolean isEnabled() {
            return false;
        }

        public TreeIncrementAction(int direction, String name) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class TreeHomeAction
    extends AbstractAction {
        protected int direction;

        public void actionPerformed(ActionEvent e) {
        }

        public boolean isEnabled() {
            return false;
        }

        public TreeHomeAction(int direction, String name) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class TreeCancelEditingAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
        }

        public boolean isEnabled() {
            return false;
        }

        public TreeCancelEditingAction(String name) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class MouseInputHandler
    implements MouseInputListener {
        protected Component source;
        protected Component destination;

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        protected void removeFromSource() {
        }

        public MouseInputHandler(Component source, Component destination, MouseEvent e) {
            this.source = source;
            this.destination = destination;
        }
    }
}

