/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import java.awt.AlphaComposite;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public final class SkinPopupMenuUI
extends BasicPopupMenuUI {
    PopupMenuListener m_PopupListener;
    AncestorListener m_AncestorListener;
    private Skin skin = SkinLookAndFeel.getSkin();

    public void installDefaults() {
        super.installDefaults();
        this.skin.getPersonality().installSkin(this.popupMenu);
        if (Boolean.TRUE.equals(UIManager.get("PopupMenu.animation"))) {
            this.popupMenu.setOpaque(false);
        }
    }

    public void installListeners() {
        super.installListeners();
        if (Boolean.TRUE.equals(UIManager.get("PopupMenu.animation"))) {
            this.m_AncestorListener = new SkinPopupAncestorListener();
            this.popupMenu.addAncestorListener(this.m_AncestorListener);
            this.m_PopupListener = new SkinPopupMenuListener();
            this.popupMenu.addPopupMenuListener(this.m_PopupListener);
        }
    }

    public void paint(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g;
        AlphaComposite alpha = (AlphaComposite)c.getClientProperty("alpha");
        if (alpha != null) {
            g2d.setComposite(alpha);
        }
        this.skin.getPersonality().paintDialog(g, c);
        super.paint(g, c);
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.popupMenu.setOpaque(true);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.m_AncestorListener != null) {
            this.popupMenu.removeAncestorListener(this.m_AncestorListener);
        }
        if (this.m_PopupListener != null) {
            this.popupMenu.removePopupMenuListener(this.m_PopupListener);
        }
        this.popupMenu.putClientProperty("alpha", null);
    }

    public static ComponentUI createUI(JComponent c) {
        return new SkinPopupMenuUI();
    }

    public JPopupMenu popupMenu() {
        return this.popupMenu;
    }

    class SkinPopupMenuListener
    implements PopupMenuListener {
        AlphaComposite current;
        Timer timer = new Timer(25, new ActionListener(this){
            private final /* synthetic */ SkinPopupMenuListener this$1;
            {
                this.this$1 = this$1;
            }

            public void actionPerformed(ActionEvent e) {
                if (this.this$1.current == null || (double)this.this$1.current.getAlpha() >= 0.75) {
                    this.this$1.timer.stop();
                } else {
                    this.this$1.current = AlphaComposite.getInstance(this.this$1.current.getRule(), this.this$1.current.getAlpha() + 0.05f);
                    SkinPopupMenuListener.access$000(this.this$1).popupMenu().putClientProperty("alpha", this.this$1.current);
                    SkinPopupMenuListener.access$000(this.this$1).popupMenu().repaint();
                }
            }
        });

        SkinPopupMenuListener() {
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
            this.timer.stop();
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            this.timer.stop();
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.current = AlphaComposite.getInstance(3, 0.0f);
            this.timer.start();
        }

        static /* synthetic */ SkinPopupMenuUI access$000(SkinPopupMenuListener x0) {
            return x0.SkinPopupMenuUI.this;
        }
    }

    class SkinPopupAncestorListener
    implements AncestorListener {
        SkinPopupAncestorListener() {
        }

        public void ancestorAdded(AncestorEvent event) {
            Container parent = event.getComponent().getParent();
            if (parent instanceof JComponent) {
                ((JComponent)parent).setDoubleBuffered(false);
                ((JComponent)parent).setOpaque(false);
            }
        }

        public void ancestorMoved(AncestorEvent event) {
        }

        public void ancestorRemoved(AncestorEvent event) {
        }
    }
}

