/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.demos.perspective;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import org.flexdock.demos.util.DemoUtility;
import org.flexdock.docking.DockableFactory;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.state.PersistenceException;
import org.flexdock.perspective.LayoutSequence;
import org.flexdock.perspective.Perspective;
import org.flexdock.perspective.PerspectiveFactory;
import org.flexdock.perspective.PerspectiveManager;
import org.flexdock.perspective.actions.OpenPerspectiveAction;
import org.flexdock.perspective.persist.FilePersistenceHandler;
import org.flexdock.util.ResourceManager;
import org.flexdock.util.SwingUtility;
import org.flexdock.view.View;
import org.flexdock.view.Viewport;
import org.flexdock.view.actions.DefaultDisplayAction;

public class PerspectivesDemo
extends JFrame
implements DockingConstants {
    public static final String PERSPECTIVE_FILE = "PerspectiveDemo.data";
    private static final String MAIN_VIEW = "main.view";
    private static final String BIRD_VIEW = "bird.view";
    private static final String MESSAGE_VIEW = "message.log";
    private static final String PROBLEM_VIEW = "problem";
    private static final String CONSOLE_VIEW = "console";
    private static final String P1 = "p1";
    private static final String P2 = "p2";
    private static final String P3 = "p3";

    public static void main(String[] args) {
        SwingUtility.setPlaf(UIManager.getSystemLookAndFeelClassName());
        PerspectivesDemo.configureDocking();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                PerspectivesDemo.runGUI();
            }
        });
    }

    private static void runGUI() {
        PerspectivesDemo flexDockDemo = new PerspectivesDemo();
        flexDockDemo.setSize(800, 600);
        SwingUtility.centerOnScreen(flexDockDemo);
        DemoUtility.setCloseOperation(flexDockDemo);
        DockingManager.restoreLayout();
        flexDockDemo.setVisible(true);
    }

    public PerspectivesDemo() {
        super("FlexDock Demo");
        this.setContentPane(this.createContentPane());
        this.setJMenuBar(this.createApplicationMenuBar());
    }

    private JPanel createContentPane() {
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Viewport viewport = new Viewport();
        contentPane.add((Component)viewport, "Center");
        return contentPane;
    }

    private JMenuBar createApplicationMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu showViewMenu = new JMenu("Show View");
        showViewMenu.add(new DefaultDisplayAction(BIRD_VIEW));
        showViewMenu.add(new DefaultDisplayAction(MESSAGE_VIEW));
        showViewMenu.add(new DefaultDisplayAction(PROBLEM_VIEW));
        showViewMenu.add(new DefaultDisplayAction(CONSOLE_VIEW));
        JMenu perspectiveMenu = new JMenu("Perspective");
        perspectiveMenu.add(new OpenPerspectiveAction(P1));
        perspectiveMenu.add(new OpenPerspectiveAction(P2));
        perspectiveMenu.add(new OpenPerspectiveAction(P3));
        menuBar.add(showViewMenu);
        menuBar.add(perspectiveMenu);
        return menuBar;
    }

    private static void configureDocking() {
        DockingManager.setDockableFactory(new ViewFactory());
        DockingManager.setFloatingEnabled(true);
        PerspectiveManager.setFactory(new DemoPerspectiveFactory());
        PerspectiveManager.setRestoreFloatingOnLoad(true);
        PerspectiveManager mgr = PerspectiveManager.getInstance();
        mgr.setCurrentPerspective(P3, true);
        FilePersistenceHandler persister = FilePersistenceHandler.createDefault(PERSPECTIVE_FILE);
        PerspectiveManager.setPersistenceHandler(persister);
        try {
            DockingManager.loadLayoutModel();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (PersistenceException e) {
            e.printStackTrace();
        }
        DockingManager.setAutoPersist(true);
    }

    private static class ViewFactory
    extends DockableFactory.Stub {
        private ViewFactory() {
        }

        public Component getDockableComponent(String dockableId) {
            if (PerspectivesDemo.MAIN_VIEW.equals(dockableId)) {
                return ViewFactory.createMainView();
            }
            if (PerspectivesDemo.BIRD_VIEW.equals(dockableId)) {
                return this.createView(PerspectivesDemo.BIRD_VIEW, "Bird View", "birdView001.png");
            }
            if (PerspectivesDemo.MESSAGE_VIEW.equals(dockableId)) {
                return this.createView(PerspectivesDemo.MESSAGE_VIEW, "Message Log", "msgLog001.png");
            }
            if (PerspectivesDemo.PROBLEM_VIEW.equals(dockableId)) {
                return this.createView(PerspectivesDemo.PROBLEM_VIEW, "Problems", "problems001.png");
            }
            if (PerspectivesDemo.CONSOLE_VIEW.equals(dockableId)) {
                return this.createView(PerspectivesDemo.CONSOLE_VIEW, "Console", "console001.png");
            }
            return null;
        }

        private View createView(String id, String text, String iconName) {
            View view = new View(id, text);
            view.addAction("close");
            view.addAction("pin");
            JPanel panel = new JPanel();
            panel.setBorder(new LineBorder(Color.GRAY, 1));
            JTextField textField = new JTextField(text);
            textField.setPreferredSize(new Dimension(100, 20));
            panel.add(textField);
            view.setContentPane(panel);
            ImageIcon icon = ResourceManager.createIcon("org/flexdock/demos/view/" + iconName);
            view.setTabIcon(icon);
            return view;
        }

        private static View createMainView() {
            JTabbedPane tabbedPane = new JTabbedPane();
            tabbedPane.addTab("Sample1", new JTextArea("Sample1"));
            tabbedPane.addTab("Sample2", new JTextArea("Sample2"));
            tabbedPane.addTab("Sample3", new JTextArea("Sample3"));
            View mainView = new View(PerspectivesDemo.MAIN_VIEW, null, null);
            mainView.setTerritoryBlocked("CENTER", true);
            mainView.setTitlebar(null);
            mainView.setContentPane(new JScrollPane(tabbedPane));
            return mainView;
        }
    }

    private static class DemoPerspectiveFactory
    implements PerspectiveFactory {
        private DemoPerspectiveFactory() {
        }

        public Perspective getPerspective(String persistentId) {
            if (PerspectivesDemo.P1.equals(persistentId)) {
                return this.createPerspective1();
            }
            if (PerspectivesDemo.P2.equals(persistentId)) {
                return this.createPerspective2();
            }
            if (PerspectivesDemo.P3.equals(persistentId)) {
                return this.createPerspective3();
            }
            return null;
        }

        private Perspective createPerspective1() {
            Perspective perspective = new Perspective(PerspectivesDemo.P1, "Perspective1");
            LayoutSequence sequence = perspective.getInitialSequence(true);
            sequence.add(PerspectivesDemo.MAIN_VIEW);
            sequence.add(PerspectivesDemo.BIRD_VIEW, PerspectivesDemo.MAIN_VIEW, "EAST", 0.3f);
            sequence.add(PerspectivesDemo.MESSAGE_VIEW, PerspectivesDemo.MAIN_VIEW, "WEST", 0.3f);
            sequence.add(PerspectivesDemo.PROBLEM_VIEW, PerspectivesDemo.MESSAGE_VIEW);
            sequence.add(PerspectivesDemo.CONSOLE_VIEW, PerspectivesDemo.MESSAGE_VIEW);
            return perspective;
        }

        private Perspective createPerspective2() {
            Perspective perspective = new Perspective(PerspectivesDemo.P2, "Perspective2");
            LayoutSequence sequence = perspective.getInitialSequence(true);
            sequence.add(PerspectivesDemo.MAIN_VIEW);
            sequence.add(PerspectivesDemo.BIRD_VIEW, PerspectivesDemo.MAIN_VIEW, "WEST", 0.3f);
            sequence.add(PerspectivesDemo.MESSAGE_VIEW, PerspectivesDemo.BIRD_VIEW, "SOUTH", 0.5f);
            sequence.add(PerspectivesDemo.PROBLEM_VIEW, PerspectivesDemo.MESSAGE_VIEW);
            sequence.add(PerspectivesDemo.CONSOLE_VIEW, PerspectivesDemo.MESSAGE_VIEW, "EAST", 0.5f);
            return perspective;
        }

        private Perspective createPerspective3() {
            Perspective perspective = new Perspective(PerspectivesDemo.P3, "Perspective3");
            LayoutSequence sequence = perspective.getInitialSequence(true);
            sequence.add(PerspectivesDemo.MAIN_VIEW);
            return perspective;
        }
    }
}

