/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.audio.midi;

import com.sun.media.BasicController;
import com.sun.media.BasicPlayer;
import com.sun.media.Log;
import com.sun.media.controls.GainControlAdapter;
import com.sun.media.parser.BasicPullParser;
import com.sun.media.parser.BasicTrack;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Duration;
import javax.media.DurationUpdateEvent;
import javax.media.EndOfMediaEvent;
import javax.media.IncompatibleSourceException;
import javax.media.StopByRequestEvent;
import javax.media.SystemTimeBase;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.Track;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullSourceStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;

public class Handler
extends BasicPlayer {
    private MidiController controller = new MidiController();
    protected DataSource datasource = null;
    private boolean closed = false;
    private int META_EVENT_END_OF_MEDIA = 47;
    private Control[] controls = null;

    public Handler() {
        this.manageController(this.controller);
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        super.setSource(source);
        this.controller.setSource(source);
    }

    protected boolean audioEnabled() {
        return true;
    }

    protected boolean videoEnabled() {
        return false;
    }

    protected TimeBase getMasterTimeBase() {
        return this.controller.getMasterTimeBase();
    }

    public void updateStats() {
    }

    static /* synthetic */ Control[] access$202(Handler x0, Control[] x1) {
        x0.controls = x1;
        return x1;
    }

    class MidiFileInputStream
    extends InputStream {
        private int length;
        private int index = 0;
        private byte[] data;
        private int markpos = 0;

        MidiFileInputStream(byte[] data, int length) {
            this.data = data;
            this.length = length;
        }

        public void rewind() {
            this.index = 0;
            this.markpos = 0;
        }

        public int read() throws IOException {
            if (this.index >= this.length) {
                return -1;
            }
            return this.data[this.index++];
        }

        public int available() throws IOException {
            return this.length - this.index;
        }

        public int read(byte[] b2) throws IOException {
            return this.read(b2, 0, b2.length);
        }

        public int read(byte[] b2, int off, int len) throws IOException {
            if (len > this.available()) {
                len = this.available();
            }
            if (len == 0) {
                return -1;
            }
            System.arraycopy(this.data, this.index, b2, off, len);
            this.index += len;
            return len;
        }
    }

    class MidiParser
    extends BasicPullParser {
        MidiParser() {
        }

        public ContentDescriptor[] getSupportedInputContentDescriptors() {
            return null;
        }

        public PullSourceStream getStream() {
            PullSourceStream stream = (PullSourceStream)this.streams[0];
            return stream;
        }

        public Track[] getTracks() throws IOException, BadHeaderException {
            return null;
        }

        public Time setPosition(Time where, int rounding) {
            return null;
        }

        public Time getMediaTime() {
            return null;
        }

        public Time getDuration() {
            return null;
        }

        public String getName() {
            return "Parser for MIDI file format";
        }
    }

    class MidiController
    extends BasicController
    implements MetaEventListener {
        private MidiParser midiParser;
        private Track track = null;
        private Buffer buffer = new Buffer();
        private PullSourceStream stream;
        private Sequencer sequencer = null;
        private Synthesizer synthesizer = null;
        protected MidiChannel[] channels;
        private Sequence sequence = null;
        private byte[] mididata = null;
        private MidiFileInputStream is = null;
        private Time duration = Duration.DURATION_UNKNOWN;
        private GCA gc;

        MidiController() {
        }

        protected boolean isConfigurable() {
            return false;
        }

        public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
            this.midiParser = new MidiParser();
            this.midiParser.setSource(source);
            Handler.this.datasource = source;
        }

        protected TimeBase getMasterTimeBase() {
            return new SystemTimeBase();
        }

        protected boolean doRealize() {
            int bufferSize;
            long maxLocation;
            if (Handler.this.datasource == null) {
                return false;
            }
            try {
                Handler.this.datasource.start();
            }
            catch (IOException e2) {
                return false;
            }
            this.stream = this.midiParser.getStream();
            long contentLength = this.stream.getContentLength();
            long minLocation = 0L;
            minLocation = 0L;
            if (contentLength != -1L) {
                maxLocation = contentLength;
                bufferSize = (int)contentLength;
            } else {
                maxLocation = Long.MAX_VALUE;
                bufferSize = (int)maxLocation;
            }
            int numBuffers = 1;
            this.track = new BasicTrack(this.midiParser, null, true, Duration.DURATION_UNKNOWN, new Time(0L), numBuffers, bufferSize, this.stream, minLocation, maxLocation);
            return true;
        }

        protected boolean doPrefetch() {
            if (this.track == null) {
                return false;
            }
            if (this.sequencer == null) {
                try {
                    this.sequencer = MidiSystem.getSequencer();
                    if (this.sequencer instanceof Synthesizer) {
                        this.synthesizer = (Synthesizer)((Object)this.sequencer);
                        this.channels = this.synthesizer.getChannels();
                    }
                }
                catch (MidiUnavailableException e2) {
                    return false;
                }
                this.sequencer.addMetaEventListener(this);
            }
            if (this.buffer.getLength() == 0) {
                this.track.readFrame(this.buffer);
                if (this.buffer.isDiscard() || this.buffer.isEOM()) {
                    this.buffer.setLength(0);
                    return false;
                }
                this.mididata = (byte[])this.buffer.getData();
                this.is = new MidiFileInputStream(this.mididata, this.buffer.getLength());
            }
            MidiController midiController = this;
            synchronized (midiController) {
                if (this.is != null) {
                    try {
                        this.is.rewind();
                    }
                    catch (Exception e3) {}
                } else {
                    boolean e3 = false;
                    return e3;
                }
            }
            try {
                this.sequencer.open();
            }
            catch (MidiUnavailableException e4) {
                Log.error("Cannot open sequencer " + e4 + "\n");
                return false;
            }
            catch (Exception e5) {
                Log.error("Cannot open sequencer " + e5 + "\n");
                return false;
            }
            try {
                this.sequencer.setSequence(new BufferedInputStream(this.is));
                long durationNano = this.sequencer.getMicrosecondLength() * 1000L;
                this.duration = new Time(durationNano);
            }
            catch (InvalidMidiDataException e6) {
                Log.error("Invalid Midi Data " + e6 + "\n");
                this.sequencer.close();
                return false;
            }
            catch (Exception e7) {
                Log.error("Error setting sequence " + e7 + "\n");
                this.sequencer.close();
                return false;
            }
            return true;
        }

        protected void abortRealize() {
        }

        protected void abortPrefetch() {
            if (this.sequencer != null && this.sequencer.isOpen()) {
                this.sequencer.close();
            }
        }

        protected void doStart() {
            if (this.sequencer == null) {
                return;
            }
            if (!this.sequencer.isOpen()) {
                return;
            }
            this.sequencer.start();
        }

        protected void doStop() {
            if (this.sequencer == null) {
                return;
            }
            this.sequencer.stop();
            this.sendEvent(new StopByRequestEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
        }

        protected void doDeallocate() {
            if (this.sequencer == null) {
                return;
            }
            MidiController midiController = this;
            synchronized (midiController) {
                try {
                    this.sequencer.close();
                }
                catch (Exception e2) {
                    Log.error("Exception when deallocating: " + e2 + "\n");
                }
            }
        }

        protected void doClose() {
            if (Handler.this.closed) {
                return;
            }
            this.doDeallocate();
            if (Handler.this.datasource != null) {
                Handler.this.datasource.disconnect();
            }
            Handler.this.datasource = null;
            this.sequencer.removeMetaEventListener(this);
            Handler.this.closed = true;
            super.doClose();
        }

        protected float doSetRate(float factor) {
            if (this.sequencer != null) {
                this.sequencer.setTempoFactor(factor);
                return this.sequencer.getTempoFactor();
            }
            return 1.0f;
        }

        protected void doSetMediaTime(Time when) {
            if (when != null && this.sequencer != null) {
                this.sequencer.setMicrosecondPosition(when.getNanoseconds() / 1000L);
            }
        }

        public void meta(MetaMessage me) {
            if (me.getType() != Handler.this.META_EVENT_END_OF_MEDIA) {
                return;
            }
            if (this.sequencer != null && this.sequencer.isOpen()) {
                this.stopControllerOnly();
                this.sequencer.stop();
                if (this.duration == Duration.DURATION_UNKNOWN) {
                    this.duration = this.getMediaTime();
                    this.sendEvent(new DurationUpdateEvent(this, this.duration));
                }
                this.sendEvent(new EndOfMediaEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
            }
        }

        public Time getDuration() {
            return this.duration;
        }

        public Control[] getControls() {
            if (Handler.this.controls == null) {
                Handler.access$202(Handler.this, new Control[1]);
                this.gc = new GCA();
                ((Handler)Handler.this).controls[0] = this.gc;
            }
            return Handler.this.controls;
        }

        public void gainChange(float g2) {
            if (this.channels == null || this.gc == null) {
                return;
            }
            float level = this.gc.getLevel();
            int i2 = 0;
            while (i2 < this.channels.length) {
                this.channels[i2].controlChange(7, (int)((double)level * 127.0));
                ++i2;
            }
        }

        public void muteChange(boolean muted) {
            if (this.channels == null) {
                return;
            }
            int i2 = 0;
            while (i2 < this.channels.length) {
                this.channels[i2].setMute(muted);
                ++i2;
            }
        }

        class GCA
        extends GainControlAdapter {
            GCA() {
                super(1.0f);
            }

            public void setMute(boolean mute) {
                super.setMute(mute);
                MidiController.this.muteChange(mute);
            }

            public float setLevel(float g2) {
                float level = super.setLevel(g2);
                MidiController.this.gainChange(g2);
                return level;
            }
        }
    }
}

