/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.controls;

import com.sun.media.Reparentable;
import java.awt.Component;
import javax.media.Format;
import javax.media.Player;
import javax.media.Time;
import javax.media.Track;
import javax.media.control.FramePositioningControl;
import javax.media.format.VideoFormat;

public class FramePositioningAdapter
implements FramePositioningControl,
Reparentable {
    Object owner;
    Player player;
    Track master = null;
    long frameStep = -1L;

    public static Track getMasterTrack(Track[] tracks) {
        Track master = null;
        float rate = -1.0f;
        int i2 = 0;
        while (i2 < tracks.length) {
            Format f2;
            if (tracks[i2] != null && (f2 = tracks[i2].getFormat()) != null && f2 instanceof VideoFormat) {
                master = tracks[i2];
                rate = ((VideoFormat)f2).getFrameRate();
                if (rate != -1.0f && rate != 0.0f) {
                    return master;
                }
            }
            ++i2;
        }
        if (master != null && master.mapTimeToFrame(new Time(0L)) != Integer.MAX_VALUE) {
            return master;
        }
        return null;
    }

    public FramePositioningAdapter(Player p, Track track) {
        float rate;
        this.player = p;
        this.master = track;
        Format f2 = track.getFormat();
        if (f2 instanceof VideoFormat && (rate = ((VideoFormat)f2).getFrameRate()) != -1.0f && rate != 0.0f) {
            this.frameStep = (long)(1.0E9f / rate);
        }
    }

    public int seek(int frameNumber) {
        Time seekTo = this.master.mapFrameToTime(frameNumber);
        if (seekTo != null && seekTo != FramePositioningControl.TIME_UNKNOWN) {
            this.player.setMediaTime(seekTo);
            return this.master.mapTimeToFrame(seekTo);
        }
        return Integer.MAX_VALUE;
    }

    public int skip(int framesToSkip) {
        if (this.frameStep != -1L) {
            long t = this.player.getMediaNanoseconds() + (long)framesToSkip * this.frameStep;
            this.player.setMediaTime(new Time(t));
            return framesToSkip;
        }
        int currentFrame = this.master.mapTimeToFrame(this.player.getMediaTime());
        if (currentFrame != 0 && currentFrame != Integer.MAX_VALUE) {
            int newFrame = this.seek(currentFrame + framesToSkip);
            return newFrame - currentFrame;
        }
        return Integer.MAX_VALUE;
    }

    public Time mapFrameToTime(int frameNumber) {
        return this.master.mapFrameToTime(frameNumber);
    }

    public int mapTimeToFrame(Time mediaTime) {
        return this.master.mapTimeToFrame(mediaTime);
    }

    public Component getControlComponent() {
        return null;
    }

    public Object getOwner() {
        if (this.owner == null) {
            return this;
        }
        return this.owner;
    }

    public void setOwner(Object newOwner) {
        this.owner = newOwner;
    }
}

