/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.ui.TabField;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

public class TabControl
extends Panel
implements MouseListener,
FocusListener,
KeyListener,
ComponentListener {
    public static final int ALIGN_TOP = 0;
    public static final int ALIGN_LEFT = 1;
    private Panel panelPageContainer;
    private CardLayout layoutCard = new CardLayout();
    private int nCurrentPage = -1;
    private Button buttonFocus;
    private boolean boolFocus = false;
    private int nAlignment = 0;
    private int MARGIN_PAGE_VERT = 6;
    private int MARGIN_PAGE_HORZ = 6;
    private String strPageToShowAfterPaint = null;
    private Cursor cursorNormal = new Cursor(0);
    private Cursor cursorWait = new Cursor(3);
    private Vector vectorTabs = new Vector();
    private int nTabHeightMax = 1;
    private int nTabWidthMax = 1;
    private int nRowCount = 1;

    public TabControl() {
        this(0);
    }

    public TabControl(int nAlignment) {
        this.nAlignment = nAlignment;
        try {
            this.init();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.setLayout(new BorderLayout());
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.buttonFocus = new Button("Focus");
        this.add(this.buttonFocus);
        this.buttonFocus.addKeyListener(this);
        this.buttonFocus.addFocusListener(this);
        this.panelPageContainer = new Panel(this.layoutCard);
        this.add((Component)this.panelPageContainer, "Center");
        Font fontOld = this.panelPageContainer.getFont();
        if (fontOld == null) {
            fontOld = new Font("Dialog", 0, 12);
        }
        Font font = new Font("Dialog", 0, 12);
        this.setFont(font);
        this.panelPageContainer.setFont(fontOld);
        this.setBackground(TabField.COLOR_BG);
        this.panelPageContainer.setBackground(TabField.COLOR_BG);
    }

    public int addPage(Panel panelPage, String strTitle) {
        int nIndex = this.addPage(panelPage, strTitle, null);
        return nIndex;
    }

    public int addPage(Panel panelPage, String strTitle, Image image) {
        int nIndex = this.vectorTabs.size();
        TabField tabField = new TabField(this, panelPage, strTitle, image);
        this.vectorTabs.addElement(tabField);
        this.panelPageContainer.add((Component)panelPage, strTitle);
        if (nIndex == 0) {
            this.nCurrentPage = 0;
            this.layoutCard.show(this.panelPageContainer, strTitle);
        }
        tabField.calculateTabDimension(this.getFontMetrics(this.getFont()));
        this.nTabHeightMax = Math.max(tabField.dim.height, this.nTabHeightMax);
        this.nTabWidthMax = Math.max(tabField.dim.width, this.nTabWidthMax);
        this.recalculateTabs();
        this.repaint();
        return nIndex;
    }

    public int setPageImage(Panel panelPage, Image imageTab) {
        int nIndex = this.findPage(panelPage);
        if (nIndex < 0 || nIndex >= this.vectorTabs.size()) {
            return nIndex;
        }
        TabField tabField = (TabField)this.vectorTabs.elementAt(nIndex);
        if (tabField.image == imageTab) {
            return nIndex;
        }
        tabField.image = imageTab;
        this.nTabHeightMax = 1;
        this.nTabWidthMax = 1;
        int nCount = this.vectorTabs.size();
        int i2 = 0;
        while (i2 < nCount) {
            tabField = (TabField)this.vectorTabs.elementAt(i2);
            tabField.calculateTabDimension(this.getFontMetrics(this.getFont()));
            this.nTabHeightMax = Math.max(tabField.dim.height, this.nTabHeightMax);
            this.nTabWidthMax = Math.max(tabField.dim.width, this.nTabWidthMax);
            ++i2;
        }
        this.recalculateTabs();
        this.repaint();
        return nIndex;
    }

    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        if (this.nAlignment == 1) {
            dim.height = Math.max(dim.height, this.nTabHeightMax * this.vectorTabs.size() + 1);
        } else {
            int nRowWidth = 0;
            int i2 = 0;
            while (i2 < this.vectorTabs.size()) {
                TabField tabField = (TabField)this.vectorTabs.elementAt(i2);
                nRowWidth += tabField.dim.width;
                ++i2;
            }
            dim.width = Math.max(dim.width, nRowWidth + 1);
        }
        return dim;
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        insets = this.nAlignment == 1 ? new Insets(insets.top + this.MARGIN_PAGE_VERT, insets.left + this.nRowCount * this.nTabWidthMax - 2 + this.MARGIN_PAGE_HORZ, insets.bottom + this.MARGIN_PAGE_VERT, insets.right + this.MARGIN_PAGE_HORZ) : new Insets(insets.top + this.nRowCount * this.nTabHeightMax - 2 + this.MARGIN_PAGE_VERT, insets.left + this.MARGIN_PAGE_HORZ, insets.bottom + this.MARGIN_PAGE_VERT, insets.right + this.MARGIN_PAGE_HORZ);
        return insets;
    }

    public void update(Graphics g2) {
        Rectangle rectClient = this.getBounds();
        if (rectClient.width < 1 || rectClient.height < 1) {
            return;
        }
        Image image = this.createImage(rectClient.width, rectClient.height);
        Graphics graphics = image != null ? image.getGraphics() : g2;
        this.paint(graphics);
        if (image != null) {
            g2.drawImage(image, 0, 0, this);
        }
    }

    public void paint(Graphics graphics) {
        Font fontNormal;
        super.paint(graphics);
        Rectangle rectClient = this.getBounds();
        rectClient.x = 0;
        rectClient.y = 0;
        Rectangle rect = new Rectangle(rectClient);
        if (this.nAlignment == 1) {
            rect.x += this.nTabWidthMax * this.nRowCount - 2;
            rect.width -= this.nTabWidthMax * this.nRowCount - 2;
        } else {
            rect.y += this.nTabHeightMax * this.nRowCount - 2;
            rect.height -= this.nTabHeightMax * this.nRowCount - 2;
        }
        --rect.width;
        --rect.height;
        graphics.setColor(TabField.COLOR_SHADOW_BOTTOM);
        graphics.drawRect(rect.x, rect.y, rect.width, rect.height);
        graphics.setColor(TabField.COLOR_SHADOW_TOP);
        graphics.drawLine(rect.x + 1, rect.y + 1, rect.x + 1, rect.y + rect.height - 2);
        graphics.drawLine(rect.x + 1, rect.y + 1, rect.x + rect.width - 2, rect.y + 1);
        Font fontBold = fontNormal = this.getFont();
        int nSize = this.vectorTabs.size();
        int i2 = nSize - 1;
        while (i2 >= 0) {
            int nY;
            int nX;
            int nHeight;
            FontMetrics fontMetrics;
            int nWidth;
            TabField tabField = (TabField)this.vectorTabs.elementAt(i2);
            if (i2 == this.nCurrentPage) {
                if (this.nAlignment == 1) {
                    tabField.drawCurrentTabLeft(graphics);
                } else {
                    tabField.drawCurrentTabTop(graphics);
                }
            } else if (this.nAlignment == 1) {
                tabField.drawTabLeft(graphics);
            } else {
                tabField.drawTabTop(graphics);
            }
            graphics.setColor(this.getForeground());
            Rectangle rectString = new Rectangle(tabField.rect);
            if (this.nAlignment == 1) {
                rectString.width = this.nTabWidthMax;
            } else {
                rectString.height = this.nTabHeightMax;
            }
            if (tabField.image != null) {
                nWidth = tabField.image.getWidth(this);
                rectString.x += nWidth + tabField.MARGIN_TAB_HORZ;
                rectString.width -= nWidth + tabField.MARGIN_TAB_HORZ;
            }
            ++rectString.y;
            if (i2 == this.nCurrentPage) {
                graphics.setFont(fontBold);
                fontMetrics = graphics.getFontMetrics(fontBold);
                if (this.boolFocus) {
                    nWidth = fontMetrics.stringWidth(tabField.strTitle) + 6;
                    nHeight = fontMetrics.getHeight() + 1;
                    nX = rectString.x + (rectString.width - nWidth) / 2;
                    nY = rectString.y + (this.nTabHeightMax - 2 - nHeight) / 2 + 1;
                    this.drawDottedRectangle(graphics, nX, nY, nWidth, nHeight);
                }
            } else {
                graphics.setFont(fontNormal);
                fontMetrics = graphics.getFontMetrics(fontNormal);
            }
            nX = rectString.x + (rectString.width - fontMetrics.stringWidth(tabField.strTitle)) / 2;
            nY = rectString.y + rectString.height - (rectString.height - fontMetrics.getHeight()) / 2 - fontMetrics.getMaxDescent();
            --nY;
            if (i2 != this.nCurrentPage) {
                ++nX;
                ++nY;
            }
            graphics.drawString(tabField.strTitle, nX, nY);
            if (tabField.image != null) {
                nHeight = tabField.image.getHeight(this);
                nX = tabField.rect.x + tabField.MARGIN_TAB_HORZ;
                nY = tabField.rect.y + (this.nTabHeightMax - nHeight) / 2;
                if (i2 != this.nCurrentPage) {
                    ++nX;
                    ++nY;
                }
                graphics.drawImage(tabField.image, nX, nY, this);
            }
            --i2;
        }
        if (this.strPageToShowAfterPaint != null) {
            this.layoutCard.show(this.panelPageContainer, this.strPageToShowAfterPaint);
            this.strPageToShowAfterPaint = null;
            this.setCursor(this.cursorNormal);
        }
    }

    private void drawDottedRectangle(Graphics graphics, int nX, int nY, int nWidth, int nHeight) {
        this.drawDottedLine(graphics, nX, nY, nX + nWidth - 1, nY);
        this.drawDottedLine(graphics, nX + nWidth - 1, nY, nX + nWidth - 1, nY + nHeight - 1);
        this.drawDottedLine(graphics, nX + nWidth - 1, nY + nHeight - 1, nX, nY + nHeight - 1);
        this.drawDottedLine(graphics, nX, nY + nHeight - 1, nX, nY);
    }

    private void drawDottedLine(Graphics graphics, int nX1, int nY1, int nX2, int nY2) {
        int nY;
        int nX;
        if (nX1 == nX2 && nY1 == nY2) {
            this.drawDot(graphics, nX1, nY1);
            return;
        }
        if (nX1 > nX2) {
            nX = nX1;
            nX1 = nX2;
            nX2 = nX;
        }
        if (nY1 > nY2) {
            nY = nY1;
            nY1 = nY2;
            nY2 = nY;
        }
        if (nX2 - nX1 > nY2 - nY1) {
            double dDiv = (double)(nY2 - nY1) / (double)(nX2 - nX1);
            nX = nX1;
            while (nX <= nX2) {
                nY = (int)Math.rint((double)nY1 + (double)(nX - nX1) * dDiv);
                this.drawDot(graphics, nX, nY);
                ++nX;
            }
        } else {
            double dDiv = (nX2 - nX1) / (nY2 - nY1);
            nY = nY1;
            while (nY <= nY2) {
                nX = (int)Math.rint((double)nX1 + (double)(nY - nY1) * dDiv);
                this.drawDot(graphics, nX, nY);
                ++nY;
            }
        }
    }

    private void drawDot(Graphics graphics, int nX, int nY) {
        if ((nX + nY) % 2 == 0) {
            graphics.drawLine(nX, nY, nX, nY);
        }
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        int x = event.getX();
        int y = event.getY();
        int nTabCount = this.vectorTabs.size();
        int i2 = 0;
        while (i2 < nTabCount) {
            TabField tabField = (TabField)this.vectorTabs.elementAt(i2);
            if (tabField.rect.contains(x, y)) {
                this.buttonFocus.requestFocus();
                this.nCurrentPage = i2;
                this.strPageToShowAfterPaint = tabField.strTitle;
                this.setCursor(this.cursorWait);
                this.repaint();
                break;
            }
            ++i2;
        }
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void keyTyped(KeyEvent event) {
    }

    public void keyPressed(KeyEvent event) {
        int nIndex = this.nCurrentPage;
        int nKeyCode = event.getKeyCode();
        if (nKeyCode == 40 || nKeyCode == 39) {
            ++nIndex;
        } else if (nKeyCode == 38 || nKeyCode == 37) {
            --nIndex;
        }
        if (nIndex >= this.vectorTabs.size()) {
            nIndex = this.vectorTabs.size() - 1;
        }
        if (nIndex < 0) {
            nIndex = 0;
        }
        if (this.nCurrentPage != nIndex) {
            this.nCurrentPage = nIndex;
            TabField tabField = (TabField)this.vectorTabs.elementAt(nIndex);
            this.strPageToShowAfterPaint = tabField.strTitle;
            this.setCursor(this.cursorWait);
            this.repaint();
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    public void focusGained(FocusEvent event) {
        if (this.boolFocus) {
            return;
        }
        this.boolFocus = true;
        this.repaint();
    }

    public void focusLost(FocusEvent event) {
        if (!this.boolFocus) {
            return;
        }
        this.boolFocus = false;
        this.repaint();
    }

    public void componentResized(ComponentEvent event) {
        this.recalculateTabs();
        this.doLayout();
        this.panelPageContainer.validate();
    }

    public void componentMoved(ComponentEvent event) {
    }

    public void componentShown(ComponentEvent event) {
    }

    public void componentHidden(ComponentEvent event) {
    }

    private void recalculateTabs() {
        int nRowSize = 1;
        Rectangle rectClient = this.getBounds();
        rectClient.x = 0;
        rectClient.y = 0;
        if (rectClient.width < 1 || rectClient.height < 1) {
            return;
        }
        int nTabCount = this.vectorTabs.size();
        if (this.nAlignment == 1) {
            nRowSize = rectClient.height / this.nTabHeightMax;
            this.nRowCount = (nTabCount + nRowSize - 1) / nRowSize;
            int nOffsetX = this.nRowCount * this.nTabWidthMax;
            int nOffsetY = 0;
            int i2 = 0;
            while (i2 < nTabCount) {
                if (i2 % nRowSize == 0) {
                    nOffsetX -= this.nTabWidthMax;
                    nOffsetY = 0;
                }
                TabField tabField = (TabField)this.vectorTabs.elementAt(i2);
                tabField.rect.x = nOffsetX;
                tabField.rect.y = nOffsetY;
                tabField.rect.width = this.nTabWidthMax * (i2 / nRowSize + 1);
                tabField.rect.height = this.nTabHeightMax;
                tabField.nRowIndex = i2 / nRowSize;
                if (tabField.nRowIndex > 0) {
                    tabField.rect.width -= 2;
                }
                nOffsetY += this.nTabHeightMax;
                ++i2;
            }
        } else {
            TabField tabField;
            this.nRowCount = 1;
            int nRowWidth = 0;
            int i2 = 0;
            while (i2 < nTabCount) {
                tabField = (TabField)this.vectorTabs.elementAt(i2);
                if (nRowWidth + tabField.dim.width > rectClient.width) {
                    nRowWidth = 0;
                    ++this.nRowCount;
                }
                nRowWidth += tabField.dim.width;
                ++i2;
            }
            int nOffsetX = 0;
            int nOffsetY = this.nRowCount * this.nTabHeightMax;
            int nRowIndex = 0;
            int j2 = 0;
            i2 = 0;
            while (i2 < nTabCount) {
                if (i2 == j2) {
                    nOffsetX = 0;
                    nOffsetY -= this.nTabHeightMax;
                    nRowWidth = 0;
                    j2 = i2;
                    while (j2 < nTabCount) {
                        tabField = (TabField)this.vectorTabs.elementAt(j2);
                        if (j2 > i2 && nRowWidth + tabField.dim.width > rectClient.width) break;
                        nRowWidth += tabField.dim.width;
                        tabField.nRowIndex = nRowIndex;
                        ++j2;
                    }
                    nRowSize = j2 - i2;
                    ++nRowIndex;
                }
                tabField = (TabField)this.vectorTabs.elementAt(i2);
                tabField.rect.x = nOffsetX;
                tabField.rect.y = nOffsetY;
                tabField.rect.width = tabField.dim.width;
                if (this.nRowCount > 1 && nRowIndex < this.nRowCount) {
                    tabField.rect.width += (rectClient.width - nRowWidth - 1) / nRowSize;
                    tabField.rect.width = tabField.rect.width + (j2 - i2 > (rectClient.width - nRowWidth - 1) % nRowSize ? 0 : 1);
                }
                tabField.rect.height = this.nTabHeightMax * nRowIndex;
                if (tabField.nRowIndex > 0) {
                    tabField.rect.height -= 2;
                }
                nOffsetX += tabField.rect.width;
                ++i2;
            }
        }
        this.repaint();
    }

    private int findPage(Panel panelPage) {
        int i2 = this.vectorTabs.size() - 1;
        while (i2 >= 0) {
            TabField tabField = (TabField)this.vectorTabs.elementAt(i2);
            if (tabField.panelPage == panelPage) break;
            --i2;
        }
        return i2;
    }
}

