/*
 * Decompiled with CFR 0.152.
 */
package jmapps.registry;

import com.sun.media.util.JMFI18N;
import com.sun.media.util.Registry;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import jmapps.ui.JMPanel;
import jmapps.ui.MessageDialog;

public class SettingsPanel
extends JMPanel
implements ActionListener {
    private Checkbox checkAllowCaching;
    private Checkbox checkAllowFileWrite;
    private Checkbox checkAllowCapture;
    private TextField textMaxCacheSize;
    private TextField textCacheDir;
    private Checkbox checkAllowLogging;
    private TextField textLoggingDir;
    private Button buttonCommit;
    private Button buttonRestore;

    public SettingsPanel() {
        this.setLayout(new BorderLayout(6, 6));
        Panel panel = new Panel(new BorderLayout(6, 6));
        this.add((Component)panel, "North");
        Panel panelData = new Panel(new GridLayout(0, 1, 6, 6));
        panel.add((Component)panelData, "West");
        Panel panelEntry = new Panel(new BorderLayout(6, 6));
        panelData.add(panelEntry);
        this.checkAllowFileWrite = new Checkbox(JMFI18N.getResource("jmfregistry.settings.allowfilewrite"));
        panelEntry.add((Component)this.checkAllowFileWrite, "West");
        panelEntry = new Panel(new BorderLayout(6, 6));
        panelData.add(panelEntry);
        this.checkAllowCapture = new Checkbox(JMFI18N.getResource("jmfregistry.settings.allowcapture"));
        panelEntry.add((Component)this.checkAllowCapture, "West");
        panelEntry = new Panel(new BorderLayout(6, 6));
        panelData.add(panelEntry);
        this.checkAllowCaching = new Checkbox(JMFI18N.getResource("jmfregistry.settings.allowcaching"));
        panelEntry.add((Component)this.checkAllowCaching, "West");
        panelEntry = new Panel(new BorderLayout(6, 6));
        panelData.add(panelEntry);
        Label label = new Label(JMFI18N.getResource("jmfregistry.settings.cachedirectory"));
        panelEntry.add((Component)label, "West");
        this.textCacheDir = new TextField(32);
        panelEntry.add((Component)this.textCacheDir, "Center");
        panelEntry = new Panel(new BorderLayout(6, 6));
        panelData.add(panelEntry);
        label = new Label(JMFI18N.getResource("jmfregistry.settings.maxcache"));
        panelEntry.add((Component)label, "West");
        this.textMaxCacheSize = new TextField();
        panelEntry.add((Component)this.textMaxCacheSize, "Center");
        panelEntry = new Panel(new BorderLayout(6, 6));
        panelData.add(panelEntry);
        this.checkAllowLogging = new Checkbox(JMFI18N.getResource("jmfregistry.settings.allowlogging"));
        panelEntry.add((Component)this.checkAllowLogging, "West");
        panelEntry = new Panel(new BorderLayout(6, 6));
        panelData.add(panelEntry);
        label = new Label(JMFI18N.getResource("jmfregistry.settings.loggingdirectory"));
        panelEntry.add((Component)label, "West");
        this.textLoggingDir = new TextField();
        panelEntry.add((Component)this.textLoggingDir, "Center");
        panel = new Panel(new FlowLayout(1));
        this.add((Component)panel, "South");
        Panel panelButtons = new Panel(new GridLayout(1, 0, 12, 12));
        panel.add(panelButtons);
        this.buttonCommit = new Button(JMFI18N.getResource("jmfregistry.settings.commit"));
        this.buttonCommit.addActionListener(this);
        panelButtons.add(this.buttonCommit);
        this.buttonRestore = new Button(JMFI18N.getResource("jmfregistry.settings.restore"));
        this.buttonRestore.addActionListener(this);
        panelButtons.add(this.buttonRestore);
        this.doRestore();
    }

    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.buttonCommit) {
            this.doCommit();
        }
        if (source == this.buttonRestore) {
            this.doRestore();
        }
    }

    private void doCommit() {
        boolean allowCaching = this.checkAllowCaching.getState();
        Registry.set("secure.allowCaching", new Boolean(allowCaching));
        boolean allowFileWrite = this.checkAllowFileWrite.getState();
        Registry.set("secure.allowSaveFileFromApplets", new Boolean(allowFileWrite));
        boolean allowCapture = this.checkAllowCapture.getState();
        Registry.set("secure.allowCaptureFromApplets", new Boolean(allowCapture));
        Registry.set("secure.cacheDir", this.textCacheDir.getText());
        boolean allowLogging = this.checkAllowLogging.getState();
        Registry.set("allowLogging", new Boolean(allowLogging));
        Registry.set("secure.logDir", this.textLoggingDir.getText());
        try {
            int cacheSize = Integer.parseInt(this.textMaxCacheSize.getText());
            Registry.set("secure.maxCacheSizeMB", new Integer(cacheSize));
        }
        catch (Throwable t) {
            MessageDialog.createErrorDialog(this.getFrame(), JMFI18N.getResource("jmfregistry.appname"), JMFI18N.getResource("jmfregistry.error.cachesize"));
        }
        try {
            Registry.commit();
        }
        catch (IOException ioe) {
            MessageDialog.createErrorDialog(this.getFrame(), JMFI18N.getResource("jmfregistry.appname"), JMFI18N.getResource("jmfregistry.error.commit"));
        }
    }

    private void doRestore() {
        Boolean allowCaching = (Boolean)Registry.get("secure.allowCaching");
        Boolean allowFile = (Boolean)Registry.get("secure.allowSaveFileFromApplets");
        Boolean allowCapture = (Boolean)Registry.get("secure.allowCaptureFromApplets");
        String cacheDir = (String)Registry.get("secure.cacheDir");
        Integer cacheSize = (Integer)Registry.get("secure.maxCacheSizeMB");
        Boolean allowLogging = (Boolean)Registry.get("allowLogging");
        String loggingDir = (String)Registry.get("secure.logDir");
        this.checkAllowCaching.setState(allowCaching != null && allowCaching != false);
        this.checkAllowFileWrite.setState(allowFile != null && allowFile != false);
        this.checkAllowCapture.setState(allowCapture != null && allowCapture != false);
        this.checkAllowLogging.setState(allowLogging != null && allowLogging != false);
        if (cacheDir != null) {
            this.textCacheDir.setText(cacheDir);
        }
        if (cacheSize != null) {
            this.textMaxCacheSize.setText(cacheSize.toString());
        }
        if (loggingDir != null) {
            this.textLoggingDir.setText(loggingDir);
        }
    }
}

