/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.dockbar.layout;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.flexdock.dockbar.Dockbar;
import org.flexdock.dockbar.DockbarManager;
import org.flexdock.dockbar.ViewPane;
import org.flexdock.dockbar.layout.DockbarLayoutManager;
import org.flexdock.dockbar.layout.InsetBorder;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.props.DockablePropertySet;
import org.flexdock.util.Utilities;

public class DockbarLayout {
    public static final int MINIMUM_VIEW_SIZE = 20;
    private static final int[] EDGES = new int[]{2, 4, 3};
    private DockbarManager manager;
    private JComponent leftEdgeGuide;
    private JComponent rightEdgeGuide;
    private JComponent bottomEdgeGuide;

    public DockbarLayout(DockbarManager mgr) {
        this.manager = mgr;
    }

    public void layout() {
        this.updateInsets();
        Rectangle rect = DockbarLayoutManager.getManager().getLayoutArea(this.manager);
        int rightX = rect.x + rect.width;
        int bottomY = rect.y + rect.height;
        Dockbar leftBar = this.manager.getLeftBar();
        Dockbar rightBar = this.manager.getRightBar();
        Dockbar bottomBar = this.manager.getBottomBar();
        Dimension leftPref = leftBar.getPreferredSize();
        Dimension rightPref = rightBar.getPreferredSize();
        Dimension bottomPref = bottomBar.getPreferredSize();
        leftBar.setBounds(rect.x, rect.y, leftPref.width, rect.height - bottomPref.height);
        rightBar.setBounds(rightX - rightPref.width, rect.y, rightPref.width, rect.height - bottomPref.height);
        bottomBar.setBounds(rect.x, bottomY - bottomPref.height, rect.width, bottomPref.height);
        this.layoutViewpane();
    }

    public int getDesiredViewpaneSize() {
        Dockable dockable = this.manager.getActiveDockable();
        if (dockable == null) {
            return 0;
        }
        Rectangle rect = DockbarLayoutManager.getManager().getViewArea(this.manager, dockable);
        DockablePropertySet props = dockable.getDockingProperties();
        float viewSize = props.getPreviewSize().floatValue();
        int edge = this.manager.getActiveEdge();
        if (edge == 2 || edge == 4) {
            return (int)((float)rect.width * viewSize);
        }
        return (int)((float)rect.height * viewSize);
    }

    private void layoutViewpane() {
        ViewPane viewPane = this.manager.getViewPane();
        Dockable dockable = this.manager.getActiveDockable();
        if (dockable == null) {
            viewPane.setBounds(0, 0, 0, 0);
            return;
        }
        int edge = this.manager.getActiveEdge();
        int viewpaneSize = viewPane.getPrefSize();
        if (viewpaneSize == -1) {
            viewpaneSize = this.getDesiredViewpaneSize();
        }
        Rectangle rect = DockbarLayoutManager.getManager().getViewArea(this.manager, dockable);
        if (edge == 2 || edge == 4) {
            if (edge == 4) {
                rect.x = rect.x + rect.width - viewpaneSize;
            }
            rect.width = viewpaneSize;
        } else {
            if (edge == 3) {
                rect.y = rect.y + rect.height - viewpaneSize;
            }
            rect.height = viewpaneSize;
        }
        viewPane.setBounds(rect);
    }

    private void updateInsets() {
        Insets emptyInsets = this.getEmptyInsets();
        boolean changed = this.resetGuideBorders();
        HashSet borderSet = new HashSet(3);
        this.add(borderSet, this.getInsetBorder(2));
        this.add(borderSet, this.getInsetBorder(4));
        this.add(borderSet, this.getInsetBorder(3));
        HashSet guideSet = new HashSet(3);
        this.add(guideSet, this.getCurrentEdgeGuide(2));
        this.add(guideSet, this.getCurrentEdgeGuide(4));
        this.add(guideSet, this.getCurrentEdgeGuide(3));
        Iterator it = borderSet.iterator();
        while (it.hasNext()) {
            InsetBorder border = (InsetBorder)it.next();
            changed = border.setEmptyInsets(emptyInsets) || changed;
        }
        if (changed) {
            it = guideSet.iterator();
            while (it.hasNext()) {
                JComponent guide = (JComponent)it.next();
                guide.revalidate();
            }
        }
    }

    private boolean resetGuideBorders() {
        boolean changed = this.resetGuide(2);
        changed = this.resetGuide(4) || changed;
        changed = this.resetGuide(3) || changed;
        this.toggleInsetBorder(2);
        this.toggleInsetBorder(4);
        this.toggleInsetBorder(3);
        return changed;
    }

    private boolean resetGuide(int edge) {
        InsetBorder insetBorder;
        JComponent currGuide = this.getCurrentEdgeGuide(edge);
        JComponent newGuide = this.queryEdgeGuide(edge);
        boolean changed = false;
        if (Utilities.isChanged(currGuide, newGuide)) {
            InsetBorder fakeBorder;
            changed = true;
            Border b = currGuide == null ? null : currGuide.getBorder();
            InsetBorder insetBorder2 = fakeBorder = b instanceof InsetBorder ? (InsetBorder)b : null;
            if (fakeBorder != null) {
                Border realBorder = fakeBorder.getWrappedBorder();
                currGuide.setBorder(realBorder);
                fakeBorder.toggleEdge(edge, false);
            }
        }
        if (newGuide == null) {
            return this.setCurrentEdgeGuide(edge, newGuide) || changed;
        }
        Border border = newGuide.getBorder();
        if (!(border instanceof InsetBorder)) {
            changed = true;
            insetBorder = InsetBorder.createBorder(border, true, new Insets(-1, -1, -1, -1));
            newGuide.setBorder(insetBorder);
        }
        insetBorder = (InsetBorder)newGuide.getBorder();
        insetBorder.clearEdges();
        return this.setCurrentEdgeGuide(edge, newGuide) || changed;
    }

    private void toggleInsetBorder(int edge) {
        InsetBorder border = this.getInsetBorder(edge);
        if (border != null) {
            border.toggleEdge(edge, true);
        }
    }

    private InsetBorder getInsetBorder(int edge) {
        JComponent comp = this.getCurrentEdgeGuide(edge);
        Border border = comp == null ? null : comp.getBorder();
        return border instanceof InsetBorder ? (InsetBorder)border : null;
    }

    private Insets getEmptyInsets() {
        return new Insets(0, this.getLeftInset(), this.getBottomInset(), this.getRightInset());
    }

    private int getLeftInset() {
        return this.getDockbarInset(this.manager.getLeftBar());
    }

    private int getRightInset() {
        return this.getDockbarInset(this.manager.getRightBar());
    }

    private int getBottomInset() {
        return this.getDockbarInset(this.manager.getBottomBar());
    }

    private int getDockbarInset(Dockbar dockbar) {
        boolean visible = dockbar.isVisible();
        if (!visible) {
            return 0;
        }
        Dimension dim = dockbar.getPreferredSize();
        if (dockbar == this.manager.getLeftBar() || dockbar == this.manager.getRightBar()) {
            return dim.width;
        }
        return dim.height;
    }

    private JComponent queryEdgeGuide(int constraint) {
        return DockbarLayoutManager.getManager().getEdgeGuide(this.manager, constraint);
    }

    private JComponent getCurrentEdgeGuide(int constraint) {
        switch (constraint) {
            case 2: {
                return this.leftEdgeGuide;
            }
            case 4: {
                return this.rightEdgeGuide;
            }
            case 3: {
                return this.bottomEdgeGuide;
            }
        }
        return null;
    }

    private boolean setCurrentEdgeGuide(int constraint, JComponent comp) {
        boolean changed = this.getCurrentEdgeGuide(constraint) == comp;
        switch (constraint) {
            case 2: {
                this.leftEdgeGuide = comp;
                break;
            }
            case 4: {
                this.rightEdgeGuide = comp;
                break;
            }
            case 3: {
                this.bottomEdgeGuide = comp;
            }
        }
        return changed;
    }

    private void add(Set set, Object obj) {
        if (obj != null) {
            set.add(obj);
        }
    }
}

