/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.drag.outline.x11;

import org.flexdock.docking.drag.outline.x11.DataBuffer;

public class ConnectionResponse {
    private DataBuffer dataBuffer;
    private DataBuffer[] screens;
    private int resourceIndex;

    public ConnectionResponse(DataBuffer dataBuffer) {
        this.dataBuffer = dataBuffer;
        int offset = this.getScreenDataOffset();
        int screenLen = this.getScreenLength();
        this.screens = new DataBuffer[this.getScreenCount()];
        for (int i = 0; i < this.screens.length; ++i) {
            this.screens[i] = dataBuffer.getSubBuffer(offset, screenLen);
            offset += screenLen;
        }
    }

    public int getScreenCount() {
        return this.dataBuffer.readByte(28);
    }

    public int getVendorLength() {
        return this.dataBuffer.readTwoBytes(24);
    }

    public int getPixMapFormatCount() {
        return this.dataBuffer.readByte(29);
    }

    public int getPixMapOffset() {
        int offset = 40;
        int vendorLength = DataBuffer.padLength(this.getVendorLength());
        return offset += vendorLength;
    }

    public int getScreenDataOffset() {
        return this.getPixMapOffset() + 8 * this.getPixMapFormatCount();
    }

    public int getScreenLength() {
        return 40 + this.getPixMapFormatCount();
    }

    public int getResourceIdBase() {
        return this.dataBuffer.readFourBytes(12);
    }

    public int getResourceIdMask() {
        return this.dataBuffer.readFourBytes(16);
    }

    public synchronized int getNextResourceId() {
        int id = this.resourceIndex++ | this.getResourceIdBase();
        return id;
    }

    public int getRootWindowID(int screenIndex) {
        DataBuffer screen = this.screens[screenIndex];
        return screen.readFourBytes(0);
    }

    public int getWhitePixel(int screenIndex) {
        return this.screens[screenIndex].readFourBytes(8);
    }

    public int getBlackPixel(int screenIndex) {
        return this.screens[screenIndex].readFourBytes(12);
    }
}

