#                                                         -*- Perl -*-
# Copyright (c) 2000  Motoyuki Kasahara
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

#
# ̾ե򻲾Ȥ롣
#
package FreePWING::RefUserChar;

require 5.005;
require Exporter;
use English;
use FileHandle;
use FreePWING::Reference;
use strict;
use integer;

use vars qw(@ISA
	    @EXPORT
	    @EXPORT_OK);

@ISA = qw(Exporter);

#
# :
#	new()
# ᥽åɤζʬ:
# 	public 饹᥽åɡ
# :
# 	֥Ȥ롣
# :
# 	֥ȤؤΥե󥹤֤
#
sub new {
    my $type = shift;
    my $new = {
	# ơ֥
	'characters' => {},

	# 顼å
	'error_message' => '',
    };
    return bless($new, $type);
}

#
# :
#	add_characters_in_file(file_name)
#           file_name
#		ɤ߹೰̾ե̾
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	̾եϿƤ̾ɤ߹ࡣ
# :
#	 1 ֤Ԥ 0 ֤
#
sub add_characters_in_file {
    my $self = shift;
    my ($file_name) = @ARG;

    #
    # ̾ե򳫤
    #
    my $handle = FileHandle->new();
    if (!$handle->open($file_name, 'r')) {
	$self->{'error_message'} = 
	    "failed to open the file, $ERRNO: $file_name";
	return 0;
    }

    #
    # ̾եγƹԤɤ߹ࡣ
    #
    my $line;
    my @line_fields;
    for (;;) {
	$line = $handle->getline();
	if (!defined($line)) {
	    last;
	}
	chomp $line;
	@line_fields = split(/\t/, $line);
	if (defined($self->{'characters'}->{$line_fields[0]})) {
	    $self->{'error_message'} = 
		"redefined character name, $line_fields[0]: " 
		    . "line $NR, $file_name";
	    $handle->close();
	    return 0;
	}
	$self->{'characters'}->{$line_fields[0]} = hex($line_fields[1]);
    }

    #
    # ̾եĤ롣
    #
    $handle->close();
    
    return 1;
}

######################################################################
# <󥹥ѿ֤ͤ᥽åɷ>
#
# :
#	󥹥ѿ̾()
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
#	󥹥ѿ֤ͤ
#
sub character {
    my $self = shift;
    my ($name) = @ARG;
    return $self->{'characters'}->{$name};
}

sub character_count {
    my $self = shift;
    return scalar(%{$self->{'characters'}}) + 0;
}

sub error_message {
    my $self = shift;
    return $self->{'error_message'};
}

1;

