/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*-
 *
 * Copyright (C) 2008 David Zeuthen <davidz@redhat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#if !defined (_DEVKIT_GOBJECT_COMPILATION) && !defined(_DEVKIT_GOBJECT_INSIDE_DEVKIT_GOBJECT_H)
#error "Only <devkit-gobject.h> can be included directly, this file may disappear or change contents."
#endif

#ifndef __DEVKIT_CLIENT_H__
#define __DEVKIT_CLIENT_H__

#include <devkit-gobject/devkit-types.h>

G_BEGIN_DECLS

#define DEVKIT_TYPE_CLIENT         (devkit_client_get_type ())
#define DEVKIT_CLIENT(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), DEVKIT_TYPE_CLIENT, DevkitClient))
#define DEVKIT_CLIENT_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), DEVKIT_TYPE_CLIENT, DevkitClientClass))
#define DEVKIT_IS_CLIENT(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), DEVKIT_TYPE_CLIENT))
#define DEVKIT_IS_CLIENT_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), DEVKIT_TYPE_CLIENT))
#define DEVKIT_CLIENT_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), DEVKIT_TYPE_CLIENT, DevkitClientClass))

typedef struct _DevkitClientClass   DevkitClientClass;
typedef struct _DevkitClientPrivate DevkitClientPrivate;

/**
 * DevkitClient:
 * @parent: Parent instance.
 *
 * The #DevkitClient struct is opaque and should not be accessed directly.
 */
struct _DevkitClient
{
        GObject              parent;

        /*< private >*/
        DevkitClientPrivate *priv;
};

/**
 * DevkitClientClass:
 * @parent_class: Parent class.
 * @device_event: Signal class handler for the #DevkitClient::device-event signal.
 *
 * Class structure for #DevkitClient.
 */
struct _DevkitClientClass
{
        GObjectClass   parent_class;

        /* signals */
        void (*device_event) (DevkitClient  *client,
                              const gchar   *action,
                              DevkitDevice  *device);

        /*< private >*/

        /* Padding for future expansion */
        void (*_devkit_reserved1) (void);
        void (*_devkit_reserved2) (void);
        void (*_devkit_reserved3) (void);
        void (*_devkit_reserved4) (void);
        void (*_devkit_reserved5) (void);
        void (*_devkit_reserved6) (void);
        void (*_devkit_reserved7) (void);
        void (*_devkit_reserved8) (void);

};

GType         devkit_client_get_type               (void) G_GNUC_CONST;
DevkitClient *devkit_client_new                    (const gchar  **subsystems);
gboolean      devkit_client_connect                (DevkitClient  *client,
                                                    GError       **error);

GList        *devkit_client_enumerate_by_subsystem   (DevkitClient  *client,
                                                      const gchar  **subsystems,
                                                      GError       **error);

GList        *devkit_client_enumerate_by_native_path (DevkitClient  *client,
                                                      const gchar  **native_paths,
                                                      GError       **error);

const gchar  *devkit_client_get_daemon_version       (DevkitClient *client);

G_END_DECLS

#endif /* __DEVKIT_CLIENT_H__ */
