/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.keyring;

import gnu.java.security.Registry;
import gnu.java.security.prng.IRandom;
import gnu.java.security.prng.LimitReachedException;
import gnu.java.security.util.Util;
import gnu.javax.crypto.keyring.Entry;
import gnu.javax.crypto.keyring.MalformedKeyringException;
import gnu.javax.crypto.keyring.MaskableEnvelopeEntry;
import gnu.javax.crypto.keyring.MeteredInputStream;
import gnu.javax.crypto.keyring.PasswordProtectedEntry;
import gnu.javax.crypto.keyring.Properties;
import gnu.javax.crypto.mac.IMac;
import gnu.javax.crypto.mac.MacFactory;
import gnu.javax.crypto.mac.MacInputStream;
import gnu.javax.crypto.mac.MacOutputStream;
import gnu.javax.crypto.prng.PRNGFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public final class PasswordAuthenticatedEntry
extends MaskableEnvelopeEntry
implements PasswordProtectedEntry,
Registry {
    public static final int TYPE = 3;

    public static final PasswordAuthenticatedEntry decode(DataInputStream dataInputStream, char[] cArray) throws IOException {
        PasswordAuthenticatedEntry passwordAuthenticatedEntry = new PasswordAuthenticatedEntry();
        passwordAuthenticatedEntry.properties.decode(dataInputStream);
        IMac iMac = passwordAuthenticatedEntry.getMac(cArray);
        int n = dataInputStream.readInt() - iMac.macSize();
        MeteredInputStream meteredInputStream = new MeteredInputStream(dataInputStream, n);
        MacInputStream macInputStream = new MacInputStream(meteredInputStream, iMac);
        DataInputStream dataInputStream2 = new DataInputStream(macInputStream);
        passwordAuthenticatedEntry.setMasked(false);
        passwordAuthenticatedEntry.decodeEnvelope(dataInputStream2);
        byte[] byArray = new byte[iMac.macSize()];
        dataInputStream.readFully(byArray);
        if (!Arrays.equals(byArray, iMac.digest())) {
            throw new MalformedKeyringException("MAC verification failed");
        }
        return passwordAuthenticatedEntry;
    }

    public static final PasswordAuthenticatedEntry decode(DataInputStream dataInputStream) throws IOException {
        PasswordAuthenticatedEntry passwordAuthenticatedEntry = new PasswordAuthenticatedEntry();
        passwordAuthenticatedEntry.defaultDecode(dataInputStream);
        if (!passwordAuthenticatedEntry.properties.containsKey("mac")) {
            throw new MalformedKeyringException("no MAC");
        }
        if (!passwordAuthenticatedEntry.properties.containsKey("maclen")) {
            throw new MalformedKeyringException("no MAC length");
        }
        if (!passwordAuthenticatedEntry.properties.containsKey("salt")) {
            throw new MalformedKeyringException("no salt");
        }
        return passwordAuthenticatedEntry;
    }

    public final void verify(char[] cArray) {
        if (!this.isMasked() || this.payload == null) {
            return;
        }
        IMac iMac = null;
        try {
            iMac = this.getMac(cArray);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.toString());
        }
        iMac.update(this.payload, 0, this.payload.length - iMac.macSize());
        byte[] byArray = new byte[iMac.macSize()];
        System.arraycopy(this.payload, this.payload.length - byArray.length, byArray, 0, byArray.length);
        if (!Arrays.equals(byArray, iMac.digest())) {
            throw new IllegalArgumentException("MAC verification failed");
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.payload, 0, this.payload.length - iMac.macSize()));
            this.decodeEnvelope(dataInputStream);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("malformed keyring fragment");
        }
        this.setMasked(false);
        this.payload = null;
    }

    public final void authenticate(char[] cArray) throws IOException {
        if (this.isMasked()) {
            throw new IllegalStateException("entry is masked");
        }
        byte[] byArray = new byte[8];
        new SecureRandom().nextBytes(byArray);
        this.properties.put("salt", Util.toString(byArray));
        IMac iMac = this.getMac(cArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        MacOutputStream macOutputStream = new MacOutputStream(byteArrayOutputStream, iMac);
        DataOutputStream dataOutputStream = new DataOutputStream(macOutputStream);
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            entry.encode(dataOutputStream);
        }
        byteArrayOutputStream.write(iMac.digest());
        this.payload = byteArrayOutputStream.toByteArray();
    }

    public final void encode(DataOutputStream dataOutputStream, char[] cArray) throws IOException {
        this.authenticate(cArray);
        this.encode(dataOutputStream);
    }

    protected final void encodePayload(DataOutputStream dataOutputStream) throws IOException {
        if (this.payload == null) {
            throw new IllegalStateException("mac not computed");
        }
    }

    private final IMac getMac(char[] cArray) throws MalformedKeyringException {
        if (!this.properties.containsKey("salt")) {
            throw new MalformedKeyringException("no salt");
        }
        byte[] byArray = Util.toBytesFromString(this.properties.get("salt"));
        IMac iMac = MacFactory.getInstance(this.properties.get("mac"));
        if (iMac == null) {
            throw new MalformedKeyringException("no such mac: " + this.properties.get("mac"));
        }
        int n = iMac.macSize();
        int n2 = 0;
        if (!this.properties.containsKey("maclen")) {
            throw new MalformedKeyringException("no MAC length");
        }
        try {
            n2 = Integer.parseInt(this.properties.get("maclen"));
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedKeyringException("bad MAC length");
        }
        HashMap hashMap = new HashMap();
        hashMap.put("gnu.crypto.pbe.password", cArray);
        hashMap.put("gnu.crypto.pbe.salt", byArray);
        hashMap.put("gnu.crypto.pbe.iteration.count", ITERATION_COUNT);
        IRandom iRandom = PRNGFactory.getInstance("PBKDF2-HMAC-SHA");
        iRandom.init(hashMap);
        byte[] byArray2 = new byte[n];
        try {
            iRandom.nextBytes(byArray2, 0, n);
        }
        catch (LimitReachedException limitReachedException) {
            throw new Error(limitReachedException.toString());
        }
        HashMap hashMap2 = new HashMap();
        hashMap2.put("gnu.crypto.mac.key.material", byArray2);
        hashMap2.put("gnu.crypto.mac.truncated.size", new Integer(n2));
        try {
            iMac.init(hashMap2);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new Error(invalidKeyException.toString());
        }
        return iMac;
    }

    public PasswordAuthenticatedEntry(String string, int n, Properties properties) {
        super(3, properties);
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("no MAC specified");
        }
        this.properties.put("mac", string);
        this.properties.put("maclen", String.valueOf(n));
        this.setMasked(false);
    }

    private PasswordAuthenticatedEntry() {
        super(3);
        this.setMasked(true);
    }
}

