/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.StyleSheet;

public class BlockView
extends BoxView {
    public void setParent(View view) {
        super.setParent(view);
        if (view != null) {
            this.setPropertiesFromAttributes();
        }
    }

    protected SizeRequirements calculateMajorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        SizeRequirements sizeRequirements2 = super.calculateMajorAxisRequirements(n, sizeRequirements);
        return sizeRequirements2;
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        SizeRequirements sizeRequirements2 = super.calculateMinorAxisRequirements(n, sizeRequirements);
        return sizeRequirements2;
    }

    protected void layoutMinorAxis(int n, int n2, int[] nArray, int[] nArray2) {
        super.layoutMinorAxis(n, n2, nArray, nArray2);
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = (Rectangle)shape;
        this.getStyleSheet().getBoxPainter(this.getAttributes()).paint(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
        super.paint(graphics, shape);
    }

    public AttributeSet getAttributes() {
        return this.getStyleSheet().getViewAttributes(this);
    }

    public int getResizeWeight(int n) throws IllegalArgumentException {
        if (n == 1) {
            return 0;
        }
        if (n == 0) {
            return 1;
        }
        throw new IllegalArgumentException("Invalid Axis");
    }

    public float getAlignment(int n) {
        if (n == 0) {
            return 0.0f;
        }
        if (n == 1) {
            if (this.getViewCount() == 0) {
                return 0.0f;
            }
            float f = this.getPreferredSpan(1);
            float f2 = this.getView(0).getPreferredSpan(1);
            return f2 / 2.0f / f;
        }
        throw new IllegalArgumentException("Invalid Axis");
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.changedUpdate(documentEvent, shape, viewFactory);
        int n = documentEvent.getOffset();
        if (n <= this.getStartOffset() && n + documentEvent.getLength() >= this.getEndOffset()) {
            this.setPropertiesFromAttributes();
        }
    }

    public float getPreferredSpan(int n) throws IllegalArgumentException {
        if (n == 0 || n == 1) {
            return super.getPreferredSpan(n);
        }
        throw new IllegalArgumentException("Invalid Axis");
    }

    public float getMinimumSpan(int n) throws IllegalArgumentException {
        if (n == 0 || n == 1) {
            return super.getMinimumSpan(n);
        }
        throw new IllegalArgumentException("Invalid Axis");
    }

    public float getMaximumSpan(int n) throws IllegalArgumentException {
        if (n == 0 || n == 1) {
            return super.getMaximumSpan(n);
        }
        throw new IllegalArgumentException("Invalid Axis");
    }

    protected void setPropertiesFromAttributes() {
    }

    protected StyleSheet getStyleSheet() {
        StyleSheet styleSheet = new StyleSheet();
        styleSheet.importStyleSheet(this.getClass().getResource("default.css"));
        return styleSheet;
    }

    public BlockView(Element element, int n) {
        super(element, n);
    }
}

