require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_UVM_UVM_EXTERN_H_)) {
    eval 'sub _UVM_UVM_EXTERN_H_ () {1;}' unless defined(&_UVM_UVM_EXTERN_H_);
    require 'sys/types.ph';
    eval 'sub UVM_PROT_MASK () {0x7;}' unless defined(&UVM_PROT_MASK);
    eval 'sub UVM_PROT_NONE () {0x;}' unless defined(&UVM_PROT_NONE);
    eval 'sub UVM_PROT_ALL () {0x7;}' unless defined(&UVM_PROT_ALL);
    eval 'sub UVM_PROT_READ () {0x1;}' unless defined(&UVM_PROT_READ);
    eval 'sub UVM_PROT_WRITE () {0x2;}' unless defined(&UVM_PROT_WRITE);
    eval 'sub UVM_PROT_EXEC () {0x4;}' unless defined(&UVM_PROT_EXEC);
    eval 'sub UVM_PROT_R () {0x1;}' unless defined(&UVM_PROT_R);
    eval 'sub UVM_PROT_W () {0x2;}' unless defined(&UVM_PROT_W);
    eval 'sub UVM_PROT_RW () {0x3;}' unless defined(&UVM_PROT_RW);
    eval 'sub UVM_PROT_X () {0x4;}' unless defined(&UVM_PROT_X);
    eval 'sub UVM_PROT_RX () {0x5;}' unless defined(&UVM_PROT_RX);
    eval 'sub UVM_PROT_WX () {0x6;}' unless defined(&UVM_PROT_WX);
    eval 'sub UVM_PROT_RWX () {0x7;}' unless defined(&UVM_PROT_RWX);
    eval 'sub UVM_INH_MASK () {0x30;}' unless defined(&UVM_INH_MASK);
    eval 'sub UVM_INH_SHARE () {0x;}' unless defined(&UVM_INH_SHARE);
    eval 'sub UVM_INH_COPY () {0x10;}' unless defined(&UVM_INH_COPY);
    eval 'sub UVM_INH_NONE () {0x20;}' unless defined(&UVM_INH_NONE);
    eval 'sub UVM_INH_DONATE () {0x30;}' unless defined(&UVM_INH_DONATE);
    eval 'sub UVM_ADV_NORMAL () {0x;}' unless defined(&UVM_ADV_NORMAL);
    eval 'sub UVM_ADV_RANDOM () {0x1;}' unless defined(&UVM_ADV_RANDOM);
    eval 'sub UVM_ADV_SEQUENTIAL () {0x2;}' unless defined(&UVM_ADV_SEQUENTIAL);
    eval 'sub UVM_ADV_WILLNEED () {0x3;}' unless defined(&UVM_ADV_WILLNEED);
    eval 'sub UVM_ADV_DONTNEED () {0x4;}' unless defined(&UVM_ADV_DONTNEED);
    eval 'sub UVM_ADV_NOREUSE () {0x5;}' unless defined(&UVM_ADV_NOREUSE);
    eval 'sub UVM_ADV_MASK () {0x7;}' unless defined(&UVM_ADV_MASK);
    eval 'sub UVM_FLAG_FIXED () {0x10000;}' unless defined(&UVM_FLAG_FIXED);
    eval 'sub UVM_FLAG_OVERLAY () {0x20000;}' unless defined(&UVM_FLAG_OVERLAY);
    eval 'sub UVM_FLAG_NOMERGE () {0x40000;}' unless defined(&UVM_FLAG_NOMERGE);
    eval 'sub UVM_FLAG_COPYONW () {0x80000;}' unless defined(&UVM_FLAG_COPYONW);
    eval 'sub UVM_FLAG_AMAPPAD () {0x100000;}' unless defined(&UVM_FLAG_AMAPPAD);
    eval 'sub UVM_FLAG_TRYLOCK () {0x200000;}' unless defined(&UVM_FLAG_TRYLOCK);
    eval 'sub UVM_FLAG_NOWAIT () {0x400000;}' unless defined(&UVM_FLAG_NOWAIT);
    eval 'sub UVM_FLAG_WAITVA () {0x800000;}' unless defined(&UVM_FLAG_WAITVA);
    eval 'sub UVM_FLAG_VAONLY () {0x2000000;}' unless defined(&UVM_FLAG_VAONLY);
    eval 'sub UVM_FLAG_COLORMATCH () {0x4000000;}' unless defined(&UVM_FLAG_COLORMATCH);
    eval 'sub UVM_FLAG_UNMAP () {0x8000000;}' unless defined(&UVM_FLAG_UNMAP);
    eval 'sub UVM_FLAG_BITS () {"\\177\\020F\\0\\3:\\0PROT=NONE\\0:\\1PROT=R\\0:\\2PROT=W\\0:\\3PROT=RW\\0:\\4PROT=X\\0:\\5PROT=RX\\0:\\6PROT=WX\\0:\\7PROT=RWX\\0F\\4\\2:\\0INH=SHARE\\0:\\1INH=COPY\\0:\\2INH=NONE\\0:\\3INH=DONATE\\0F\\10\\3:\\0MAXPROT=NONE\\0:\\1MAXPROT=R\\0:\\2MAXPROT=W\\0:\\3MAXPROT=RW\\0:\\4MAXPROT=X\\0:\\5MAXPROT=RX\\0:\\6MAXPROT=WX\\0:\\7MAXPROT=RWX\\0F\\14\\3:\\0ADV=NORMAL\\0:\\1ADV=RANDOM\\0:\\2ADV=SEQUENTIAL\\0:\\3ADV=WILLNEED\\0:\\4ADV=DONTNEED\\0:\\5ADV=NOREUSE\\0b\\20FIXED\\0b\\21OVERLAY\\0b\\22NOMERGE\\0b\\23COPYONW\\0b\\24AMAPPAD\\0b\\25TRYLOCK\\0b\\26NOWAIT\\0b\\27WAITVA\\0b\\30VAONLY\\0b\\31COLORMATCH\\0b\\32UNMAP\\0";}' unless defined(&UVM_FLAG_BITS);
    eval 'sub UVM_PROTECTION {
        my($X) = @_;
	    eval q((($X) &  &UVM_PROT_MASK));
    }' unless defined(&UVM_PROTECTION);
    eval 'sub UVM_INHERIT {
        my($X) = @_;
	    eval q(((($X) &  &UVM_INH_MASK) >> 4));
    }' unless defined(&UVM_INHERIT);
    eval 'sub UVM_MAXPROTECTION {
        my($X) = @_;
	    eval q(((($X) >> 8) &  &UVM_PROT_MASK));
    }' unless defined(&UVM_MAXPROTECTION);
    eval 'sub UVM_ADVICE {
        my($X) = @_;
	    eval q(((($X) >> 12) &  &UVM_ADV_MASK));
    }' unless defined(&UVM_ADVICE);
    eval 'sub UVM_MAPFLAG {
        my($PROT,$MAXPROT,$INH,$ADVICE,$FLAGS) = @_;
	    eval q(((($MAXPROT) << 8)|($PROT)|($INH)|(($ADVICE) << 12)|($FLAGS)));
    }' unless defined(&UVM_MAPFLAG);
    eval 'sub UVM_UNKNOWN_OFFSET () {(( &voff_t) -1);}' unless defined(&UVM_UNKNOWN_OFFSET);
    eval 'sub UVM_KMF_WIRED () {0x1;}' unless defined(&UVM_KMF_WIRED);
    eval 'sub UVM_KMF_PAGEABLE () {0x2;}' unless defined(&UVM_KMF_PAGEABLE);
    eval 'sub UVM_KMF_VAONLY () {0x4;}' unless defined(&UVM_KMF_VAONLY);
    eval 'sub UVM_KMF_TYPEMASK () {( &UVM_KMF_VAONLY |  &UVM_KMF_PAGEABLE |  &UVM_KMF_WIRED);}' unless defined(&UVM_KMF_TYPEMASK);
    eval 'sub UVM_KMF_CANFAIL () {0x8;}' unless defined(&UVM_KMF_CANFAIL);
    eval 'sub UVM_KMF_ZERO () {0x10;}' unless defined(&UVM_KMF_ZERO);
    eval 'sub UVM_KMF_EXEC () {0x20;}' unless defined(&UVM_KMF_EXEC);
    eval 'sub UVM_KMF_TRYLOCK () { &UVM_FLAG_TRYLOCK;}' unless defined(&UVM_KMF_TRYLOCK);
    eval 'sub UVM_KMF_NOWAIT () { &UVM_FLAG_NOWAIT;}' unless defined(&UVM_KMF_NOWAIT);
    eval 'sub UVM_KMF_WAITVA () { &UVM_FLAG_WAITVA;}' unless defined(&UVM_KMF_WAITVA);
    eval 'sub UVM_KMF_COLORMATCH () { &UVM_FLAG_COLORMATCH;}' unless defined(&UVM_KMF_COLORMATCH);
    eval 'sub UVM_PGA_STRAT_NORMAL () {0;}' unless defined(&UVM_PGA_STRAT_NORMAL);
    eval 'sub UVM_PGA_STRAT_ONLY () {1;}' unless defined(&UVM_PGA_STRAT_ONLY);
    eval 'sub UVM_PGA_STRAT_FALLBACK () {2;}' unless defined(&UVM_PGA_STRAT_FALLBACK);
    eval 'sub UVM_PGA_STRAT_NUMA () {3;}' unless defined(&UVM_PGA_STRAT_NUMA);
    eval 'sub UVM_PGA_USERESERVE () {0x1;}' unless defined(&UVM_PGA_USERESERVE);
    eval 'sub UVM_PGA_ZERO () {0x2;}' unless defined(&UVM_PGA_ZERO);
    eval 'sub UBC_READ () {0x1;}' unless defined(&UBC_READ);
    eval 'sub UBC_WRITE () {0x2;}' unless defined(&UBC_WRITE);
    eval 'sub UBC_FAULTBUSY () {0x4;}' unless defined(&UBC_FAULTBUSY);
    eval 'sub UBC_ISMAPPED () {0x8;}' unless defined(&UBC_ISMAPPED);
    eval 'sub UBC_UNMAP () {0x10;}' unless defined(&UBC_UNMAP);
    eval 'sub UBC_PARTIALOK () {0x100;}' unless defined(&UBC_PARTIALOK);
    eval 'sub UFP_ALL () {0x;}' unless defined(&UFP_ALL);
    eval 'sub UFP_NOWAIT () {0x1;}' unless defined(&UFP_NOWAIT);
    eval 'sub UFP_NOALLOC () {0x2;}' unless defined(&UFP_NOALLOC);
    eval 'sub UFP_NOCACHE () {0x4;}' unless defined(&UFP_NOCACHE);
    eval 'sub UFP_NORDONLY () {0x8;}' unless defined(&UFP_NORDONLY);
    eval 'sub UFP_DIRTYONLY () {0x10;}' unless defined(&UFP_DIRTYONLY);
    eval 'sub UFP_BACKWARD () {0x20;}' unless defined(&UFP_BACKWARD);
    eval 'sub UFP_NOBUSY () {0x40;}' unless defined(&UFP_NOBUSY);
    eval 'sub UVM_LK_ENTER () {0x1;}' unless defined(&UVM_LK_ENTER);
    eval 'sub UVM_LK_EXIT () {0x2;}' unless defined(&UVM_LK_EXIT);
    eval 'sub UBC_MAX_PAGES () {8;}' unless defined(&UBC_MAX_PAGES);
    eval 'sub UVM_EMAP_INACTIVE () {(0);}' unless defined(&UVM_EMAP_INACTIVE);
    eval 'sub UVM_PCTPARAM_SHIFT () {8;}' unless defined(&UVM_PCTPARAM_SHIFT);
    eval 'sub UVM_PCTPARAM_SCALE () {(1<<  &UVM_PCTPARAM_SHIFT);}' unless defined(&UVM_PCTPARAM_SCALE);
    eval 'sub UVM_PCTPARAM_APPLY {
        my($pct, $x) = @_;
	    eval q(((( &uint64_t)($x) * ($pct)-> &pct_scaled) >>  &UVM_PCTPARAM_SHIFT));
    }' unless defined(&UVM_PCTPARAM_APPLY);
    if(defined(&_KERNEL)) {
    }
    require 'sys/vmmeter.ph';
    require 'sys/queue.ph';
    require 'sys/lock.ph';
    if(defined(&_KERNEL)) {
	require 'sys/vmem.ph';
    }
    require 'uvm/uvm_param.ph';
    require 'uvm/uvm_prot.ph';
    require 'uvm/uvm_pmap.ph';
    if(defined(&_KERNEL) || defined(&_KMEMUSER)) {
	require 'uvm/uvm_map.ph';
	require 'uvm/uvm_pager.ph';
    }
    if(defined(&_KERNEL)) {
	require 'uvm/uvm_physseg.ph';
    }
    if(defined(&PMAP_CACHE_VIVT)) {
	eval 'sub UBC_VNODE_FLAGS {
	    my($vp) = @_;
    	    eval q((((($vp)-> &v_iflag &  &VI_TEXT) != 0?  &UBC_UNMAP : 0) | ((($vp)-> &v_vflag &  &VV_MAPPED) != 0?  &UBC_ISMAPPED : 0)));
	}' unless defined(&UBC_VNODE_FLAGS);
    } else {
	eval 'sub UBC_VNODE_FLAGS {
	    my($vp) = @_;
    	    eval q(((($vp)-> &v_vflag &  &VV_MAPPED) != 0?  &UBC_ISMAPPED : 0));
	}' unless defined(&UBC_VNODE_FLAGS);
    }
    if(defined(&_KERNEL) || defined(&_KMEMUSER)) {
	eval 'sub vm_startcopy () { &vm_rssize;}' unless defined(&vm_startcopy);
	eval 'sub VMSPACE_IS_KERNEL_P {
	    my($vm) = @_;
    	    eval q( &VM_MAP_IS_KERNEL(($vm)-> &vm_map));
	}' unless defined(&VMSPACE_IS_KERNEL_P);
    }
    if(defined(&_KERNEL)) {
	eval 'sub UVM_COREDUMP_STACK () {0x1;}' unless defined(&UVM_COREDUMP_STACK);
	eval 'sub vm_resident_count {
	    my($vm) = @_;
    	    eval q(( &pmap_resident_count(($vm)-> ($vm_map->{pmap}))));
	}' unless defined(&vm_resident_count);
	eval 'sub uvm_fault {
	    my($m, $a, $p) = @_;
    	    eval q( &uvm_fault_internal($m, $a, $p, 0));
	}' unless defined(&uvm_fault);
	if(defined(&KGDB)) {
	}
	eval 'sub uvm_pagealloc {
	    my($obj, $off, $anon, $flags) = @_;
    	    eval q( &uvm_pagealloc_strat(($obj), ($off), ($anon), ($flags),  &UVM_PGA_STRAT_NORMAL, 0));
	}' unless defined(&uvm_pagealloc);
    }
}
1;
