/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;

public class CombinedClassLoader
extends ClassLoader {
    ClassLoader[] loaders;

    protected Class findClass(String string) throws ClassNotFoundException {
        int n = 0;
        while (n < this.loaders.length) {
            try {
                return this.loaders[n].loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ++n;
            }
        }
        return super.findClass(string);
    }

    protected URL findResource(String string) {
        int n = 0;
        while (n < this.loaders.length) {
            URL uRL = this.loaders[n].getResource(string);
            if (uRL != null) {
                return uRL;
            }
            ++n;
        }
        return super.findResource(string);
    }

    protected Enumeration findResources(String string) throws IOException {
        int n = 0;
        while (n < this.loaders.length) {
            Enumeration enumeration = this.loaders[n].getResources(string);
            if (enumeration != null) {
                return enumeration;
            }
            ++n;
        }
        return super.findResources(string);
    }

    public CombinedClassLoader(Collection collection) {
        ArrayList arrayList = new ArrayList(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (arrayList.contains(object)) continue;
            arrayList.add(object);
        }
        this.loaders = new ClassLoader[arrayList.size()];
        int n = 0;
        while (n < this.loaders.length) {
            this.loaders[n] = (ClassLoader)arrayList.get(n);
            ++n;
        }
    }
}

