/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import gnu.java.nio.charset.US_ASCII;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

final class ISO_8859_1
extends Charset {
    public final boolean contains(Charset charset) {
        boolean bl = false;
        if (charset instanceof US_ASCII || charset instanceof ISO_8859_1) {
            bl = true;
        }
        return bl;
    }

    public final CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public final CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    ISO_8859_1() {
        super("ISO-8859-1", new String[]{"iso-ir-100", "ISO_8859-1", "latin1", "l1", "IBM819", "CP819", "csISOLatin1", "8859_1", "ISO8859_1", "ISO_8859_1", "ibm-819", "ISO_8859-1:1987", "819"});
    }

    private static final class Decoder
    extends CharsetDecoder {
        protected final CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            while (byteBuffer.hasRemaining()) {
                byte by = byteBuffer.get();
                if (!charBuffer.hasRemaining()) {
                    byteBuffer.position(byteBuffer.position() - 1);
                    return CoderResult.OVERFLOW;
                }
                charBuffer.put((char)(by & 0xFF));
            }
            return CoderResult.UNDERFLOW;
        }

        Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }
    }

    private static final class Encoder
    extends CharsetEncoder {
        protected final CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            while (charBuffer.hasRemaining()) {
                char c = charBuffer.get();
                if (c > '\u00ff') {
                    charBuffer.position(charBuffer.position() - 1);
                    return CoderResult.unmappableForLength(1);
                }
                if (!byteBuffer.hasRemaining()) {
                    charBuffer.position(charBuffer.position() - 1);
                    return CoderResult.OVERFLOW;
                }
                byteBuffer.put((byte)c);
            }
            return CoderResult.UNDERFLOW;
        }

        Encoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }
    }
}

