/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class LineNumberReader
extends BufferedReader {
    private int lineNumber;
    private boolean matchedNewLine;
    private int savedLineNumber;

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int n) {
        this.lineNumber = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void mark(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Read-ahead limit is negative");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.pos + n > this.limit) {
                int n2 = this.matchedNewLine;
                char[] cArray = this.buffer;
                if (n > this.limit) {
                    this.buffer = new char[n2 + n];
                }
                int n3 = this.pos - n2;
                this.savedLineNumber = this.lineNumber;
                this.limit -= n3;
                System.arraycopy(cArray, n3, this.buffer, 0, this.limit);
                this.pos = n2;
            }
            this.markPos = this.pos;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.markPos < 0) {
                throw new IOException("mark never set or invalidated");
            }
            this.lineNumber = this.savedLineNumber;
            this.pos = this.markPos;
            boolean bl = false;
            if (this.markPos > 0 && this.buffer[this.markPos - 1] == '\r') {
                bl = true;
            }
            this.matchedNewLine = bl;
            return;
        }
    }

    private final int fill() throws IOException {
        int n;
        if (this.markPos >= 0 && this.limit == this.buffer.length) {
            this.markPos = -1;
        }
        if (this.markPos < 0) {
            this.limit = 0;
            this.pos = 0;
        }
        if ((n = this.in.read(this.buffer, this.limit, this.buffer.length - this.limit)) <= 0) {
            return -1;
        }
        this.limit += n;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.skipRedundantLF();
            if (this.pos >= this.limit && this.fill() < 0) {
                return -1;
            }
            char c = this.buffer[this.pos++];
            boolean bl = false;
            if (c == '\r') {
                bl = this.matchedNewLine = true;
            }
            if (!bl && c != '\n') {
                this.matchedNewLine = false;
                return c;
            }
            ++this.lineNumber;
            return 10;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        if (cArray == null) {
            throw new NullPointerException();
        }
        if (n + n2 > cArray.length || n < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 <= 0) {
            if (n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            return 0;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.pos >= this.limit && this.fill() < 0) {
                return -1;
            }
            int n3 = n;
            boolean bl = this.matchedNewLine;
            while (n2-- > 0 && this.pos < this.limit) {
                char c;
                if ((c = this.buffer[this.pos++]) == '\r') {
                    ++this.lineNumber;
                    bl = true;
                } else if (c == '\n' && !bl) {
                    ++this.lineNumber;
                } else {
                    bl = false;
                }
                cArray[n++] = c;
            }
            this.matchedNewLine = bl;
            return n - n3;
        }
    }

    private final void skipRedundantLF() throws IOException {
        if (this.pos > 0 && this.matchedNewLine) {
            if (this.pos < this.limit) {
                if (this.buffer[this.pos] == '\n') {
                    ++this.pos;
                }
            } else {
                if (this.fill() <= 0) {
                    return;
                }
                if (this.buffer[this.pos] == '\n') {
                    ++this.pos;
                }
            }
            this.matchedNewLine = true;
        }
    }

    public String readLine() throws IOException {
        int n = this.lineNumber;
        this.skipRedundantLF();
        String string = super.readLine();
        if (this.pos > this.limit) {
            --this.pos;
        }
        if (string != null) {
            this.lineNumber = n + 1;
        }
        return string;
    }

    public long skip(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("skip() value is negative");
        }
        if (l == 0L) {
            return 0L;
        }
        char[] cArray = new char[1];
        int n = 0;
        while ((long)n < l) {
            int n2 = this.read(cArray, 0, 1);
            if (n2 < 0) break;
            ++n;
        }
        return n;
    }

    public LineNumberReader(Reader reader) {
        super(reader, 8192);
    }

    public LineNumberReader(Reader reader, int n) {
        super(reader, n);
    }
}

