/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.SpinnerUI;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JSpinner
extends JComponent {
    private static final long serialVersionUID = 3412663575706551720L;
    private SpinnerModel model;
    private JComponent editor;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public void commitEdit() throws ParseException {
        if (this.editor instanceof DefaultEditor) {
            ((DefaultEditor)this.editor).commitEdit();
        }
    }

    public JComponent getEditor() {
        return this.editor;
    }

    public void setEditor(JComponent jComponent) {
        if (jComponent == null) {
            throw new IllegalArgumentException("editor may not be null");
        }
        JComponent jComponent2 = this.editor;
        if (jComponent2 instanceof DefaultEditor) {
            ((DefaultEditor)jComponent2).dismiss(this);
        } else if (jComponent2 instanceof ChangeListener) {
            this.removeChangeListener((ChangeListener)((Object)jComponent2));
        }
        this.editor = jComponent;
        this.firePropertyChange("editor", jComponent2, jComponent);
    }

    public SpinnerModel getModel() {
        return this.model;
    }

    public void setModel(SpinnerModel spinnerModel) {
        if (spinnerModel == null) {
            throw new IllegalArgumentException();
        }
        if (this.model == spinnerModel) {
            return;
        }
        SpinnerModel spinnerModel2 = this.model;
        this.model = spinnerModel;
        this.firePropertyChange("model", spinnerModel2, spinnerModel);
        this.setEditor(this.createEditor(this.model));
    }

    public Object getNextValue() {
        return this.model.getNextValue();
    }

    public Object getPreviousValue() {
        return this.model.getPreviousValue();
    }

    public SpinnerUI getUI() {
        return (SpinnerUI)this.ui;
    }

    public Object getValue() {
        return this.model.getValue();
    }

    public void setValue(Object object) {
        this.model.setValue(object);
    }

    public String getUIClassID() {
        return "SpinnerUI";
    }

    public void updateUI() {
        this.setUI((SpinnerUI)UIManager.getUI(this));
    }

    public void setUI(SpinnerUI spinnerUI) {
        super.setUI(spinnerUI);
    }

    public void addChangeListener(ChangeListener changeListener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = JSpinner.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.add(clazz, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = JSpinner.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.remove(clazz, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = JSpinner.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        return (ChangeListener[])this.listenerList.getListeners(clazz);
    }

    protected void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        ChangeListener[] changeListenerArray = this.getChangeListeners();
        int n = 0;
        while (n < changeListenerArray.length) {
            changeListenerArray[n].stateChanged(changeEvent);
            ++n;
        }
    }

    protected JComponent createEditor(SpinnerModel spinnerModel) {
        if (spinnerModel instanceof SpinnerDateModel) {
            return new DateEditor(this);
        }
        if (spinnerModel instanceof SpinnerNumberModel) {
            return new NumberEditor(this);
        }
        if (spinnerModel instanceof SpinnerListModel) {
            return new ListEditor(this);
        }
        return new DefaultEditor(this);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public JSpinner() {
        this(new SpinnerNumberModel());
    }

    public JSpinner(SpinnerModel spinnerModel) {
        this.model = spinnerModel;
        this.editor = this.createEditor(spinnerModel);
        spinnerModel.addChangeListener(new ModelListener());
        this.updateUI();
    }

    public static class DefaultEditor
    extends JPanel
    implements ChangeListener,
    PropertyChangeListener,
    LayoutManager {
        private static final long serialVersionUID = -5317788736173368172L;
        private JSpinner spinner;
        JFormattedTextField ftf;

        public JSpinner getSpinner() {
            return this.spinner;
        }

        public void commitEdit() throws ParseException {
        }

        public void dismiss(JSpinner jSpinner) {
            jSpinner.removeChangeListener(this);
        }

        public JFormattedTextField getTextField() {
            return this.ftf;
        }

        public void layoutContainer(Container container) {
            Insets insets = this.getInsets();
            Dimension dimension = this.getSize();
            this.ftf.setBounds(insets.left, insets.top, dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
        }

        public Dimension minimumLayoutSize(Container container) {
            Insets insets = this.getInsets();
            Dimension dimension = this.ftf.getMinimumSize();
            return new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
        }

        public Dimension preferredLayoutSize(Container container) {
            Insets insets = this.getInsets();
            Dimension dimension = this.ftf.getPreferredSize();
            return new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == this.ftf && propertyChangeEvent.getPropertyName().equals("value")) {
                this.spinner.getModel().setValue(propertyChangeEvent.getNewValue());
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.ftf.setValue(this.spinner.getValue());
        }

        public void removeLayoutComponent(Component component) {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public DefaultEditor(JSpinner jSpinner) {
            this.setLayout(this);
            this.spinner = jSpinner;
            this.ftf = new JFormattedTextField();
            this.add(this.ftf);
            this.ftf.setValue(jSpinner.getValue());
            this.ftf.addPropertyChangeListener(this);
            jSpinner.addChangeListener(this);
        }
    }

    public static class DateEditor
    extends DefaultEditor {
        private static final long serialVersionUID = -4279356973770397815L;

        public SimpleDateFormat getFormat() {
            DateFormatter dateFormatter = (DateFormatter)this.ftf.getFormatter();
            return (SimpleDateFormat)dateFormatter.getFormat();
        }

        public SpinnerDateModel getModel() {
            return (SpinnerDateModel)this.getSpinner().getModel();
        }

        public DateEditor(JSpinner jSpinner) {
            super(jSpinner);
            DateEditorFormatter dateEditorFormatter = new DateEditorFormatter();
            dateEditorFormatter.setMinimum(this.getModel().getStart());
            dateEditorFormatter.setMaximum(this.getModel().getEnd());
            this.ftf.setFormatterFactory(new DefaultFormatterFactory(dateEditorFormatter));
        }

        public DateEditor(JSpinner jSpinner, String string) {
            super(jSpinner);
            DateEditorFormatter dateEditorFormatter = new DateEditorFormatter(string);
            dateEditorFormatter.setMinimum(this.getModel().getStart());
            dateEditorFormatter.setMaximum(this.getModel().getEnd());
            this.ftf.setFormatterFactory(new DefaultFormatterFactory(dateEditorFormatter));
        }
    }

    public static class NumberEditor
    extends DefaultEditor {
        private static final long serialVersionUID = 3791956183098282942L;

        public DecimalFormat getFormat() {
            NumberFormatter numberFormatter = (NumberFormatter)this.ftf.getFormatter();
            return (DecimalFormat)numberFormatter.getFormat();
        }

        public SpinnerNumberModel getModel() {
            return (SpinnerNumberModel)this.getSpinner().getModel();
        }

        public NumberEditor(JSpinner jSpinner) {
            super(jSpinner);
            NumberEditorFormatter numberEditorFormatter = new NumberEditorFormatter();
            numberEditorFormatter.setMinimum(this.getModel().getMinimum());
            numberEditorFormatter.setMaximum(this.getModel().getMaximum());
            this.ftf.setFormatterFactory(new DefaultFormatterFactory(numberEditorFormatter));
        }

        public NumberEditor(JSpinner jSpinner, String string) {
            super(jSpinner);
            NumberEditorFormatter numberEditorFormatter = new NumberEditorFormatter(string);
            numberEditorFormatter.setMinimum(this.getModel().getMinimum());
            numberEditorFormatter.setMaximum(this.getModel().getMaximum());
            this.ftf.setFormatterFactory(new DefaultFormatterFactory(numberEditorFormatter));
        }
    }

    public static class ListEditor
    extends DefaultEditor {
        public SpinnerListModel getModel() {
            return (SpinnerListModel)this.getSpinner().getModel();
        }

        public ListEditor(JSpinner jSpinner) {
            super(jSpinner);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ModelListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            JSpinner.this.fireStateChanged();
        }
    }

    static class DateEditorFormatter
    extends DateFormatter {
        public DateEditorFormatter() {
            super(DateFormat.getInstance());
        }

        public DateEditorFormatter(String string) {
            super(new SimpleDateFormat(string));
        }
    }

    static class NumberEditorFormatter
    extends NumberFormatter {
        public NumberEditorFormatter() {
            super(NumberFormat.getInstance());
        }

        public NumberEditorFormatter(String string) {
            super(new DecimalFormat(string));
        }
    }
}

