/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.BlockView;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLTableView;
import javax.swing.text.html.InlineView;
import javax.swing.text.html.NullView;
import javax.swing.text.html.ParagraphView;
import javax.swing.text.html.StyleSheet;
import javax.swing.text.html.parser.ParserDelegator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HTMLEditorKit
extends StyledEditorKit
implements Serializable,
Cloneable,
Accessible {
    private static final long serialVersionUID = 8751997116710384592L;
    public static final String DEFAULT_CSS = "default.css";
    public static final String BOLD_ACTION = "html-bold-action";
    public static final String ITALIC_ACTION = "html-italic-action";
    public static final String COLOR_ACTION = "html-color-action";
    public static final String FONT_CHANGE_BIGGER = "html-font-bigger";
    public static final String FONT_CHANGE_SMALLER = "html-font-smaller";
    public static final String IMG_ALIGN_BOTTOM = "html-image-align-bottom";
    public static final String IMG_ALIGN_MIDDLE = "html-image-align-middle";
    public static final String IMG_ALIGN_TOP = "html-image-align-top";
    public static final String IMG_BORDER = "html-image-border";
    public static final String LOGICAL_STYLE_ACTION = "html-logical-style-action";
    public static final String PARA_INDENT_LEFT = "html-para-indent-left";
    public static final String PARA_INDENT_RIGHT = "html-para-indent-right";
    private static final Action[] defaultActions = new Action[0];
    StyleSheet styleSheet;
    HTMLFactory viewFactory;
    Cursor linkCursor;
    Cursor defaultCursor;
    Parser parser;
    LinkController mouseListener;
    StyleContext styleContext;
    String contentType;
    MutableAttributeSet inputAttributes;
    JEditorPane editorPane;

    public ViewFactory getViewFactory() {
        if (this.viewFactory == null) {
            this.viewFactory = new HTMLFactory();
        }
        return this.viewFactory;
    }

    public Document createDefaultDocument() {
        HTMLDocument hTMLDocument = new HTMLDocument(this.getStyleSheet());
        hTMLDocument.setParser(this.getParser());
        return hTMLDocument;
    }

    protected Parser getParser() {
        if (this.parser == null) {
            this.parser = new ParserDelegator();
        }
        return this.parser;
    }

    public void insertHTML(HTMLDocument hTMLDocument, int n, String string, int n2, int n3, HTML.Tag tag) throws BadLocationException, IOException {
        Parser parser = this.getParser();
        if (n < 0 || n > hTMLDocument.getLength()) {
            throw new BadLocationException("Bad location", n);
        }
        if (parser == null) {
            throw new IOException("Parser is null.");
        }
        ParserCallback parserCallback = hTMLDocument.getReader(n, n2, n3, tag);
        parser.parse(new StringReader(string), parserCallback, false);
        parserCallback.flush();
    }

    public void read(Reader reader, Document document, int n) throws IOException, BadLocationException {
        if (document instanceof HTMLDocument) {
            Parser parser = this.getParser();
            if (n < 0 || n > document.getLength()) {
                throw new BadLocationException("Bad location", n);
            }
            if (parser == null) {
                throw new IOException("Parser is null.");
            }
            HTMLDocument hTMLDocument = (HTMLDocument)document;
            if (this.editorPane != null) {
                hTMLDocument.setBase(this.editorPane.getPage());
            }
            ParserCallback parserCallback = hTMLDocument.getReader(n);
            parser.parse(reader, parserCallback, false);
            parserCallback.flush();
        } else {
            super.read(reader, document, n);
        }
    }

    public void write(Writer writer, Document document, int n, int n2) throws IOException, BadLocationException {
        if (document instanceof HTMLDocument) {
            writer.write(document.getText(n, n2));
        } else {
            super.write(writer, document, n, n2);
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public Object clone() {
        return (HTMLEditorKit)super.clone();
    }

    protected void createInputAttributes(Element element, MutableAttributeSet mutableAttributeSet) {
        mutableAttributeSet.removeAttributes(mutableAttributeSet);
        mutableAttributeSet.addAttributes(element.getAttributes());
    }

    public void install(JEditorPane jEditorPane) {
        super.install(jEditorPane);
        this.mouseListener = new LinkController();
        jEditorPane.addMouseListener(this.mouseListener);
        this.editorPane = jEditorPane;
    }

    public void deinstall(JEditorPane jEditorPane) {
        super.deinstall(jEditorPane);
        jEditorPane.removeMouseListener(this.mouseListener);
        this.mouseListener = null;
        this.editorPane = null;
    }

    public AccessibleContext getAccessibleContext() {
        return null;
    }

    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), defaultActions);
    }

    public Cursor getDefaultCursor() {
        if (this.defaultCursor == null) {
            this.defaultCursor = Cursor.getDefaultCursor();
        }
        return this.defaultCursor;
    }

    public Cursor getLinkCursor() {
        if (this.linkCursor == null) {
            this.linkCursor = Cursor.getPredefinedCursor(12);
        }
        return this.linkCursor;
    }

    public void setLinkCursor(Cursor cursor) {
        this.linkCursor = cursor;
    }

    public void setDefaultCursor(Cursor cursor) {
        this.defaultCursor = cursor;
    }

    public MutableAttributeSet getInputAttributes() {
        return this.inputAttributes;
    }

    public StyleSheet getStyleSheet() {
        if (this.styleSheet == null) {
            this.styleSheet = new StyleSheet();
            this.styleSheet.importStyleSheet(this.getClass().getResource(DEFAULT_CSS));
        }
        return this.styleSheet;
    }

    public void setStyleSheet(StyleSheet styleSheet) {
        this.styleSheet = styleSheet;
    }

    private final /* synthetic */ void this() {
        this.contentType = "text/html";
    }

    public HTMLEditorKit() {
        this.this();
        this.styleContext = new StyleContext();
        this.styleSheet = new StyleSheet();
        this.styleSheet.importStyleSheet(this.getClass().getResource(DEFAULT_CSS));
    }

    public static class HTMLFactory
    implements ViewFactory {
        public View create(Element element) {
            View view = null;
            Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (object instanceof HTML.Tag) {
                HTML.Tag tag = (HTML.Tag)object;
                if (tag.equals(HTML.Tag.IMPLIED) || tag.equals(HTML.Tag.P) || tag.equals(HTML.Tag.H1) || tag.equals(HTML.Tag.H2) || tag.equals(HTML.Tag.H3) || tag.equals(HTML.Tag.H4) || tag.equals(HTML.Tag.H5) || tag.equals(HTML.Tag.H6) || tag.equals(HTML.Tag.DT)) {
                    view = new ParagraphView(element);
                } else if (tag.equals(HTML.Tag.LI) || tag.equals(HTML.Tag.DL) || tag.equals(HTML.Tag.DD) || tag.equals(HTML.Tag.BODY) || tag.equals(HTML.Tag.HTML) || tag.equals(HTML.Tag.CENTER) || tag.equals(HTML.Tag.DIV) || tag.equals(HTML.Tag.BLOCKQUOTE) || tag.equals(HTML.Tag.PRE)) {
                    view = new BlockView(element, 1);
                } else if (tag.equals(HTML.Tag.CONTENT)) {
                    view = new InlineView(element);
                } else if (tag == HTML.Tag.HEAD) {
                    view = new NullView(element);
                } else if (tag.equals(HTML.Tag.TABLE)) {
                    view = new HTMLTableView(element);
                } else if (tag.equals(HTML.Tag.TD)) {
                    view = new ParagraphView(element);
                }
            }
            if (view == null) {
                System.err.println("missing tag->view mapping for: " + element);
                view = new NullView(element);
            }
            return view;
        }
    }

    public static abstract class Parser {
        public abstract void parse(Reader var1, ParserCallback var2, boolean var3) throws IOException;
    }

    public static class ParserCallback {
        public static final Object IMPLIED = "_implied_";

        public void flush() throws BadLocationException {
        }

        public void handleComment(char[] cArray, int n) {
        }

        public void handleEndOfLineString(String string) {
        }

        public void handleEndTag(HTML.Tag tag, int n) {
        }

        public void handleError(String string, int n) {
        }

        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
        }

        public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
        }

        public void handleText(char[] cArray, int n) {
        }
    }

    public static class LinkController
    extends MouseAdapter
    implements MouseMotionListener,
    Serializable {
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        protected void activateLink(int n, JEditorPane jEditorPane) {
        }
    }

    public static abstract class HTMLTextAction
    extends StyledEditorKit.StyledTextAction {
        protected HTMLDocument getHTMLDocument(JEditorPane jEditorPane) {
            Document document = jEditorPane.getDocument();
            if (document instanceof HTMLDocument) {
                return (HTMLDocument)document;
            }
            throw new IllegalArgumentException("Document is not a HTMLDocument.");
        }

        protected HTMLEditorKit getHTMLEditorKit(JEditorPane jEditorPane) {
            EditorKit editorKit = jEditorPane.getEditorKit();
            if (editorKit instanceof HTMLEditorKit) {
                return (HTMLEditorKit)editorKit;
            }
            throw new IllegalArgumentException("EditorKit is not a HTMLEditorKit.");
        }

        protected Element[] getElementsAt(HTMLDocument hTMLDocument, int n) {
            return this.getElementsAt(hTMLDocument.getDefaultRootElement(), n, 0);
        }

        private final Element[] getElementsAt(Element element, int n, int n2) {
            Element[] elementArray = null;
            if (element != null) {
                if (element.isLeaf()) {
                    elementArray = new Element[n2 + 1];
                    elementArray[n2] = element;
                    return elementArray;
                }
                elementArray = this.getElementsAt(element.getElement(element.getElementIndex(n)), n, n2 + 1);
                elementArray[n2] = element;
            }
            return elementArray;
        }

        protected int elementCountToTag(HTMLDocument hTMLDocument, int n, HTML.Tag tag) {
            Element element = hTMLDocument.getDefaultRootElement();
            int n2 = -1;
            Element element2 = element.getElement(element.getElementIndex(n));
            while (!element2.isLeaf()) {
                ++n2;
                if (element2.getAttributes().getAttribute(StyleConstants.NameAttribute).equals(tag)) {
                    return n2;
                }
                element2 = element2.getElement(element2.getElementIndex(n));
            }
            return n2;
        }

        protected Element findElementMatchingTag(HTMLDocument hTMLDocument, int n, HTML.Tag tag) {
            Element element = hTMLDocument.getDefaultRootElement();
            Element element2 = null;
            while (element != null) {
                Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
                if (object instanceof HTML.Tag && object.equals(tag)) {
                    element2 = element;
                }
                element = element.getElement(element.getElementIndex(n));
            }
            return element2;
        }

        public HTMLTextAction(String string) {
            super(string);
        }
    }

    public static class InsertHTMLTextAction
    extends HTMLTextAction {
        protected HTML.Tag addTag;
        protected HTML.Tag alternateAddTag;
        protected HTML.Tag alternateParentTag;
        protected String html;
        protected HTML.Tag parentTag;

        protected void insertHTML(JEditorPane jEditorPane, HTMLDocument hTMLDocument, int n, String string, int n2, int n3, HTML.Tag tag) {
            try {
                super.getHTMLEditorKit(jEditorPane).insertHTML(hTMLDocument, n, string, n2, n3, tag);
            }
            catch (IOException iOException) {
                throw (RuntimeException)new RuntimeException("Parser is null.").initCause(iOException);
            }
            catch (BadLocationException badLocationException) {
                throw (RuntimeException)new RuntimeException("BadLocationException: " + n).initCause(badLocationException);
            }
        }

        protected void insertAtBoundary(JEditorPane jEditorPane, HTMLDocument hTMLDocument, int n, Element element, String string, HTML.Tag tag, HTML.Tag tag2) {
        }

        protected void insertAtBoundry(JEditorPane jEditorPane, HTMLDocument hTMLDocument, int n, Element element, String string, HTML.Tag tag, HTML.Tag tag2) {
            this.insertAtBoundary(jEditorPane, hTMLDocument, n, element, string, tag, tag2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JEditorPane jEditorPane;
            Document document;
            Object object = actionEvent.getSource();
            if (object instanceof JEditorPane && (document = (jEditorPane = (JEditorPane)object).getDocument()) instanceof HTMLDocument) {
                this.insertHTML(jEditorPane, (HTMLDocument)document, 0, this.html, 0, 0, this.addTag);
            }
        }

        public InsertHTMLTextAction(String string, String string2, HTML.Tag tag, HTML.Tag tag2) {
            this(string, string2, tag, tag2, null, null);
        }

        public InsertHTMLTextAction(String string, String string2, HTML.Tag tag, HTML.Tag tag2, HTML.Tag tag3, HTML.Tag tag4) {
            super(string);
            this.html = string2;
            this.parentTag = tag;
            this.addTag = tag2;
            this.alternateParentTag = tag3;
            this.alternateAddTag = tag4;
        }
    }
}

