/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.util.List;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ClassInheritanceHandler
implements AnnotationParser.ClassHandler {
    private static final Logger LOG = Log.getLogger(ClassInheritanceHandler.class);
    MultiMap _inheritanceMap = new MultiMap();

    public void handle(String className, int version, int access, String signature, String superName, String[] interfaces) {
        try {
            for (int i = 0; interfaces != null && i < interfaces.length; ++i) {
                this._inheritanceMap.add(interfaces[i], className);
            }
            if (!"java.lang.Object".equals(superName)) {
                this._inheritanceMap.add(superName, className);
            }
        }
        catch (Exception e) {
            LOG.warn(e);
        }
    }

    public List getClassNamesExtendingOrImplementing(String className) {
        return this._inheritanceMap.getValues(className);
    }

    public MultiMap getMap() {
        return this._inheritanceMap;
    }
}

