/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.util.list;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.activemq.apollo.util.list.LinkedNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedNodeList<T extends LinkedNode<T>>
implements Iterable<T> {
    T head;
    int size;

    public final boolean isEmpty() {
        return this.head == null;
    }

    public final void addLast(T node) {
        ((LinkedNode)node).linkToTail(this);
    }

    public final void addFirst(T node) {
        ((LinkedNode)node).linkToHead(this);
    }

    public final T getHead() {
        return this.head;
    }

    public final T getTail() {
        if (this.head == null) {
            return null;
        }
        return ((LinkedNode)this.head).prev;
    }

    public final void clear() {
        while (this.head != null) {
            ((LinkedNode)this.head).unlink();
        }
    }

    public final void addLast(LinkedNodeList<T> list) {
        if (list.isEmpty()) {
            return;
        }
        if (this.head == null) {
            this.head = list.head;
            this.reparent(list);
        } else {
            ((LinkedNode)this.getTail()).linkAfter(list);
        }
    }

    public final void addFirst(LinkedNodeList<T> list) {
        if (list.isEmpty()) {
            return;
        }
        if (this.head == null) {
            this.reparent(list);
            this.head = list.head;
            list.head = null;
        } else {
            ((LinkedNode)this.getHead()).linkBefore(list);
        }
    }

    public final T reparent(LinkedNodeList<T> list) {
        this.size += list.size;
        T n = list.head;
        do {
            ((LinkedNode)n).list = this;
        } while ((n = ((LinkedNode)n).next) != list.head);
        list.head = null;
        list.size = 0;
        return n;
    }

    public final T rotate() {
        if (this.head == null) {
            return null;
        }
        this.head = ((LinkedNode)this.head).getNextCircular();
        return this.head;
    }

    public final void rotateTo(T head) {
        assert (head != null) : "Cannot rotate to a null head";
        assert (((LinkedNode)head).list == this) : "Cannot rotate to a node not linked to this list";
        this.head = head;
    }

    public int size() {
        return this.size;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        for (T cur = this.getHead(); cur != null; cur = ((LinkedNode)cur).getNext()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(cur);
            first = false;
        }
        sb.append("]");
        return sb.toString();
    }

    public final ArrayList<T> toArrayList() {
        ArrayList<T> rc = new ArrayList<T>(this.size);
        for (T cur = this.head; cur != null; cur = ((LinkedNode)cur).getNext()) {
            rc.add(cur);
        }
        return rc;
    }

    public final ArrayList<T> toArrayListReversed() {
        ArrayList<T> rc = new ArrayList<T>(this.size);
        if (this.head != null) {
            for (T cur = this.getTail(); cur != null; cur = ((LinkedNode)cur).getPrevious()) {
                rc.add(cur);
            }
        }
        return rc;
    }

    public final T[] toArray(T[] array) {
        int pos = 0;
        ArrayList rc = new ArrayList(this.size);
        for (T cur = this.head; cur != null; cur = ((LinkedNode)cur).getNext()) {
            array[pos] = cur;
            ++pos;
        }
        return array;
    }

    @Override
    public final Iterator<T> iterator() {
        return new Iterator<T>(){
            T next;
            private T last;
            {
                this.next = LinkedNodeList.this.getHead();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public T next() {
                this.last = this.next;
                this.next = ((LinkedNode)this.last).getNext();
                return this.last;
            }

            @Override
            public void remove() {
                if (this.last == null) {
                    throw new IllegalStateException();
                }
                ((LinkedNode)this.last).unlink();
                this.last = null;
            }
        };
    }
}

