<?php
    //-----------------------------------------------------------------------
    // index.php
    //
    // Handles initialization and menu setup.
    //
    //-----------------------------------------------------------------------
     
     
    // debug toggle
    $debugging = false;
     
    // include core shards
    include("engine/core/misc.php");
    include("engine/core/db.php");
    include("engine/core/render.php");
    include("engine/core/benchmark.php");
    include("engine/core/feedwriter.php");
    include("engine/core/formatting.php");
     
     
    connectMysql();
     
     
     
     
    // siteSettings determines the layout and content of the blur6ex system
    // manual editing is okay, but the admin menu is the preferred way to make changes
    //
    // lMenu - the left side of the layout
    // rMenu - the right side of the layout
    // defaultShard - the shard that is loaded when index.php executes
    // graft - the style for the layout
    // titlebase - the base name in the title bar
    // titledesc - a description in the title bar
    // slickurls - requires mod_rewrite; search-engine friendly URLs
    // siteurl - building the friendly links requires absolute URLs; this will be set automatically if slickurls is TRUE
    // datestyle - the way the date appears under a post heading
    //   minimal - 05 January 2005
    //   short - 05 January 2005 2:50PM
    //   full - Posted by steven at 2:46PM Tuesday, January 05th, 2005
    $siteSettings = array(
     
    	'lMenu' => "",
        'rMenu' => "m_blog::m_categories:m_archives:m_content:m_admin:m_login",
        'defaultShard' => "blog",
        'graft' => "singularity",
        'titlebase' => "blog and content ::",
        'titledesc' => " powered by blur6ex",
        'slickurls' => false,
        'siteurl' => "",
        'datestyle' => "full" );
     
     
     
    // Any links created by the shards will need to be absolute if slickurls is true.  To save time
    // and file size, go ahead and extract the site URL to build the links off of.
    //
    if ($siteSettings['slickurls'] == TRUE && $siteSettings['siteurl'] == "" )
    {
        $file = explode("/" , $_SERVER['SCRIPT_NAME'] );
        array_pop($file );
        $path = implode("/", $file );
         
        if ($_SERVER['SERVER_PORT'] == '80' )
            $siteSettings['siteurl'] = "http://" . $_SERVER['SERVER_NAME'] . $path;
        else
            $siteSettings['siteurl'] = "http://" . $_SERVER['SERVER_NAME'] . ':' . $_SERVER['SERVER_PORT'] . $path;
    }
     
     
     
     
    // Authenticate user
    include("engine/core/authenticate.php");
     
    if (!isset($_REQUEST["shard"]))
    {
        $shard = $siteSettings["defaultShard"];
    }
    else
    {
        $shard = $_REQUEST["shard"];
    }
     
     
     
    if (!isset($_REQUEST["action"]))
    {
        $action = "g_default";
    }
    else
    {
        $action = $_REQUEST["action"];
    }
     
    // log site access
    logHit($CURRENTUSER, $shard, $action);
     
     
    // rendering main shard...
    //start_benchmark("main");
    render($shard, $action);
    //stop_benchmark();
     
     
     
     
     
     
     
    // uninitialize
    mysql_close();
     
     
?>

