/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.util;

import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.OptionParser;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.util.Version;
import com.thaiopensource.validate.Flag;
import com.thaiopensource.validate.Option;
import com.thaiopensource.validate.OptionArgumentException;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.ValidationDriver;
import com.thaiopensource.validate.auto.AutoSchemaReader;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import com.thaiopensource.validate.rng.RngProperty;
import com.thaiopensource.xml.sax.ErrorHandlerImpl;
import java.io.IOException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class Driver {
    private static String usageKey = "usage";
    private boolean timing = false;
    private String encoding = null;
    private Localizer localizer = new Localizer(Driver.class);

    Driver() {
    }

    public static void setUsageKey(String key) {
        usageKey = key;
    }

    public static void main(String[] args) {
        System.exit(new Driver().doMain(args));
    }

    public int doMain(String[] args) {
        ErrorHandlerImpl eh = new ErrorHandlerImpl(System.out);
        OptionParser op = new OptionParser("itcdfe:p:", args);
        PropertyMapBuilder properties = new PropertyMapBuilder();
        ValidateProperty.ERROR_HANDLER.put(properties, eh);
        RngProperty.CHECK_ID_IDREF.add(properties);
        SchemaReader sr = null;
        boolean compact = false;
        try {
            while (op.moveToNextOption()) {
                switch (op.getOptionChar()) {
                    case 'i': {
                        properties.put(RngProperty.CHECK_ID_IDREF, null);
                        break;
                    }
                    case 'c': {
                        compact = true;
                        break;
                    }
                    case 'd': {
                        Option option;
                        if (sr == null) {
                            sr = new AutoSchemaReader();
                        }
                        if ((option = sr.getOption("http://www.thaiopensource.com/validate/diagnose")) == null) {
                            eh.print(this.localizer.message("no_schematron", op.getOptionCharString()));
                            return 2;
                        }
                        properties.put(option.getPropertyId(), Flag.PRESENT);
                        break;
                    }
                    case 't': {
                        this.timing = true;
                        break;
                    }
                    case 'e': {
                        this.encoding = op.getOptionArg();
                        break;
                    }
                    case 'f': {
                        RngProperty.FEASIBLE.add(properties);
                        break;
                    }
                    case 'p': {
                        Option option;
                        if (sr == null) {
                            sr = new AutoSchemaReader();
                        }
                        if ((option = sr.getOption("http://www.thaiopensource.com/validate/phase")) == null) {
                            eh.print(this.localizer.message("no_schematron", op.getOptionCharString()));
                            return 2;
                        }
                        try {
                            properties.put(option.getPropertyId(), option.valueOf(op.getOptionArg()));
                            break;
                        }
                        catch (OptionArgumentException e) {
                            eh.print(this.localizer.message("invalid_phase", op.getOptionArg()));
                            return 2;
                        }
                    }
                }
            }
        }
        catch (OptionParser.InvalidOptionException e) {
            eh.print(this.localizer.message("invalid_option", op.getOptionCharString()));
            return 2;
        }
        catch (OptionParser.MissingArgumentException e) {
            eh.print(this.localizer.message("option_missing_argument", op.getOptionCharString()));
            return 2;
        }
        if (compact) {
            sr = CompactSchemaReader.getInstance();
        }
        if ((args = op.getRemainingArgs()).length < 1) {
            eh.print(this.localizer.message(usageKey, Version.getVersion(Driver.class)));
            return 2;
        }
        long startTime = System.currentTimeMillis();
        long loadedPatternTime = -1L;
        boolean hadError = false;
        try {
            ValidationDriver driver = new ValidationDriver(properties.toPropertyMap(), sr);
            InputSource in = ValidationDriver.uriOrFileInputSource(args[0]);
            if (this.encoding != null) {
                in.setEncoding(this.encoding);
            }
            if (driver.loadSchema(in)) {
                loadedPatternTime = System.currentTimeMillis();
                for (int i = 1; i < args.length; ++i) {
                    if (driver.validate(ValidationDriver.uriOrFileInputSource(args[i]))) continue;
                    hadError = true;
                }
            } else {
                hadError = true;
            }
        }
        catch (SAXException e) {
            hadError = true;
            eh.printException(e);
        }
        catch (IOException e) {
            hadError = true;
            eh.printException(e);
        }
        if (this.timing) {
            long endTime = System.currentTimeMillis();
            if (loadedPatternTime < 0L) {
                loadedPatternTime = endTime;
            }
            eh.print(this.localizer.message("elapsed_time", new Object[]{new Long(loadedPatternTime - startTime), new Long(endTime - loadedPatternTime), new Long(endTime - startTime)}));
        }
        if (hadError) {
            return 1;
        }
        return 0;
    }
}

