// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _AIS_InteractiveObject_HeaderFile
#define _AIS_InteractiveObject_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_AIS_InteractiveObject.hxx>

#include <AIS_PToContext.hxx>
#include <Handle_Standard_Transient.hxx>
#include <TColStd_ListOfTransient.hxx>
#include <Standard_Real.hxx>
#include <Quantity_Color.hxx>
#include <Graphic3d_NameOfMaterial.hxx>
#include <Standard_Integer.hxx>
#include <Standard_Boolean.hxx>
#include <Aspect_TypeOfFacingModel.hxx>
#include <TColStd_ListOfInteger.hxx>
#include <SelectMgr_SelectableObject.hxx>
#include <PrsMgr_TypeOfPresentation3d.hxx>
#include <AIS_KindOfInteractive.hxx>
#include <Quantity_NameOfColor.hxx>
#include <Handle_AIS_InteractiveContext.hxx>
#include <Handle_Prs3d_Presentation.hxx>
#include <Handle_Prs3d_BasicAspect.hxx>
#include <Standard_ShortReal.hxx>
class Standard_Transient;
class AIS_InteractiveContext;
class Quantity_Color;
class TColStd_ListOfTransient;
class Graphic3d_MaterialAspect;
class TColStd_ListOfInteger;
class Prs3d_Presentation;
class Prs3d_BasicAspect;
class Bnd_Box;



//! Defines a class of objects with display and selection services.
//! Entities which are visualized and selected are
//! Interactive Objects. You can make use of classes of
//! standard Interactive Objects for which all necessary
//! methods have already been programmed, or you can
//! implement your own classes of Interactive Objects.
//! Specific attributes of entities such as arrow aspect for
//! dimensions must be loaded in a Drawer. This Drawer
//! is then applied to the Interactive Object in view.
//! There are four types of Interactive Object in AIS: the
//! construction element or Datum, the Relation, which
//! includes both dimensions and constraints, the Object,
//! and finally, when the object is of an unknown type, the None type.
//! Inside these categories, a signature, or index,
//! provides the possibility of additional characterization.
//! By default, the Interactive Object has a None type
//! and a signature of 0. If you want to give a particular
//! type and signature to your interactive object, you must
//! redefine the methods, Signature and Type.
//! Warning
//! In the case of attribute methods, methods for
//! standard attributes are virtual. They must be
//! redefined   by the inheriting classes. Setcolor for a
//! point and Setcolor for a plane, for example, do not
//! affect the same attributes in the Drawer.
class AIS_InteractiveObject : public SelectMgr_SelectableObject
{

public:

  

  //! Returns the kind of Interactive Object:
  //! -   None
  //! -   Datum
  //! -   Relation
  //! -   Object
  //! By default, the   interactive object has a None type.
  //! Because specific shapes entail different behavior
  //! according to their sub-shapes, you may need to
  //! create a Local Context. This will allow you to
  //! specify the additional characteristics which you
  //! need to handle these shapes.
  Standard_EXPORT virtual   AIS_KindOfInteractive Type()  const;
  
  //! Specifies additional characteristics of Interactive
  //! Objects. A signature is, in fact, an index with integer
  //! values assigned different properties.
  //! This method is frequently used in conjuction with
  //! Type to give a particular type and signature to an
  //! Interactive Object. By default, the Interactive Object
  //! has a None type and a signature of 0. Among the
  //! datums, this signature is attributed to the shape
  //! The remaining datums have the following default signatures:
  //! -   Point                   signature 1
  //! -   Axis                     signature 2
  //! -   Trihedron                signature 3
  //! -   PlaneTrihedron            signature 4
  //! -   Line                     signature 5
  //! -   Circle                  signature 6
  //! -   Plane                   signature 7.
  Standard_EXPORT virtual   Standard_Integer Signature()  const;
  
  //! Informs the graphic context that the interactive Object
  //! may be decomposed into sub-shapes for dynamic selection.
  //! The most used Interactive Object is AIS_Shape.
  //! Activation methods for standard selection modes are
  //! proposed in the Interactive Context. These include
  //! selection by vertex or by edges. For datums with the
  //! same behavior as AIS_Shape, such as vetices and
  //! edges, we must redefine the virtual method so that
  //! AcceptShapeDecomposition returns false.
  //! Rule for selection :
  //! Mode 0 :  Selection of  the interactive Object itself
  //! Mode 1 :  Selection of vertices
  //! Mode 2 :  Selection Of Edges
  //! Mode 3 :  Selection Of Wires
  //! Mode 4 :  Selection Of Faces ...
    virtual   Standard_Boolean AcceptShapeDecomposition()  const;
  
  //! change the current facing model apply on polygons for
  //! SetColor(), SetTransparency(), SetMaterial() methods
  //! default facing model is Aspect_TOFM_TWO_SIDE. This mean that attributes is
  //! applying both on the front and back face.
  Standard_EXPORT   void SetCurrentFacingModel (const Aspect_TypeOfFacingModel aModel = Aspect_TOFM_BOTH_SIDE) ;
  
  //! Returns the current facing model which is in effect.
  Standard_EXPORT   Aspect_TypeOfFacingModel CurrentFacingModel()  const;
  
  Standard_EXPORT virtual   void SetColor (const Quantity_Color& aColor) ;
  
  //! only the interactive obj knowns which Drawer attribute
  //! is  affected by the color  (ex:  for a  wire, it's the
  //! wireaspect field of the drawer, but  for a vertex, only
  //! the point aspect field is affected by the color)
  //! WARNING : Do not forget to set the corresponding fields
  //! here (hasOwnColor and myOwnColor)
  Standard_EXPORT virtual   void SetColor (const Quantity_NameOfColor aColor) ;
  
  //! Removes color settings. Only the Interactive Object
  //! knows which Drawer attribute is   affected by the color
  //! setting. For a wire, for example, wire aspect is the
  //! attribute affected. For a vertex, however, only point
  //! aspect is affected by the color setting.
  Standard_EXPORT virtual   void UnsetColor() ;
  
  //! Allows you to provide the setting aValue for width.
  //! Only the Interactive Object knows which Drawer
  //! attribute is affected by the width setting.
  Standard_EXPORT virtual   void SetWidth (const Standard_Real aValue) ;
  
  Standard_EXPORT virtual   void UnsetWidth() ;
  
  //! Returns true if the class of objects accepts the display mode aMode.
  //! The interactive context can have a default mode of
  //! representation for the set of Interactive Objects. This
  //! mode may not be accepted by a given class of
  //! objects. Consequently, this virtual method allowing us
  //! to get information about the class in question must be implemented.
  Standard_EXPORT virtual   Standard_Boolean AcceptDisplayMode (const Standard_Integer aMode)  const;
  
  //! Returns the default display mode. This method is to
  //! be implemented when the main mode is not mode 0.
  Standard_EXPORT virtual   Standard_Integer DefaultDisplayMode()  const;
  
  //! Updates the active presentation; if <AllModes> = Standard_True
  //! all the presentations inside are recomputed.
  //! IMPORTANT: It is preferable to call Redisplay method of
  //! corresponding AIS_InteractiveContext instance for cases when it
  //! is accessible. This method just redirects call to myCTXPtr,
  //! so this class field must be up to date for proper result.
  Standard_EXPORT   void Redisplay (const Standard_Boolean AllModes = Standard_False) ;
  
  //! Sets the infinite state flag aFlage.
  //! if   <aFlag>   = True  ,  the   interactiveObject  is
  //! considered as infinite, i.e. its graphic presentations
  //! are not taken in account for View FitAll...
  Standard_EXPORT   void SetInfiniteState (const Standard_Boolean aFlag = Standard_True) ;
  

  //! Returns true if the interactive object is infinite. In this
  //! case, its graphic presentations are not taken into
  //! account in the fit-all view.
      Standard_Boolean IsInfinite()  const;
  
  //! Indicates whether the Interactive Object has a pointer
  //! to an interactive context.
  Standard_EXPORT   Standard_Boolean HasInteractiveContext()  const;
  
  //! Returns the context pointer to the interactive context.
  Standard_EXPORT   Handle(AIS_InteractiveContext) GetContext()  const;
  
  //! Sets the interactive context aCtx and provides a link
  //! to the default drawing tool or "Drawer" if there is none.
  Standard_EXPORT virtual   void SetContext (const Handle(AIS_InteractiveContext)& aCtx) ;
  
  //! Returns true if the object has an owner attributed to it.
  //! The owner can be a shape for a set of sub-shapes or
  //! a sub-shape for sub-shapes which it is composed of,
  //! and takes the form of a transient.
  Standard_EXPORT   Standard_Boolean HasOwner()  const;
  
  //! Returns the owner of the Interactive Object.
  //! The owner can be a shape for a set of sub-shapes or
  //! a sub-shape for sub-shapes which it is composed of,
  //! and takes the form of a transient.
  //! There are two types of owners:
  //! -   Direct owners, decomposition shapes such as
  //! edges, wires, and faces.
  //! -   Users, presentable objects connecting to sensitive
  //! primitives, or a shape which has been decomposed.
     const  Handle(Standard_Transient)& GetOwner()  const;
  
  //! Allows you to attribute the owner ApplicativeEntity to
  //! an Interactive Object. This can be a shape for a set of
  //! sub-shapes or a sub-shape for sub-shapes which it
  //! is composed of. The owner takes the form of a transient.
      void SetOwner (const Handle(Standard_Transient)& ApplicativeEntity) ;
  
  //! Each Interactive Object has methods which allow us
  //! to attribute an Owner to it in the form of a Transient.
  //! This method removes the owner from the graphic entity.
  Standard_EXPORT   void ClearOwner() ;
  
  Standard_EXPORT   Standard_Boolean HasUsers()  const;
  
     const  TColStd_ListOfTransient& Users()  const;
  
  Standard_EXPORT   void AddUser (const Handle(Standard_Transient)& aUser) ;
  
  Standard_EXPORT   void ClearUsers() ;
  

  //! Returns true if the Interactive Object has a display
  //! mode setting. Otherwise, it is displayed in Neutral Point.
      Standard_Boolean HasDisplayMode()  const;
  
  //! Sets the display mode aMode for the interactive object.
  //! An object can have its own temporary display mode,
  //! which is different from that proposed by the interactive context.
  //! The range of possibilities currently proposed is the following:
  //! -   AIS_WireFrame
  //! -   AIS_Shaded
  //! This range can, however, be extended through the creation of new display modes.
  Standard_EXPORT   void SetDisplayMode (const Standard_Integer aMode) ;
  
  //! Removes display mode settings from the interactive object.
      void UnsetDisplayMode() ;
  
  //! Returns the display mode setting of the Interactive Object.
  //! The range of possibilities is the following:
  //! -   AIS_WireFrame
  //! -   AIS_Shaded
  //! This range can, however, be extended through the
  //! creation of new display modes.
      Standard_Integer DisplayMode()  const;
  
  //! Allows you to change the selection mode of an
  //! Interactive Object.
  //! The default selection mode setting is 0.
  //! For shapes, for example, the selection modes are as follows:
  //! -   mode 0 - selection of the shape itself
  //! -   mode 1 - selection of vertices
  //! -   mode 2 - selection of edges
  //! -   mode 3 - selection of wires
  //! -   mode 4 - selection of faces
  //! -   mode 5 - selection of shells
  //! -   mode 6 - selection of solids
  //! -   mode 7 - selection of compounds
  //! For trihedra, on the other hand, the selection modes are the following four:
  //! -   mode 0 - selection of a trihedron
  //! -   mode 1 - selection of its origin
  //! -   mode 2 - selection of its axes
  //! -   mode 3 - selection of its planes
  Standard_EXPORT   Standard_Boolean HasSelectionMode()  const;
  
  //! Returns the selection mode of the interactive object.
  Standard_EXPORT   Standard_Integer SelectionMode()  const;
  
  //! You can change the default selection mode index
  //! aMode of an Interactive Object.
  //! This is only of interest if you decide that mode 0
  //! adopted by convention will not do.
  Standard_EXPORT   void SetSelectionMode (const Standard_Integer aMode) ;
  
  //! You can change the default selection mode index of
  //! an Interactive Object.
  //! This is only of interest if you decide that the 0 mode
  //! adopted by convention will not do.
      void UnsetSelectionMode() ;
  
  //! Returns the selection priority setting. -1 indicates that there is none.
  //! You can modify the selection priority of an owner to
  //! make one entity more selectionable than another one.
  //! The default selection priority for an owner is 5, for
  //! example. To increase selection priority, choose a
  //! setting between 5 and 10. An entity with priority 7 will
  //! take priority over one with a setting of 6 if both
  //! objects are selected at the same time.
  //! You could give vertices priority 8, edges priority 7,
  //! faces priority 6, and shapes priority 5. If a vertex, an
  //! edge and a face are simultaneously detected during
  //! selection, only the vertex will then be highlighted.
  //! For trihedra, for example, the default priorities are the following four:
  //! -   priority 1 - a trihedron
  //! -   priority 5 - its origin
  //! -   priority 3 - its axes
  //! -   priority 2 - its planes
      Standard_Integer SelectionPriority()  const;
  
  //! Allows you to provide a setting aPriority for selection priority.
  //! You can modify selection priority of an owner to make
  //! one entity more selectionable than another one. The
  //! default selection priority for an owner is 5, for
  //! example. To increase selection priority, choose a
  //! setting between 5 and 10. An entity with priority 7 will
  //! take priority over one with a setting of 6.
      void SetSelectionPriority (const Standard_Integer aPriority) ;
  
  //! Removes the setting for selection priority. SelectionPriority then returns -1.
      void UnsetSelectionPriority() ;
  
  //! Returns true if there is a setting for selection priority.
  //! You can modify selection priority of an owner to make
  //! one entity more selectionable than another one. The
  //! default selection priority for an owner is 5, for
  //! example. To increase selection priority, choose a
  //! setting between 5 and 10. An entity with priority 7 will
  //! take priority over one with a setting of 6.
      Standard_Boolean HasSelectionPriority()  const;
  
  //! Returns true if the Interactive Object is in highlight mode.
      Standard_Boolean HasHilightMode()  const;
  
  //! Returns the setting for highlight mode.
  //! At dynamic detection, the presentation echoed by the
  //! Interactive Context, is by default the presentation
  //! already on the screen. You can specify a Highlight
  //! presentation mode which is valid no matter what the
  //! active representation of the object. It makes no
  //! difference whether this choice is temporary or
  //! definitive.   To do this, we use the following functions:
  //! -   SetHilightMode
  //! -   UnSetHilightMode
  //! In the case of a shape, whether it is visualized in
  //! wireframe presentation or with shading, we want to
  //! systematically highlight the wireframe presentation.
  //! Consequently, we set the highlight mode to 0.
      Standard_Integer HilightMode()  const;
  
  //! Sets the highlight mode anIndex for the interactive object.
  //! If, for example, you want to systematically highlight
  //! the wireframe presentation of a shape - whether
  //! visualized in wireframe presentation or with shading -
  //! you set the highlight mode to 0.
      void SetHilightMode (const Standard_Integer anIndex) ;
  
  //! Allows the user to take a given Prs for hilight
  //! ex : for a shape which would be displayed in shading mode
  //! the hilight Prs is the wireframe mode.
  //! if No specific hilight mode is defined, the displayed Prs
  //! will be the hilighted one.
      void UnsetHilightMode() ;
  
  //! Returns true if the Interactive Object has color.
      Standard_Boolean HasColor()  const;
  
  //! Returns the color setting of the Interactive Object.
    virtual   Quantity_NameOfColor Color()  const;
  
    virtual   void Color (Quantity_Color& aColor)  const;
  
  //! Returns true if the Interactive Object has width.
      Standard_Boolean HasWidth()  const;
  
  //! Returns the width setting of the Interactive Object.
  Standard_EXPORT   Standard_Real Width()  const;
  
  //! Returns true if the Interactive Object has a setting for material.
  Standard_EXPORT   Standard_Boolean HasMaterial()  const;
  
  //! Returns the current material setting.
  //! This will be on of the following materials:
  //! -   Brass
  //! -   Bronze
  //! -   Gold
  //! -   Pewter
  //! -   Silver
  //! -   Stone.
  Standard_EXPORT virtual   Graphic3d_NameOfMaterial Material()  const;
  
  //! Sets the name aName for material defining this
  //! display attribute for the interactive object.
  //! Material aspect determines shading aspect, color and
  //! transparency of visible entities.
  Standard_EXPORT virtual   void SetMaterial (const Graphic3d_NameOfMaterial aName) ;
  
  //! Sets the material aMat defining this display attribute
  //! for the interactive object.
  //! Material aspect determines shading aspect, color and
  //! transparency of visible entities.
  Standard_EXPORT virtual   void SetMaterial (const Graphic3d_MaterialAspect& aName) ;
  
  //! Removes the setting for material.
  Standard_EXPORT virtual   void UnsetMaterial() ;
  
  //! Attributes a setting aValue for transparency.
  //! The transparency value should be between 0.0 and 1.0.
  //! At 0.0 an object will be totally opaque, and at 1.0, fully transparent.
  //! Warning At a value of 1.0, there may be nothing visible.
  Standard_EXPORT virtual   void SetTransparency (const Standard_Real aValue = 0.6) ;
  
  //! Returns true if there is a transparency setting.
      Standard_Boolean IsTransparent()  const;
  
  //! Returns the transparency setting.
  //! This will be between 0.0 and 1.0.
  //! At 0.0 an object will be totally opaque, and at 1.0, fully transparent.
  Standard_EXPORT virtual   Standard_Real Transparency()  const;
  
  //! Removes the transparency setting. The object is opaque by default.
  Standard_EXPORT virtual   void UnsetTransparency() ;
  
  //! Clears settings provided by the drawing tool aDrawer.
  Standard_EXPORT virtual   void UnsetAttributes() ;
  
      void State (const Standard_Integer theState) ;
  
      Standard_Integer State()  const;
  
  //! Returns TRUE when this object has a presentation
  //! in the current DisplayMode()
  Standard_EXPORT   Standard_Boolean HasPresentation()  const;
  
  //! Returns the current presentation of this object
  //! according to the current DisplayMode()
  Standard_EXPORT   Handle(Prs3d_Presentation) Presentation()  const;
  
  //! Sets the graphic basic aspect to the current presentation.
  //! When <globalChange> is TRUE , the full object presentation
  //! is changed.
  //! When <globalChange> is FALSE , only the current group
  //! of the object presentation is changed.
  Standard_EXPORT   void SetAspect (const Handle(Prs3d_BasicAspect)& anAspect, const Standard_Boolean globalChange = Standard_True) ;
  
  //! Sets up polygon offsets for this object.
  //! It modifies all existing presentations of <anObj> (if any),
  //! so it is reasonable to call this method after <anObj> has been displayed.
  //! Otherwise, Compute() method should pass Graphic3d_AspectFillArea3d
  //! aspect from <myDrawer> to Graphic3d_Group to make polygon offsets work.
  //!
  //! <aMode> parameter can contain various combinations of
  //! Aspect_PolygonOffsetMode enumeration elements (Aspect_POM_None means
  //! that polygon offsets are not changed).
  //! If <aMode> is different from Aspect_POM_Off and Aspect_POM_None, then <aFactor> and <aUnits>
  //! arguments are used by graphic renderer to calculate a depth offset value:
  //!
  //! offset = <aFactor> * m + <aUnits> * r, where
  //! m - maximum depth slope for the polygon currently being displayed,
  //! r - minimum window coordinates depth resolution (implementation-specific).
  //!
  //! Deafult settings for OCC 3D viewer: mode = Aspect_POM_Fill, factor = 1., units = 0.
  //!
  //! Negative offset values move polygons closer to the viewport,
  //! while positive values shift polygons away.
  //! Consult OpenGL reference for details (glPolygonOffset function description).
  //!
  //! NOTE: This method has a side effect - it creates own shading aspect
  //! if not yet created, so it is better to set up object material,
  //! color, etc. first.
  Standard_EXPORT virtual   void SetPolygonOffsets (const Standard_Integer aMode, const Standard_ShortReal aFactor = 1.0, const Standard_ShortReal aUnits = 0.0) ;
  
  //! Returns Standard_True if <myDrawer> has non-null shading aspect
  Standard_EXPORT virtual   Standard_Boolean HasPolygonOffsets()  const;
  
  //! Retrieves current polygon offsets settings from <myDrawer>.
  Standard_EXPORT virtual   void PolygonOffsets (Standard_Integer& aMode, Standard_ShortReal& aFactor, Standard_ShortReal& aUnits)  const;
  
  //! Returns bounding box of object correspondingly to its current display mode.
  Standard_EXPORT virtual   void BoundingBox (Bnd_Box& theBndBox) ;


friend class AIS_InteractiveContext;


  DEFINE_STANDARD_RTTI(AIS_InteractiveObject)

protected:

  
  //! The TypeOfPresention3d means that the interactive object
  //! may have a presentation dependant of the view of Display
  Standard_EXPORT AIS_InteractiveObject(const PrsMgr_TypeOfPresentation3d aTypeOfPresentation3d = PrsMgr_TOP_AllView);

  Standard_Real myTransparency;
  Quantity_Color myOwnColor;
  Graphic3d_NameOfMaterial myOwnMaterial;
  Standard_Integer myHilightMode;
  Standard_Real myOwnWidth;
  Standard_Boolean myInfiniteState;
  Standard_Boolean hasOwnColor;
  Standard_Boolean hasOwnMaterial;
  Aspect_TypeOfFacingModel myCurrentFacingModel;
  Standard_Boolean myRecomputeEveryPrs;
  TColStd_ListOfInteger myToRecomputeModes;


private: 

  
  Standard_EXPORT virtual   Standard_Boolean RecomputeEveryPrs()  const;
  
  Standard_EXPORT   void MustRecomputePrs (const Standard_Integer aMode)  const;
  
  Standard_EXPORT  const  TColStd_ListOfInteger& ListOfRecomputeModes()  const;
  
  Standard_EXPORT   void SetRecomputeOk() ;

  AIS_PToContext myCTXPtr;
  Handle(Standard_Transient) myOwner;
  TColStd_ListOfTransient myUsers;
  Standard_Integer mySelPriority;
  Standard_Integer myDisplayMode;
  Standard_Integer mySelectionMode;
  Standard_Integer mystate;


};


#include <AIS_InteractiveObject.lxx>





#endif // _AIS_InteractiveObject_HeaderFile
