//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#include "libgpspoint_config.h"

#ifdef HAVE_WINDOWS_H 

#include "datatypes.h"
#include <stdio.h>
#include <errno.h>
#include <sys/stat.h>
#include <string>
#include <iostream.h>
#include <stdlib.h>
#include <fcntl.h>
#include <windows.h>
#include <IO.h>

#define V_TIME 07

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;


/// serial port class for windows32 systems
class Serial 
{
   public:
      Serial(void);
      ~Serial();


   protected:
      /// write one Byte to the device 
      int writeByte(g_byte );
      /// read one byte from the device
      int readByte(g_byte &);

      /// set device e.g. /dev/ttyS1
      void setDevice(string );

      /// set bauds
      void setSpeed(string );

      /// open the device 
      int openPort();
      
      /// close the device
      void closePort();


   private:
	
     HANDLE serial;
     string device;

};


}
#endif
