/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.EvaluationContext;
import org.gradle.api.internal.provider.OrElseValueProducer;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueSupplier;

class OrElseProvider<T>
extends AbstractMinimalProvider<T> {
    private final ProviderInternal<T> left;
    private final ProviderInternal<? extends T> right;

    public OrElseProvider(ProviderInternal<T> left, ProviderInternal<? extends T> right) {
        this.left = left;
        this.right = right;
    }

    @Override
    protected String toStringNoReentrance() {
        return String.format("or(%s, %s)", this.left, this.right);
    }

    @Override
    @Nullable
    public Class<T> getType() {
        return this.left.getType();
    }

    @Override
    public ValueSupplier.ValueProducer getProducer() {
        try (EvaluationContext.ScopeContext context = this.openScope();){
            OrElseValueProducer orElseValueProducer = new OrElseValueProducer(context, this.left, this.right);
            return orElseValueProducer;
        }
    }

    @Override
    public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
        try (EvaluationContext.ScopeContext ignored = this.openScope();){
            boolean bl = this.left.calculatePresence(consumer) || this.right.calculatePresence(consumer);
            return bl;
        }
    }

    @Override
    public ValueSupplier.ExecutionTimeValue<? extends T> calculateExecutionTimeValue() {
        try (EvaluationContext.ScopeContext ignored = this.openScope();){
            ValueSupplier.ExecutionTimeValue<T> leftValue = this.left.calculateExecutionTimeValue();
            if (leftValue.hasFixedValue()) {
                ValueSupplier.ExecutionTimeValue<T> executionTimeValue = leftValue;
                return executionTimeValue;
            }
            ValueSupplier.ExecutionTimeValue<T> rightValue = this.right.calculateExecutionTimeValue();
            if (leftValue.isMissing()) {
                ValueSupplier.ExecutionTimeValue<T> executionTimeValue = rightValue;
                return executionTimeValue;
            }
            if (rightValue.isMissing()) {
                ValueSupplier.ExecutionTimeValue<T> executionTimeValue = leftValue;
                return executionTimeValue;
            }
            ValueSupplier.ExecutionTimeValue<? extends T> executionTimeValue = ValueSupplier.ExecutionTimeValue.changingValue(new OrElseProvider<T>(leftValue.getChangingValue(), rightValue.toProvider()));
            return executionTimeValue;
        }
    }

    @Override
    protected ValueSupplier.Value<? extends T> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
        try (EvaluationContext.ScopeContext ignored = this.openScope();){
            ValueSupplier.Value<T> leftValue = this.left.calculateValue(consumer);
            if (!leftValue.isMissing()) {
                ValueSupplier.Value<T> value = leftValue;
                return value;
            }
            ValueSupplier.Value<T> rightValue = this.right.calculateValue(consumer);
            if (!rightValue.isMissing()) {
                ValueSupplier.Value<T> value = rightValue;
                return value;
            }
            ValueSupplier.Value<T> value = leftValue.addPathsFrom(rightValue);
            return value;
        }
    }
}

