/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.tribble.TribbleException;
import htsjdk.variant.vcf.VCFLineParser;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class VCF4Parser
implements VCFLineParser {
    VCF4Parser() {
    }

    @Override
    public Map<String, String> parseLine(String valueLine, List<String> expectedTagOrder, List<String> recommendedTags) {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        StringBuilder builder = new StringBuilder();
        String key = "";
        int index = 0;
        boolean inQuote = false;
        boolean escape = false;
        for (char c : valueLine.toCharArray()) {
            if (c == '\"') {
                if (escape) {
                    builder.append(c);
                    escape = false;
                } else {
                    inQuote = !inQuote;
                }
            } else if (inQuote) {
                if (escape) {
                    if (c == '\\') {
                        builder.append(c);
                    } else {
                        builder.append('\\');
                        builder.append(c);
                    }
                    escape = false;
                } else if (c != '\\') {
                    builder.append(c);
                } else {
                    escape = true;
                }
            } else {
                escape = false;
                switch (c) {
                    case '<': {
                        if (index == 0) break;
                    }
                    case '>': {
                        if (index != valueLine.length() - 1) break;
                        ret.put(key, builder.toString().trim());
                        break;
                    }
                    case '=': {
                        key = builder.toString().trim();
                        builder = new StringBuilder();
                        break;
                    }
                    case ',': {
                        ret.put(key, builder.toString().trim());
                        builder = new StringBuilder();
                        break;
                    }
                    default: {
                        builder.append(c);
                    }
                }
            }
            ++index;
        }
        if (inQuote) {
            throw new TribbleException.InvalidHeader("Unclosed quote in header line value " + valueLine);
        }
        index = 0;
        if (expectedTagOrder != null) {
            if (ret.keySet().isEmpty() && !expectedTagOrder.isEmpty()) {
                throw new TribbleException.InvalidHeader("Header with no tags is not supported when there are expected tags in line " + valueLine);
            }
            Object object = ret.keySet().iterator();
            while (object.hasNext()) {
                String str = (String)object.next();
                if (index < expectedTagOrder.size() && !expectedTagOrder.get(index).equals(str)) {
                    if (expectedTagOrder.contains(str)) {
                        throw new TribbleException.InvalidHeader("Tag " + str + " in wrong order (was #" + (index + 1) + ", expected #" + (expectedTagOrder.indexOf(str) + 1) + ") in line " + valueLine);
                    }
                    if (recommendedTags.contains(str)) {
                        throw new TribbleException.InvalidHeader("Recommended tag " + str + " must be listed after all expected tags in line " + valueLine);
                    }
                    throw new TribbleException.InvalidHeader("Unexpected tag " + str + " in line " + valueLine);
                }
                ++index;
            }
        }
        return ret;
    }
}

