/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.natutil;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import uk.ac.ic.doc.natutil.CommandLineException;
import uk.ac.ic.doc.natutil.Instantiate;

public class CommandLineParser {
    private static String fieldNameToOption(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '_') {
                stringBuffer.append('-');
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String optionToFieldName(String string) throws CommandLineException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\u0000' && Character.isJavaIdentifierStart(c) || c > '\u0000' && Character.isJavaIdentifierPart(c)) {
                stringBuffer.append(c);
            } else if (c == '-') {
                stringBuffer.append('_');
            } else {
                throw new CommandLineException("invalid option name \"" + string + "\"");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void parseOptions(Object object, String[] stringArray) throws CommandLineException {
        int n = 0;
        try {
            Class<?> clazz = object.getClass();
            n = 0;
            while (n < stringArray.length) {
                String string = CommandLineParser.optionToFieldName(stringArray[n].substring(1));
                Field field = clazz.getField(string);
                Object object2 = Instantiate.newObject(field.getType(), stringArray[n + 1]);
                field.set(object, object2);
                n += 2;
            }
        }
        catch (Exception exception) {
            throw new CommandLineException("failed to parse " + stringArray[n] + " option: " + exception.getMessage());
        }
    }

    public static void printOptions(OutputStream outputStream, Object object) {
        CommandLineParser.printOptions(new PrintWriter(outputStream), object);
    }

    public static void printOptions(PrintWriter printWriter, Object object) {
        try {
            Field[] fieldArray = object.getClass().getFields();
            int n = 0;
            while (n < fieldArray.length) {
                Field field = fieldArray[n];
                printWriter.print(CommandLineParser.fieldNameToOption(field.getName()));
                printWriter.print(" : ");
                printWriter.print(field.getType().getName());
                printWriter.print(" [");
                printWriter.print(field.get(object).toString());
                printWriter.println("]");
                ++n;
            }
            printWriter.flush();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error("cannot access fields of options structure");
        }
    }

    public static void printOptions(Object object) {
        CommandLineParser.printOptions(System.err, object);
    }
}

