'\"
'\" Copyright (c) 1994-1996 Technical University of Braunschweig.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  If an argument is present, then a line break is
'\"	forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" SCCS: @(#) man.macros 1.8 96/02/15 20:02:24
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$1"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH icmp n "" Tnm "Tnm Tcl Extension"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
icmp \- Send ICMP messages to hosts on the Internet.
.BE

.SH DESCRIPTION
The \fBicmp\fR command allows to send Internet Control Messages (ICMP)
(RFC 792, RFC 1122) to a list of hosts on the Internet. ICMP messages
can be used to check whether hosts are reachable. The \fBicmp
command\fR can also be used to trace routes to Internet hosts by
sending UDP datagrams to unused UDP ports and interpreting the ICMP
responses (Van Jacobsen and Steve Deering algorithm).

.SH ICMP COMMAND
The \fBicmp\fR command always accepts a list of target hosts. ICMP
messages are send to the targets in a round-robin fashion which allows
to check entire IP address ranges or a list of core routers
efficiently. The user of the \fBicmp\fR command should be careful not
to flood a network with ICMP requests.
.TP
\fBicmp\fR [\fIoptions\fR]
Invoking the \fBicmp\fR command with options but without any command
arguments allows to retrieve and change the default values. See the
description of supported options below. Default values are bound
to a Tcl interpreter which allows to have multiple Tcl interpreter
with different defaults.
.TP
\fBicmp\fR [\fIoptions\fR] \fBecho\fR \fIhosts\fR
The \fBicmp echo\fR command can be used to test the reachability of IP
devices by sending ICMP echo requests to the \fIhosts\fR.  The command
returns a list of host / round trip time pairs. The round trip time is
returned in milliseconds. A negative round trip time indicates that a
host did not respond in the timeout interval.
.TP
\fBicmp\fR [\fIoptions\fR] \fBmask\fR \fIhosts\fR
The \fBicmp mask\fR command sends ICMP mask requests and returns a
list of host / netmask pairs. The mask will be set to 0.0.0.0 if a
host does not respond to ICMP mask requests.
.TP
\fBicmp\fR [\fIoptions\fR] \fBtimestamp\fR \fIhosts\fR
The \fBicmp timestamp\fR command retrieves timestamps using the ICMP
timestamp request. This command returns an estimate of the time
difference between local time and the time on the hosts given in
\fIhosts\fR. The command returns a list of host / time offset
pairs. The time offset is returned in milliseconds. An empty time
offset indicates that a host did not respond in the timeout interval.
.TP
\fBicmp\fR [\fIoptions\fR] \fBttl\fR \fInum\fR \fIhosts\fR
The \fBicmp ttl\fR command, which may not be supported on every
operating system, sends a UDP packet to an unused port number with the
time to live field of the IP header set to \fInum\fR. This command
returns a list of host / round trip time pairs, where the host is the
IP device being \fInum\fR hops away. The round trip time is returned
in milliseconds. A negative round trip time indicates that a host did
not respond in the timeout interval.
.TP
\fBicmp\fR [\fIoptions\fR] \fBtrace\fR \fInum\fR \fIhosts\fR
The \fBicmp trace\fR command works similar to the \fBicmp ttl\fR
command but it always returns the destination address even when the
responding host chooses another interface with a different IP address
to send the reply. This can be used to trace a route to a host since
the command returns the host that discards the packet if it does not
reach the destination.

.SH ICMP OPTIONS
The following options control how ICMP requests are send and how the icmp
command deals with lost ICMP packets.
.TP
.BI "-timeout " time
The \fB-timeout\fR option defines the time the \fBicmp command\fR will
wait for a response. The \fItime\fR is defined in seconds with a
default of 5 seconds.
.TP
.BI "-retries " number
The \fB-retries\fR option defines how many times a request is
retransmitted during the timeout interval. The default \fInumber\fR of
retries is 2.
.TP
.BI "-delay " time
The \fB-delay\fR option defines the minimum delay between two outgoing
ICMP packets. The delay \fItime\fR is defined in milliseconds with a
default delay of 0 milliseconds. Delays are useful to reduce the load
on intermediate devices like gateways or bridges.
.TP
.BI "-size " number
The \fB-size\fR option allows to control the size of ICMP packets. The
\fInumber\fR defines the size of ICMP packets in bytes with a default
size of 64 bytes. Sizes smaller than 64 bytes are silently rounded to
64 bytes.

.SH BUGS
The \fBicmp\fR command requires the setuid root program ntping(8)
because sending icmp packets requires access to raw sockets on
most operating systems.

.SH SEE ALSO
scotty(1), ntping(8), Tnm(n), Tcl(n)

.SH AUTHORS
Juergen Schoenwaelder <schoenw@cs.utwente.nl>
.br
