/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ops;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.opf.ContentChecker;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.ops.OPSHandler;
import com.adobe.epubcheck.xml.XMLParser;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class OPSPreflight
implements ContentChecker {
    ZipFile zip;
    Report report;
    String path;
    String mimeType;
    XRefChecker xrefChecker;

    public OPSPreflight(ZipFile zip, Report report, String path, String mimeType, XRefChecker xrefChecker) {
        this.zip = zip;
        this.report = report;
        this.path = path;
        this.xrefChecker = xrefChecker;
        this.mimeType = mimeType;
    }

    public void runChecks() {
        ZipEntry opfEntry = this.zip.getEntry(this.path);
        if (opfEntry == null) {
            this.report.error(null, 0, "OPS/XHTML file " + this.path + " is missing");
        } else {
            long entryLength = opfEntry.getSize();
            if (entryLength > 307200L) {
                this.report.error(this.path, 0, "file is over 300k in size.");
            }
            if (entryLength == 0L) {
                this.report.error(this.path, 0, "file has no content.");
            }
            XMLParser opsParser = new XMLParser(this.zip, this.path, this.report);
            OPSHandler opsHandler = new OPSHandler(opsParser, this.path, this.xrefChecker);
            opsParser.addXMLHandler(opsHandler);
            opsParser.process();
        }
    }
}

