/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.plaf.icons;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.flexdock.plaf.Configurator;
import org.flexdock.plaf.PropertySet;
import org.flexdock.plaf.XMLConstants;
import org.flexdock.plaf.icons.IconMap;
import org.flexdock.plaf.icons.IconResource;

public class IconResourceFactory
implements XMLConstants {
    public static final String ICON_RESOURCE_KEY = "icon-resource";
    public static final String ICON_MAP_KEY = "icon-map";
    public static final String ACTION_KEY = "action";
    public static final String DEFAULT = "default";
    public static final String DISABLED = "disabled";
    public static final String HOVER = "hover";
    public static final String ACTIVE = "active";
    public static final String ACTIVE_HOVER = "active.hover";
    public static final String ACTIVE_DISABLED = "active.disabled";
    public static final String PRESSED = "pressed";
    public static final String DEFAULT_SELECTED = "default.selected";
    public static final String HOVER_SELECTED = "hover.selected";
    public static final String DISABLED_SELECTED = "disabled.selected";
    public static final String ACTIVE_SELECTED = "active.selected";
    public static final String ACTIVE_SELECTED_HOVER = "active.armed.selected";
    public static final String ACTIVE_DISABLED_SELECTED = "active.disabled.selected";
    public static final String PRESSED_SELECTED = "pressed.selected";
    public static final String TOOLTIP = "tooltip";
    public static final String TOOLTIP_SELECTED = "tooltip.selected";
    private static final HashMap RESOURCE_CACHE = new HashMap();
    private static final HashMap RESOURCE_MAP_CACHE = new HashMap();
    private static final HashSet BAD_RESOURCE_NAMES = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IconMap getIconMap(String name) {
        if (Configurator.isNull(name) || BAD_RESOURCE_NAMES.contains(name)) {
            return null;
        }
        IconMap map = (IconMap)RESOURCE_MAP_CACHE.get(name);
        if (map == null) {
            map = IconResourceFactory.loadIconMap(name);
            if (map == null) {
                HashSet hashSet = BAD_RESOURCE_NAMES;
                synchronized (hashSet) {
                    BAD_RESOURCE_NAMES.add(name);
                }
            }
            HashMap hashMap = RESOURCE_MAP_CACHE;
            synchronized (hashMap) {
                RESOURCE_MAP_CACHE.put(name, map);
            }
        }
        return map;
    }

    public static IconResource getResource(String name) {
        if (Configurator.isNull(name)) {
            return null;
        }
        IconResource icons = IconResourceFactory.getCachedResource(name);
        if (icons == null) {
            icons = IconResourceFactory.loadIcons(name);
            IconResourceFactory.cacheResource(name, icons);
        }
        return icons;
    }

    private static IconResource getCachedResource(String name) {
        return (IconResource)RESOURCE_CACHE.get(name);
    }

    private static void cacheResources(IconMap map) {
        if (map != null) {
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                IconResource resource = map.getIcons(key);
                IconResourceFactory.cacheResource(key, resource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheResource(String name, IconResource icons) {
        if (icons != null) {
            HashMap hashMap = RESOURCE_CACHE;
            synchronized (hashMap) {
                RESOURCE_CACHE.put(name, icons);
            }
        }
    }

    private static IconResource loadIcons(String name) {
        PropertySet properties = Configurator.getProperties(name, ICON_RESOURCE_KEY);
        return IconResourceFactory.createResource(properties);
    }

    private static IconResource createResource(PropertySet properties) {
        IconResource icons = new IconResource();
        icons.setIcon(properties.getIcon(DEFAULT));
        icons.setIconHover(properties.getIcon(HOVER));
        icons.setIconDisabled(properties.getIcon(DISABLED));
        icons.setIconActive(properties.getIcon(ACTIVE));
        icons.setIconActiveHover(properties.getIcon(ACTIVE_HOVER));
        icons.setIconActiveDisabled(properties.getIcon(ACTIVE_DISABLED));
        icons.setIconPressed(properties.getIcon(PRESSED));
        icons.setIconSelected(properties.getIcon(DEFAULT_SELECTED));
        icons.setIconSelectedDisabled(properties.getIcon(DISABLED_SELECTED));
        icons.setIconSelectedHover(properties.getIcon(HOVER_SELECTED));
        icons.setIconSelectedActive(properties.getIcon(ACTIVE_SELECTED));
        icons.setIconSelectedActiveHover(properties.getIcon(ACTIVE_SELECTED_HOVER));
        icons.setIconSelectedActiveDisabled(properties.getIcon(ACTIVE_DISABLED_SELECTED));
        icons.setIconSelectedPressed(properties.getIcon(PRESSED_SELECTED));
        icons.setAction(properties.getAction(ACTION_KEY));
        icons.setTooltip(properties.getString(TOOLTIP));
        icons.setTooltipSelected(properties.getString(TOOLTIP_SELECTED));
        return icons;
    }

    private static IconMap loadIconMap(String iconMapName) {
        PropertySet iconMapProperties = Configurator.getProperties(iconMapName, ICON_MAP_KEY);
        IconMap iconMap = new IconMap();
        ArrayList<String> notCached = new ArrayList<String>();
        Iterator it = iconMapProperties.keys();
        while (it.hasNext()) {
            String fakeName = (String)it.next();
            String realName = iconMapProperties.getString(fakeName);
            IconResource iconResource = IconResourceFactory.getCachedResource(realName);
            if (iconResource == null) {
                notCached.add(fakeName);
                continue;
            }
            iconMap.addIcons(fakeName, iconResource);
        }
        if (notCached.size() == 0) {
            return iconMap;
        }
        String[] fakeNames = notCached.toArray(new String[0]);
        String[] realNames = iconMapProperties.getStrings(fakeNames);
        HashMap resourceMap = IconResourceFactory.loadIconResources(realNames);
        for (int i = 0; i < fakeNames.length; ++i) {
            String realName = iconMapProperties.getString(fakeNames[i]);
            IconResource iconResource = (IconResource)resourceMap.get(realName);
            IconResourceFactory.cacheResource(realName, iconResource);
            iconMap.addIcons(fakeNames[i], iconResource);
        }
        return iconMap;
    }

    private static HashMap loadIconResources(String[] iconNames) {
        PropertySet[] iconResources = Configurator.getProperties(iconNames, ICON_RESOURCE_KEY);
        HashMap<String, IconResource> map = new HashMap<String, IconResource>(iconResources.length);
        for (int i = 0; i < iconResources.length; ++i) {
            IconResource resource = IconResourceFactory.createResource(iconResources[i]);
            map.put(iconResources[i].getName(), resource);
        }
        return map;
    }
}

