/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GregorianCalendar
extends Calendar {
    public static final int BC = 0;
    public static final int AD = 1;
    static final long serialVersionUID = -8125100834729963327L;
    private static final int EPOCH_DAYS = 719162;
    private static final int[] minimums;
    private static final int[] maximums;
    private long gregorianCutover;

    public void setGregorianChange(Date date) {
        this.gregorianCutover = date.getTime();
    }

    public final Date getGregorianChange() {
        return new Date(this.gregorianCutover);
    }

    public boolean isLeapYear(int n) {
        if ((n & 3) != 0) {
            return false;
        }
        if (!this.isGregorian(n, 59)) {
            return true;
        }
        boolean bl = false;
        if (n % 100 != 0 || n % 400 == 0) {
            bl = true;
        }
        return bl;
    }

    private final int getWeekDay(int n, int n2) {
        boolean bl = this.isGregorian(n, n2);
        int n3 = (int)this.getLinearDay(n, n2, bl);
        int n4 = (n3 + 5) % 7;
        if (n4 <= 0) {
            n4 += 7;
        }
        return n4;
    }

    private final int getFirstDayOfMonth(int n, int n2) {
        boolean bl;
        int n3;
        int n4;
        int[] nArray = new int[12];
        nArray[1] = 31;
        nArray[2] = 59;
        nArray[3] = 90;
        nArray[4] = 120;
        nArray[5] = 151;
        nArray[6] = 181;
        nArray[7] = 212;
        nArray[8] = 243;
        nArray[9] = 273;
        nArray[10] = 304;
        nArray[11] = 334;
        int[] nArray2 = nArray;
        if (n2 > 11) {
            n += n2 / 12;
            n2 %= 12;
        }
        if (n2 < 0) {
            n += n2 / 12;
            if ((n2 %= 12) < 0) {
                n2 += 12;
                --n;
            }
        }
        int n5 = nArray2[n2] + 1;
        if (n2 > 1 && this.isLeapYear(n)) {
            ++n5;
        }
        if ((n4 = ((n3 = (int)this.getLinearDay(n, n5, bl = this.isGregorian(n, n5))) + 5) % 7) <= 0) {
            n4 += 7;
        }
        return n4;
    }

    private final boolean isGregorian(int n, int n2) {
        int n3 = (n - 1) * 365 + (n - 1 >> 2) + n2 - 719162;
        int n4 = (int)Math.floor((double)(n - 1) / 400.0) - (int)Math.floor((double)(n - 1) / 100.0);
        boolean bl = false;
        if ((long)(n3 + n4) * 60L * 60L * 24L * 1000L >= this.gregorianCutover) {
            bl = true;
        }
        return bl;
    }

    private final void nonLeniencyCheck() throws IllegalArgumentException {
        int n;
        int n2;
        int n3;
        block26: {
            block27: {
                int[] nArray = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
                int n4 = this.fields[1];
                n3 = this.fields[2];
                n2 = this.isLeapYear(n4);
                if (this.isSet[0] && this.fields[0] != 1 && this.fields[0] != 0) {
                    throw new IllegalArgumentException("Illegal ERA.");
                }
                if (this.isSet[1] && this.fields[1] < 1) {
                    throw new IllegalArgumentException("Illegal YEAR.");
                }
                if (this.isSet[2] && (n3 < 0 || n3 > 11)) {
                    throw new IllegalArgumentException("Illegal MONTH.");
                }
                if (this.isSet[3]) {
                    n = 365 + n2;
                    n += this.getFirstDayOfMonth(n4, 0) - 1;
                    int n5 = this.getFirstDayOfMonth(n4, 11) + 4;
                    if (n5 > 7) {
                        n5 -= 7;
                    }
                    int n6 = (n += 7 - n5) / 7;
                    if (this.fields[3] < 1 || this.fields[3] > n6) {
                        throw new IllegalArgumentException("Illegal WEEK_OF_YEAR.");
                    }
                }
                if (this.isSet[4]) {
                    int n5 = 0;
                    if (n3 == 1 && n2 == 0) {
                        n5 = 1;
                    }
                    n = 5 - n5;
                    if (this.fields[4] < 1 || this.fields[4] > n) {
                        throw new IllegalArgumentException("Illegal WEEK_OF_MONTH.");
                    }
                }
                if (!this.isSet[5]) break block26;
                if (this.fields[5] < 1) break block27;
                int n6 = this.fields[5];
                int n7 = nArray[n3];
                int n8 = 0;
                if (n3 == 1) {
                    n8 = n2;
                }
                if (n6 <= n7 + n8) break block26;
            }
            throw new IllegalArgumentException("Illegal DAY_OF_MONTH.");
        }
        if (this.isSet[6] && (this.fields[6] < 1 || this.fields[6] > 365 + n2)) {
            throw new IllegalArgumentException("Illegal DAY_OF_YEAR.");
        }
        if (this.isSet[7] && (this.fields[7] < 1 || this.fields[7] > 7)) {
            throw new IllegalArgumentException("Illegal DAY_OF_WEEK.");
        }
        if (this.isSet[8]) {
            int n9 = 0;
            if (n3 == 1 && n2 == 0) {
                n9 = 1;
            }
            if (this.fields[8] < -(n = 5 - n9) || this.fields[8] > n) {
                throw new IllegalArgumentException("Illegal DAY_OF_WEEK_IN_MONTH.");
            }
        }
        if (this.isSet[9] && this.fields[9] != 0 && this.fields[9] != 1) {
            throw new IllegalArgumentException("Illegal AM_PM.");
        }
        if (this.isSet[10] && (this.fields[10] < 0 || this.fields[10] > 11)) {
            throw new IllegalArgumentException("Illegal HOUR.");
        }
        if (this.isSet[11] && (this.fields[11] < 0 || this.fields[11] > 23)) {
            throw new IllegalArgumentException("Illegal HOUR_OF_DAY.");
        }
        if (this.isSet[12] && (this.fields[12] < 0 || this.fields[12] > 59)) {
            throw new IllegalArgumentException("Illegal MINUTE.");
        }
        if (this.isSet[13] && (this.fields[13] < 0 || this.fields[13] > 59)) {
            throw new IllegalArgumentException("Illegal SECOND.");
        }
        if (this.isSet[14] && (this.fields[14] < 0 || this.fields[14] > 999)) {
            throw new IllegalArgumentException("Illegal MILLISECOND.");
        }
        if (this.isSet[15] && ((long)this.fields[15] < -43200000L || (long)this.fields[15] > 43200000L)) {
            throw new IllegalArgumentException("Illegal ZONE_OFFSET.");
        }
        if (this.isSet[16] && ((long)this.fields[16] < -43200000L || (long)this.fields[16] > 43200000L)) {
            throw new IllegalArgumentException("Illegal DST_OFFSET.");
        }
    }

    protected synchronized void computeTime() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = 0;
        int n9 = this.fields[0];
        int n10 = this.fields[1];
        int n11 = this.fields[2];
        int n12 = this.fields[5];
        int n13 = this.fields[12];
        int n14 = this.fields[13];
        int n15 = this.fields[14];
        int[] nArray = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        int[] nArray2 = new int[12];
        nArray2[1] = 31;
        nArray2[2] = 59;
        nArray2[3] = 90;
        nArray2[4] = 120;
        nArray2[5] = 151;
        nArray2[6] = 181;
        nArray2[7] = 212;
        nArray2[8] = 243;
        nArray2[9] = 273;
        nArray2[10] = 304;
        nArray2[11] = 334;
        int[] nArray3 = nArray2;
        int n16 = 0;
        if (!this.isLenient()) {
            this.nonLeniencyCheck();
        }
        if (!(this.isSet[2] || this.isSet[7] && !this.isSet[3])) {
            if (this.isSet[3]) {
                n7 = this.getFirstDayOfMonth(n10, 0);
                n6 = 1;
                n5 = this.getFirstDayOfWeek() - n7;
                if (n5 <= 0) {
                    n5 += 7;
                }
                n6 = n5 < this.getMinimalDaysInFirstWeek() ? (n6 += n5) : (n6 -= 7 - n5);
                n11 = 0;
                n12 = n6 + 7 * (this.fields[3] - 1);
                n6 = this.fields[7] - this.getFirstDayOfWeek();
                if (n6 < 0) {
                    n6 += 7;
                }
                n12 += n6;
            } else {
                n11 = 0;
                n12 = this.fields[6];
            }
        } else if (this.isSet[7]) {
            n7 = this.getFirstDayOfMonth(n10, n11);
            if (this.isSet[8]) {
                if (this.fields[8] < 0) {
                    n7 = this.getFirstDayOfMonth(n10, ++n11);
                    n12 = 1 + 7 * this.fields[8];
                } else {
                    n12 = 1 + 7 * (this.fields[8] - 1);
                }
                n6 = this.fields[7] - n7;
                if (n6 < 0) {
                    n6 += 7;
                }
                n12 += n6;
            } else {
                n6 = 1;
                n5 = this.getFirstDayOfWeek() - n7;
                if (n5 <= 0) {
                    n5 += 7;
                }
                n6 = n5 < this.getMinimalDaysInFirstWeek() ? (n6 += n5) : (n6 -= 7 - n5);
                n12 = n6 + 7 * (this.fields[4] - 1);
                n6 = this.fields[7] - this.getFirstDayOfWeek();
                if (n6 <= 0) {
                    n6 += 7;
                }
                n12 += n6;
            }
        }
        if (n9 == 0 && n10 > 0) {
            n10 = 1 - n10;
        }
        if (this.isSet[10]) {
            n16 = this.fields[10];
            if (this.fields[9] == 1) {
                n16 += 12;
            }
        } else {
            n16 = this.fields[11];
        }
        long l = (((long)n16 * 60L + (long)n13) * 60L + (long)n14) * 1000L + (long)n15;
        n12 = (int)((long)n12 + l / 86400000L);
        n8 = (int)(l % 86400000L);
        if (n11 < 0) {
            n10 += n11 / 12;
            if ((n11 %= 12) < 0) {
                n11 += 12;
                --n10;
            }
        }
        if (n11 > 11) {
            n10 += n11 / 12;
            n11 %= 12;
        }
        nArray[1] = this.isLeapYear(n10) + 28;
        while (n12 <= 0) {
            if (n11 == 0) {
                nArray[1] = this.isLeapYear(--n10) + 28;
            }
            n11 = (n11 + 11) % 12;
            n12 += nArray[n11];
        }
        while (n12 > nArray[n11]) {
            n12 -= nArray[n11];
            if ((n11 = (n11 + 1) % 12) != 0) continue;
            nArray[1] = this.isLeapYear(++n10) + 28;
        }
        n5 = nArray3[n11] + n12 - 1;
        if (this.isLeapYear(n10) && n11 > 1) {
            ++n5;
        }
        n4 = (long)((n4 = (n10 - 1) * 365 + (n10 - 1 >> 2) + n5 - 719162) + (n3 = (int)Math.floor((double)(n10 - 1) / 400.0) - (int)Math.floor((double)(n10 - 1) / 100.0))) * 60L * 60L * 24L * 1000L >= this.gregorianCutover ? (n4 += n3) : (n4 -= 2);
        this.time = (long)n4 * 86400000L + (long)n8;
        int n17 = (n4 + 5) % 7;
        if (n17 <= 0) {
            n17 += 7;
        }
        this.fields[7] = n17;
        TimeZone timeZone = this.getTimeZone();
        int n18 = n2 = this.isSet[15] ? this.fields[15] : timeZone.getRawOffset();
        if (this.isSet[16]) {
            n = this.fields[16];
        } else {
            int n19 = 0;
            if (n10 < 0) {
                n19 = 1;
            }
            n = timeZone.getOffset(1 - n19, n10 < 0 ? 1 - n10 : n10, n11, n12, n17, n8) - timeZone.getRawOffset();
        }
        int n20 = n;
        this.time -= (long)(n2 + n20);
        this.isTimeSet = true;
    }

    private final long getLinearDay(int n, int n2, boolean bl) {
        long l = (long)(n - 1) * 365L + (long)(n - 1 >> 2) + (long)(n2 - 1) - 719162L;
        if (bl) {
            int n3 = (int)Math.floor((double)(n - 1) / 400.0) - (int)Math.floor((double)(n - 1) / 100.0);
            return l + (long)n3;
        }
        return l -= (long)2;
    }

    private final void calculateDay(int[] nArray, long l, boolean bl) {
        long l2;
        int n = (int)(l + (long)5) % 7;
        if (n <= 0) {
            n += 7;
        }
        nArray[7] = n;
        int n2 = 1970 + (int)(bl ? (l - 100L) * 400L / 146097L : (l - 100L) * (long)4 / 1461L);
        if (l >= 0L) {
            ++n2;
        }
        if (l < (l2 = this.getLinearDay(n2, 1, bl))) {
            l2 = this.getLinearDay(--n2, 1, bl);
        }
        nArray[6] = (int)(l -= l2 - 1L);
        if (n2 <= 0) {
            nArray[0] = 0;
            nArray[1] = 1 - n2;
        } else {
            nArray[0] = 1;
            nArray[1] = n2;
        }
        int n3 = this.isLeapYear(n2);
        if (l <= (long)(59 + n3)) {
            nArray[2] = (int)l / 32;
            nArray[5] = (int)l - 31 * nArray[2];
        } else {
            int n4 = ((int)l - n3) * 5 + 8;
            nArray[2] = n4 / 153;
            nArray[5] = n4 % 153 / 5 + 1;
        }
    }

    protected synchronized void computeFields() {
        int n;
        int n2;
        boolean bl = false;
        if (this.time >= this.gregorianCutover) {
            bl = true;
        }
        boolean bl2 = bl;
        TimeZone timeZone = this.getTimeZone();
        this.fields[15] = timeZone.getRawOffset();
        long l = this.time + (long)this.fields[15];
        long l2 = l / 86400000L;
        int n3 = (int)(l % 86400000L);
        if (n3 < 0) {
            n3 += 86400000;
            --l2;
        }
        this.calculateDay(this.fields, l2, bl2);
        this.fields[16] = timeZone.getOffset(this.fields[0], this.fields[1], this.fields[2], this.fields[5], this.fields[7], n3) - this.fields[15];
        if ((n3 += this.fields[16]) >= 86400000) {
            n3 -= 86400000;
            this.calculateDay(this.fields, ++l2, bl2);
        }
        this.fields[8] = (this.fields[5] + 6) / 7;
        int n4 = (7 + this.fields[7] - this.getFirstDayOfWeek()) % 7;
        this.fields[4] = (this.fields[5] - n4 + 12) / 7;
        int n5 = (this.fields[6] - n4 + 6) / 7;
        int n6 = this.getMinimalDaysInFirstWeek();
        if (n6 - (n2 = (7 + this.getWeekDay(this.fields[1], n6) - this.getFirstDayOfWeek()) % 7) < 1) {
            // empty if block
        }
        this.fields[3] = ++n5;
        int n7 = n3 / 3600000;
        int n8 = 0;
        if (n7 < 12) {
            n8 = 1;
        }
        this.fields[9] = 1 - n8;
        this.fields[10] = n = n7 % 12;
        this.fields[11] = n7;
        this.fields[12] = (n3 %= 3600000) / 60000;
        this.fields[13] = (n3 %= 60000) / 1000;
        this.fields[14] = n3 % 1000;
        this.isSet[16] = true;
        this.isSet[15] = true;
        this.isSet[14] = true;
        this.isSet[13] = true;
        this.isSet[12] = true;
        this.isSet[11] = true;
        this.isSet[10] = true;
        this.isSet[9] = true;
        this.isSet[8] = true;
        this.isSet[7] = true;
        this.isSet[6] = true;
        this.isSet[5] = true;
        this.isSet[4] = true;
        this.isSet[3] = true;
        this.isSet[2] = true;
        this.isSet[1] = true;
        this.isSet[0] = true;
        this.areFieldsSet = true;
    }

    public int hashCode() {
        int n = (int)(this.gregorianCutover >>> 32 ^ this.gregorianCutover & (long)-1);
        return super.hashCode() ^ n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GregorianCalendar)) {
            return false;
        }
        GregorianCalendar gregorianCalendar = (GregorianCalendar)object;
        boolean bl = false;
        if (gregorianCalendar.gregorianCutover == this.gregorianCutover && super.equals(object)) {
            bl = true;
        }
        return bl;
    }

    public void add(int n, int n2) {
        switch (n) {
            case 1: {
                this.complete();
                this.fields[1] = this.fields[1] + n2;
                this.isTimeSet = false;
                break;
            }
            case 2: {
                int n3;
                this.complete();
                int n4 = this.fields[2] + n2;
                this.fields[1] = this.fields[1] + n4 / 12;
                this.fields[2] = n4 % 12;
                if (this.fields[2] < 0) {
                    this.fields[2] = this.fields[2] + 12;
                    this.fields[1] = this.fields[1] - 1;
                }
                if (this.fields[5] > (n3 = this.getActualMaximum(5))) {
                    this.fields[5] = n3;
                }
                this.set(1, this.fields[1]);
                this.set(2, this.fields[2]);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)n2 * 86400000L;
                this.areFieldsSet = false;
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)n2 * 604800000L;
                this.areFieldsSet = false;
                break;
            }
            case 9: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)n2 * 43200000L;
                this.areFieldsSet = false;
                break;
            }
            case 10: 
            case 11: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)n2 * 3600000L;
                this.areFieldsSet = false;
                break;
            }
            case 12: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)n2 * 60000L;
                this.areFieldsSet = false;
                break;
            }
            case 13: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)n2 * 1000L;
                this.areFieldsSet = false;
                break;
            }
            case 14: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)n2;
                this.areFieldsSet = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid or unknown field");
            }
        }
    }

    public void roll(int n, boolean bl) {
        this.roll(n, bl ? 1 : -1);
    }

    private final void cleanUpAfterRoll(int n, int n2) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                if (this.fields[5] > this.getActualMaximum(5)) {
                    this.fields[5] = this.getActualMaximum(5);
                }
                this.isTimeSet = false;
                this.isSet[4] = false;
                this.isSet[7] = false;
                this.isSet[8] = false;
                this.isSet[6] = false;
                this.isSet[3] = false;
                break;
            }
            case 5: {
                this.isSet[4] = false;
                this.isSet[7] = false;
                this.isSet[8] = false;
                this.isSet[6] = false;
                this.isSet[3] = false;
                this.time += (long)n2 * 86400000L;
                break;
            }
            case 4: {
                this.isSet[5] = false;
                this.isSet[8] = false;
                this.isSet[6] = false;
                this.isSet[3] = false;
                this.time += (long)n2 * 604800000L;
                break;
            }
            case 8: {
                this.isSet[5] = false;
                this.isSet[4] = false;
                this.isSet[6] = false;
                this.isSet[3] = false;
                this.time += (long)n2 * 604800000L;
                break;
            }
            case 6: {
                this.isSet[2] = false;
                this.isSet[5] = false;
                this.isSet[4] = false;
                this.isSet[8] = false;
                this.isSet[7] = false;
                this.isSet[3] = false;
                this.time += (long)n2 * 86400000L;
                break;
            }
            case 3: {
                this.isSet[2] = false;
                this.isSet[5] = false;
                this.isSet[4] = false;
                this.isSet[8] = false;
                this.isSet[6] = false;
                this.time += (long)n2 * 604800000L;
                break;
            }
            case 9: {
                this.isSet[11] = false;
                this.time += (long)n2 * 43200000L;
                break;
            }
            case 10: {
                this.isSet[11] = false;
                this.time += (long)n2 * 3600000L;
                break;
            }
            case 11: {
                this.isSet[10] = false;
                this.isSet[9] = false;
                this.time += (long)n2 * 3600000L;
                break;
            }
            case 12: {
                this.time += (long)n2 * 60000L;
                break;
            }
            case 13: {
                this.time += (long)n2 * 1000L;
                break;
            }
            case 14: {
                this.time += (long)n2;
                break;
            }
        }
    }

    public void roll(int n, int n2) {
        switch (n) {
            case 7: {
                this.add(n, n2);
                return;
            }
            case 15: 
            case 16: {
                throw new IllegalArgumentException("Can't roll time zone");
            }
        }
        this.complete();
        int n3 = this.getActualMinimum(n);
        int n4 = this.getActualMaximum(n) - n3 + 1;
        int n5 = this.fields[n];
        int n6 = (n5 - n3 + n4 + n2) % n4 + n3;
        if (n6 < n3) {
            n6 += n4;
        }
        this.fields[n] = n6;
        this.cleanUpAfterRoll(n, n6 - n5);
    }

    public int getMinimum(int n) {
        return minimums[n];
    }

    public int getMaximum(int n) {
        return maximums[n];
    }

    public int getGreatestMinimum(int n) {
        if (n == 3) {
            return 1;
        }
        return minimums[n];
    }

    public int getLeastMaximum(int n) {
        switch (n) {
            case 3: {
                return 52;
            }
            case 5: {
                return 28;
            }
            case 6: {
                return 365;
            }
            case 4: 
            case 8: {
                return 4;
            }
        }
        return maximums[n];
    }

    public int getActualMinimum(int n) {
        if (n == 3) {
            int n2;
            int n3;
            int n4 = this.getMinimalDaysInFirstWeek();
            if (n4 == 0) {
                return 1;
            }
            if (!(this.areFieldsSet && this.isSet[0] && this.isSet[1])) {
                this.complete();
            }
            if ((7 + (n3 = this.getWeekDay(n2 = this.fields[0] == 1 ? this.fields[1] : 1 - this.fields[1], n4)) - this.getFirstDayOfWeek()) % 7 >= n4 - 1) {
                return 1;
            }
            return 0;
        }
        return minimums[n];
    }

    public int getActualMaximum(int n) {
        switch (n) {
            case 3: {
                int n2;
                if (!(this.areFieldsSet && this.isSet[0] && this.isSet[1])) {
                    this.complete();
                }
                int n3 = this.fields[0] == 1 ? this.fields[1] : 1 - this.fields[1];
                int n4 = this.isLeapYear(n3) + 365;
                int n5 = this.getWeekDay(n3, n4);
                int n6 = (n4 + 6 - (7 + n5 - this.getFirstDayOfWeek()) % 7) / 7;
                int n7 = this.getMinimalDaysInFirstWeek();
                if (n7 - (7 + (n2 = this.getWeekDay(n3, n7)) - this.getFirstDayOfWeek()) % 7 < 1) {
                    return n6 + 1;
                }
            }
            case 5: {
                int n4;
                int n3;
                if (!this.areFieldsSet || !this.isSet[2]) {
                    this.complete();
                }
                if ((n3 = this.fields[2]) == 1) {
                    if (!this.isSet[1] || !this.isSet[0]) {
                        this.complete();
                    }
                    n4 = this.fields[0] == 1 ? this.fields[1] : 1 - this.fields[1];
                    return this.isLeapYear(n4) + 28;
                }
                if (n3 < 7) {
                    return 31 - (n3 & 1);
                }
                return 30 + (n3 & 1);
            }
            case 6: {
                if (!(this.areFieldsSet && this.isSet[0] && this.isSet[1])) {
                    this.complete();
                }
                int n8 = this.fields[0] == 1 ? this.fields[1] : 1 - this.fields[1];
                return this.isLeapYear(n8) + 365;
            }
            case 8: {
                int n9 = this.getActualMaximum(5);
                return (n9 - (this.fields[5] - 1) % 7 + 6) / 7;
            }
            case 4: {
                int n10 = this.getActualMaximum(5);
                int n11 = (n10 - this.fields[5] + this.fields[7] - 1) % 7 + 1;
                return (n10 + 6 - (7 + n11 - this.getFirstDayOfWeek()) % 7) / 7;
            }
        }
        return maximums[n];
    }

    private final /* synthetic */ void this() {
        this.gregorianCutover = new Date(-12219292800000L).getTime();
    }

    public GregorianCalendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    public GregorianCalendar(TimeZone timeZone) {
        this(timeZone, Locale.getDefault());
    }

    public GregorianCalendar(Locale locale) {
        this(TimeZone.getDefault(), locale);
    }

    public GregorianCalendar(TimeZone timeZone, Locale locale) {
        this(timeZone, locale, false);
        this.setTimeInMillis(System.currentTimeMillis());
        this.complete();
    }

    private GregorianCalendar(TimeZone timeZone, Locale locale, boolean bl) {
        super(timeZone, locale);
        this.this();
    }

    public GregorianCalendar(int n, int n2, int n3) {
        this(TimeZone.getDefault(), Locale.getDefault(), false);
        this.set(n, n2, n3);
    }

    public GregorianCalendar(int n, int n2, int n3, int n4, int n5) {
        this(TimeZone.getDefault(), Locale.getDefault(), false);
        this.set(n, n2, n3, n4, n5);
    }

    public GregorianCalendar(int n, int n2, int n3, int n4, int n5, int n6) {
        this(TimeZone.getDefault(), Locale.getDefault(), false);
        this.set(n, n2, n3, n4, n5, n6);
    }

    static {
        int[] nArray = new int[17];
        nArray[1] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[8] = 1;
        nArray[10] = 1;
        nArray[15] = -43200000;
        minimums = nArray;
        maximums = new int[]{1, 5000000, 11, 53, 5, 31, 366, 7, 5, 1, 12, 23, 59, 59, 999, 43200000, 43200000};
    }
}

