.\" $Header: /home/vikas/netmgt/nocol/src/doc/RCS/trapmon.8,v 1.8 1994/11/29 20:12:56 vikas Exp $
.\"
.TH TRAPMON 8 "June 10, 1992"
.SH NAME
.B trapmon
\- inform
.BR nocol (1)
of outstanding SNMP trap messages
.SH USAGE
.B trapmon [\-v] [\-p] [\-n] [\-l]
.TP
.B \-p
Print a one-line summary to stderr for each trap received.
.TP
.B \-n
Send output to a file formatted so that
.BR nocol (1)
can read and display it.
One EVENT structure is written for each trap that
.B trapmon
receives.
.TP
.B \-l
Send a one-line summary to the
.BR syslogd (8)
facility, using the same format as the \-p switch.
.TP
.B \-v
Send various debugging output to stdout.  It is unlikely that
this switch will be of any real use, except in tracking down bugs.
.LP
Multiple options may be specified.
.B trapmon
\-pn is equivalent to
.B trapmon
\-n \-p.
.SH DESCRIPTION
.LP
.B trapmon
was developed specifically for use with the
.BR nocol (1)
network monitoring system- the \-n switch enables reporting designed for
processing by
.B nocol.
.B trapmon
processes traps asynchronously using
.BR select (2).
As each trap is received, the user is notified
on stderr, through
.B syslogd,
or through
.BR nocol .
With the \-n option, an EVENT structure is appended
to the output file for each trap, and then
is deleted after 30 minutes.
This timeout feature ensures that trap data (and datafile)
does not grow without bounds.
.LP
Each trap type is pre-assigned a severity level (these are listed in
the
.I trapmon.h
include file)\- thus a
.I Link Down
trap will be assigned a NOCOL severity level of ERROR while a
.I Cold Start
trap will be assigned a severity level of WARNING.
.LP
.B trapmon
binds to the SNMP port, so it must be executed by the superuser.
.LP
For facilitating 
.I enterprise
specific traps, trapmon appends the value in the 
.I specific_type
field of the trap packet to the word 'Enterprise' in the 
.I variable 
field of the EVENT structure for NOCOL.
.SH CAVEATS
.LP
If the output file for
.B nocol
is on NFS, then 
.B trapmon
will not be able to create the output file unless it is in a world-writable
directory.  This is because NFS will not honor superuser privileges on the
remote filesystem where the directory exists.
\fI Thus, the output file must exist on the local machine and not on an NFS
mounted partition.\fR
.LP
The severity level of each trap is defined during compile time in the
.I trapmon.h
include file. To change the severity level, the program has to be recompiled.
.RS
.ta \w'#define'u +\w'fsid_t\0\0'u +\w'f_spare[7]\0\0'u
.sp .5
.nf
   "Cold_Start"	E_WARNING	/* trap 0 */
   "Warm_Start"	E_WARNING	/* trap 1 */
   "Link_Down"	E_ERROR	/* trap 2 */
   "Link_Up"	E_ERROR	/* trap 3 */
   "Auth_Failure"	E_WARNING	/* trap 4 */
   "EGP_Peer_Loss"	E_CRITICAL	/* trap 5 */
   "Enterprise"	E_WARNING	/* trap 6 */
   "Unknown_Type"	E_WARNING	/* trap 7 */
.fi
.RE
.LP
The 
.I enterprise
specific traps are not converted into text- only the number representing the
.I specific_type
(from the RFC trap PDU specification) is displayed.
.SH AUTHOR
David Wagner, wagner@phoenix.princeton.edu, June 10 1992
.LP
.B trapmon
is derived from snmptrapd, a similar program without
.B nocol
support that was written by Carnegie Mellon University, and is part of the
CMU snmp distribution available via
.I anonymous
ftp.
.SH SEE ALSO
netconsole(1) nocol-prog(3) perlnocol(3)
eventselect(8) genmon(8) noclogd(8) nocol-overview(8)
nocol-utility(8) nsmon(8) pingmon(8) portmon(8) 
tpmon(8) trapmon(8)
RFC 1065, RFC 1066, RFC 1067
