"""
Support for package 'import' in Rubber.
"""

from os.path import basename
import re
import rubber

re_ipath = re.compile("{(?P<prefix>[^{}]*)}")
class Module (rubber.rules.latex.Module):
	def __init__ (self, doc, dict):
		self.doc = doc
		doc.add_hook("import", self.import_doc)

	def import_doc (self, dict):
		if not dict["arg"]:
			return 0
		self.doc.env.path.append(dict["arg"])
		m = re_ipath.match(dict["line"])
		self.doc.input_file(m.group("prefix") + ".tex")
