/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.bibtex;

import java.io.IOException;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.ConvertException;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.DocumentSerializer;
import org.openoffice.xmerge.converter.xml.sxw.SxwDocument;
import org.w3c.dom.NodeList;
import writer2latex.bibtex.BibTeXDocument;
import writer2latex.office.BibMark;
import writer2latex.util.Misc;

public final class DocumentSerializerImpl
implements DocumentSerializer {
    private SxwDocument sxwDoc;
    private String sOutFileName;

    public void setOutFileName(String s) {
        this.sOutFileName = Misc.trimDocumentName(s, ".bib");
    }

    public DocumentSerializerImpl(Document doc) {
        this.sxwDoc = (SxwDocument)doc;
        this.sOutFileName = this.sxwDoc.getName();
    }

    public ConvertData serialize() throws IOException, ConvertException {
        ConvertData convertData = new ConvertData();
        BibTeXDocument bibDoc = new BibTeXDocument(this.sOutFileName);
        org.w3c.dom.Document doc = this.sxwDoc.getContentDOM();
        NodeList list = doc.getElementsByTagName("text:bibliography-mark");
        int nLen = list.getLength();
        int i = 0;
        while (i < nLen) {
            String sIdentifier = Misc.getAttribute(list.item(i), "text:identifier");
            if (!bibDoc.containsKey(sIdentifier)) {
                bibDoc.put(new BibMark(list.item(i)));
            }
            ++i;
        }
        convertData.addDocument(bibDoc);
        return convertData;
    }
}

