package org.cdavies.itunes.request;

import java.util.*;
import java.io.*;
import java.net.*;


import org.cdavies.itunes.hash.*;
import itunes.FieldPair;

public abstract class Request {
	
	public static final int ITUNES_PORT = 3689;
	
	protected String server;
	protected int port;
	public byte[] data;
	protected int offset;
	protected int expectedLength;
	protected String dataType;
	protected ArrayList fieldPairs;
	protected ArrayList mlitIndexes;
	protected ArrayList mlclIndexes;
	protected ArrayList mdclIndexes;
	protected String requestString;
	protected URLConnection _conn;
	
	protected ItunesHash hash = null;
	
	public Request(String server, int port, String rs) {
		this.server = server;
		this.port = port;
		dataType = "";
		offset = 0;
		fieldPairs = new ArrayList();
		mlitIndexes = new ArrayList();
		mlclIndexes = new ArrayList();
		mdclIndexes = new ArrayList();
		requestString = rs;
		
	}
	
	public void constructQuery() {
		
		URL _url = null;
		
		try {
			
			_url = new URL("http://"+server+":"+port+"/"+requestString);
			URLConnection _urlc = _url.openConnection();
			
			_urlc.setRequestProperty("User-Agent", "AppleRecords");
			_urlc.addRequestProperty("Client-DAAP-Access-Index", "1");
			_urlc.addRequestProperty("Client-DAAP-Validation", hash.generateHash("/"+requestString, 1, -1));
			_conn = _urlc;
			
		}
		catch (Exception e) {
			
			/* Should never happen */
			_conn = null;
			
		}
		
	}
	
	public abstract void runQuery() throws NoServerPermissionException;
	
	public void setHash(ItunesHash hash) {
		
		this.hash = hash;
		
	}
	
	
	protected static int readSize(String data) {
		
		return readSize(data, 4);
		
	}
	
	protected static int readSize(String data, int size) {
		
		String _length = "";
		
		for (int _i = 0; _i < size; _i++) {
			
			int _dataInstance = (int)data.charAt(_i);
			_length += ( (_dataInstance > 15 ) ? "" : "0" ) 
				+ Integer.toHexString(_dataInstance);
			
		}
		
		return Integer.valueOf(_length,16).intValue();
	
	}
	
	protected String dataString(int size) {
		
		return readString(data, offset, size);
		
	}
	
	public static String readString(byte[] data, int offset, int size) {
		
		String _result = "";
		
		try {
			
			_result = new String(data, offset, size, "UTF-8");
			
		} catch (UnsupportedEncodingException _e) {
			
			_e.printStackTrace();	
			
		}
		
		return _result;
		
	}
	
	protected int dataInt() {
		
		return readInt(data, offset, 4);
		
	}
	
	protected static int readInt(byte[] data, int offset) {
		
		int _i = 0;
		
		try {
			
			ByteArrayInputStream _b = new ByteArrayInputStream(data, offset, 4);
			DataInputStream _d = new DataInputStream(_b);
			_i = _d.readInt();
			
		} catch (IOException e) {
			
			e.printStackTrace();
			
		}
		
		return _i;
	}
	
	public static int readInt(byte[] data, int offset, int size) {
		
		int _i = 0;
		
		try {
			
			ByteArrayInputStream _b = new ByteArrayInputStream(data, offset, size);
			DataInputStream _d = new DataInputStream(_b);
			int _pow = size * 2 - 1;
			
			for (int _j = 0; _j < size; _j++) {
				
				int _num = (0xFF & _d.readByte());
				int _up = ((int)Math.pow(16, _pow)) * (_num/16);
				_pow--;
				int _down= ((int)Math.pow(16, _pow)) * (_num%16);
				_i += _up + _down;
				_pow--;
				
			}
			
		} 
		catch (IOException _e) {
			
			_e.printStackTrace();
			
		}
		
		return _i;
		
	}
	
	public void process() throws NoServerPermissionException {
		
		if (data.length==0) {
			return;
		}
		
		dataType= dataString(4);
		offset += 4;
		int _size = dataInt();
		offset += 4;
		
		fieldPairs = processDataFields();	
		
	}
	
	protected ArrayList processDataFields(byte[] data, int offset) {
		
		ArrayList _fieldPairs = new ArrayList();
		
		while (offset < data.length) {
			
			String _name="";
			_name = readString(data,offset,4);
			offset +=4;
			int _size=readInt(data,offset);
			offset+=4;
			FieldPair _fp = new FieldPair(_name, data, offset, _size);
			offset += _size;
			_fieldPairs.add(_fp);
			
			if (_name.equals("mlcl")) {
				
				mlclIndexes.add(new Integer(_fieldPairs.size()-1));
				
			} 
			else if (_name.equals("mlit")) {
				
				mlitIndexes.add(new Integer(_fieldPairs.size()-1));
				
			} 
			else if (_name.equals("mdcl")) {
				
				mdclIndexes.add(new Integer(_fieldPairs.size()-1));
				
			}
			
		}
		
		return _fieldPairs;
	}
	
	protected ArrayList processDataFields() {
		
		return processDataFields(data,offset);
		
	}
	
}
