/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Random;
import org.xiph.speex.AudioFileWriter;
import org.xiph.speex.NbEncoder;
import org.xiph.speex.OggCrc;
import org.xiph.speex.PcmWaveWriter;
import org.xiph.speex.RawWriter;
import org.xiph.speex.SbEncoder;
import org.xiph.speex.SpeexDecoder;

public class JSpeexDec {
    public static final String VERSION = "Java Speex Command Line Decoder v0.9 ($Revision: 1.9 $)";
    public static final String COPYRIGHT = "Copyright (C) 2002-2004 Wimba S.A.";
    public static final int DEBUG = 0;
    public static final int INFO = 1;
    public static final int WARN = 2;
    public static final int ERROR = 3;
    protected static int printlevel = 1;
    protected static Random random = new Random();
    protected static SpeexDecoder speexDecoder;
    protected static boolean ogg;
    protected static boolean wav;
    protected static boolean enhanced;
    private static int mode;
    private static int quality;
    private static int nframes;
    private static int sampleRate;
    private static float vbr_quality;
    private static boolean vbr;
    private static int channels;
    private static int loss;

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length < 2) {
            if (stringArray.length == 1 && (stringArray[0].equals("-v") || stringArray[0].equals("--version"))) {
                JSpeexDec.version();
                return;
            }
            JSpeexDec.usage();
            return;
        }
        String string = stringArray[stringArray.length - 2];
        String string2 = stringArray[stringArray.length - 1];
        ogg = string.toLowerCase().endsWith(".spx");
        wav = string2.toLowerCase().endsWith(".wav");
        for (int i = 0; i < stringArray.length - 2; ++i) {
            if (stringArray[i].equalsIgnoreCase("-h") || stringArray[i].equalsIgnoreCase("--help")) {
                JSpeexDec.usage();
                return;
            }
            if (stringArray[i].equalsIgnoreCase("-v") || stringArray[i].equalsIgnoreCase("--version")) {
                JSpeexDec.version();
                return;
            }
            if (stringArray[i].equalsIgnoreCase("--enh")) {
                enhanced = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("--no-enh")) {
                enhanced = false;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("--packet-loss")) {
                try {
                    loss = Integer.parseInt(stringArray[++i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    JSpeexDec.usage();
                    return;
                }
            }
            if (stringArray[i].equalsIgnoreCase("-n") || stringArray[i].equalsIgnoreCase("-nb") || stringArray[i].equalsIgnoreCase("--narrowband")) {
                mode = 0;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-w") || stringArray[i].equalsIgnoreCase("-wb") || stringArray[i].equalsIgnoreCase("--wideband")) {
                mode = 1;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-u") || stringArray[i].equalsIgnoreCase("-uwb") || stringArray[i].equalsIgnoreCase("--ultra-wideband")) {
                mode = 2;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-q") || stringArray[i].equalsIgnoreCase("--quality")) {
                try {
                    vbr_quality = Float.parseFloat(stringArray[++i]);
                    quality = (int)vbr_quality;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    JSpeexDec.usage();
                    return;
                }
            }
            if (stringArray[i].equalsIgnoreCase("--nframes")) {
                try {
                    nframes = Integer.parseInt(stringArray[++i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    JSpeexDec.usage();
                    return;
                }
            }
            if (stringArray[i].equalsIgnoreCase("--vbr")) {
                vbr = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("--stereo")) {
                channels = 2;
                continue;
            }
            JSpeexDec.usage();
            return;
        }
        if (sampleRate < 0) {
            switch (mode) {
                case 0: {
                    sampleRate = 8000;
                    break;
                }
                case 1: {
                    sampleRate = 16000;
                    break;
                }
                case 2: {
                    sampleRate = 32000;
                    break;
                }
                default: {
                    sampleRate = 8000;
                }
            }
        }
        JSpeexDec.decode(string, string2);
    }

    public static void usage() {
        JSpeexDec.version();
        System.out.println("");
        System.out.println("Usage: JSpeexDec [options] input_file output_file");
        System.out.println("Where:");
        System.out.println("  input_file can be:");
        System.out.println("    filename.spx  an Ogg Speex file");
        System.out.println("    filename.*    a raw Speex file");
        System.out.println("  output_file can be:");
        System.out.println("    filename.wav  a PCM wav file");
        System.out.println("    filename.*    a raw PCM file (any extension other than .wav)");
        System.out.println("Options: -h, --help     This help");
        System.out.println("         -v, --version    Version information");
        System.out.println("         --enh            Enable perceptual enhancement (default)");
        System.out.println("         --no-enh         Disable perceptual enhancement");
        System.out.println("         --packet-loss n  Simulate n % random packet loss");
        System.out.println("         if the input file is raw Speex (not Ogg Speex)");
        System.out.println("         -n, -nb          Narrowband (8kHz)");
        System.out.println("         -w, -wb          Wideband (16kHz)");
        System.out.println("         -u, -uwb         Ultra-Wideband (32kHz)");
        System.out.println("         --quality n      Encoding quality (0-10) default 8");
        System.out.println("         --nframes n      Number of frames per Ogg packet, default 1");
        System.out.println("         --vbr            Enable varible bit-rate (VBR)");
        System.out.println("         --stereo         Consider input as stereo");
        System.out.println("More information is available from: http://jspeex.sourceforge.net/");
        System.out.println("This code is a Java port of the Speex codec: http://www.speex.org/");
    }

    public static void version() {
        System.out.println(VERSION);
        System.out.println("using Java Speex Decoder v0.9 ($Revision: 1.9 $)");
        System.out.println(COPYRIGHT);
    }

    public static void decode(String string, String string2) throws IOException {
        byte[] byArray = new byte[2048];
        byte[] byArray2 = new byte[65536];
        byte[] byArray3 = new byte[176400];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (printlevel <= 1) {
            JSpeexDec.version();
        }
        if (printlevel <= 0) {
            System.out.println("");
        }
        if (printlevel <= 0) {
            System.out.println("Input File: " + string);
        }
        speexDecoder = new SpeexDecoder();
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));
        AudioFileWriter audioFileWriter = null;
        try {
            while (true) {
                int n6;
                if (ogg) {
                    dataInputStream.readFully(byArray, 0, 27);
                    int n7 = JSpeexDec.readInt(byArray, 22);
                    byArray[22] = 0;
                    byArray[23] = 0;
                    byArray[24] = 0;
                    byArray[25] = 0;
                    int n8 = OggCrc.checksum(0, byArray, 0, 27);
                    if (!"OggS".equals(new String(byArray, 0, 4))) {
                        System.err.println("missing ogg id!");
                        return;
                    }
                    n = byArray[26] & 0xFF;
                    dataInputStream.readFully(byArray, 27, n);
                    n8 = OggCrc.checksum(n8, byArray, 27, n);
                    for (n2 = 0; n2 < n; ++n2) {
                        n3 = byArray[27 + n2] & 0xFF;
                        if (n3 == 255) {
                            System.err.println("sorry, don't handle 255 sizes!");
                            return;
                        }
                        dataInputStream.readFully(byArray2, 0, n3);
                        n8 = OggCrc.checksum(n8, byArray2, 0, n3);
                        if (n5 == 0) {
                            if (JSpeexDec.readSpeexHeader(byArray2, 0, n3)) {
                                if (printlevel <= 0) {
                                    System.out.println("File Format: Ogg Speex");
                                    System.out.println("Sample Rate: " + sampleRate);
                                    System.out.println("Channels: " + channels);
                                    System.out.println("Encoder mode: " + (mode == 0 ? "Narrowband" : (mode == 1 ? "Wideband" : "UltraWideband")));
                                    System.out.println("Frames per packet: " + nframes);
                                }
                                if (wav) {
                                    audioFileWriter = new PcmWaveWriter(speexDecoder.getChannels(), speexDecoder.getSampleRate());
                                    if (printlevel <= 0) {
                                        System.out.println("");
                                        System.out.println("Output File: " + string2);
                                        System.out.println("File Format: PCM Wave");
                                        System.out.println("Perceptual Enhancement: " + enhanced);
                                    }
                                } else {
                                    audioFileWriter = new RawWriter();
                                    if (printlevel <= 0) {
                                        System.out.println("");
                                        System.out.println("Output File: " + string2);
                                        System.out.println("File Format: Raw Audio");
                                        System.out.println("Perceptual Enhancement: " + enhanced);
                                    }
                                }
                                audioFileWriter.open(string2);
                                audioFileWriter.writeHeader(null);
                                ++n5;
                                continue;
                            }
                            n5 = 0;
                            continue;
                        }
                        if (n5 == 1) {
                            ++n5;
                            continue;
                        }
                        if (loss > 0 && random.nextInt(100) < loss) {
                            speexDecoder.processData(null, 0, n3);
                            for (n6 = 1; n6 < nframes; ++n6) {
                                speexDecoder.processData(true);
                            }
                        } else {
                            speexDecoder.processData(byArray2, 0, n3);
                            for (n6 = 1; n6 < nframes; ++n6) {
                                speexDecoder.processData(false);
                            }
                        }
                        if ((n4 = speexDecoder.getProcessedData(byArray3, 0)) > 0) {
                            audioFileWriter.writePacket(byArray3, 0, n4);
                        }
                        ++n5;
                    }
                    if (n8 == n7) continue;
                    throw new IOException("Ogg CheckSums do not match");
                }
                if (n5 == 0) {
                    if (printlevel <= 0) {
                        System.out.println("File Format: Raw Speex");
                        System.out.println("Sample Rate: " + sampleRate);
                        System.out.println("Channels: " + channels);
                        System.out.println("Encoder mode: " + (mode == 0 ? "Narrowband" : (mode == 1 ? "Wideband" : "UltraWideband")));
                        System.out.println("Frames per packet: " + nframes);
                    }
                    speexDecoder.init(mode, sampleRate, channels, enhanced);
                    if (wav) {
                        audioFileWriter = new PcmWaveWriter(channels, sampleRate);
                        if (printlevel <= 0) {
                            System.out.println("");
                            System.out.println("Output File: " + string2);
                            System.out.println("File Format: PCM Wave");
                            System.out.println("Perceptual Enhancement: " + enhanced);
                        }
                    } else {
                        audioFileWriter = new RawWriter();
                        if (printlevel <= 0) {
                            System.out.println("");
                            System.out.println("Output File: " + string2);
                            System.out.println("File Format: Raw Audio");
                            System.out.println("Perceptual Enhancement: " + enhanced);
                        }
                    }
                    audioFileWriter.open(string2);
                    audioFileWriter.writeHeader(null);
                    if (!vbr) {
                        switch (mode) {
                            case 0: {
                                n3 = NbEncoder.NB_FRAME_SIZE[NbEncoder.NB_QUALITY_MAP[quality]];
                                break;
                            }
                            case 1: {
                                n3 = SbEncoder.NB_FRAME_SIZE[SbEncoder.NB_QUALITY_MAP[quality]];
                                n3 += SbEncoder.SB_FRAME_SIZE[SbEncoder.WB_QUALITY_MAP[quality]];
                                break;
                            }
                            case 2: {
                                n3 = SbEncoder.NB_FRAME_SIZE[SbEncoder.NB_QUALITY_MAP[quality]];
                                n3 += SbEncoder.SB_FRAME_SIZE[SbEncoder.WB_QUALITY_MAP[quality]];
                                n3 += SbEncoder.SB_FRAME_SIZE[SbEncoder.UWB_QUALITY_MAP[quality]];
                                break;
                            }
                        }
                        n3 = n3 + 7 >> 3;
                    } else {
                        n3 = 0;
                    }
                    ++n5;
                    continue;
                }
                dataInputStream.readFully(byArray2, 0, n3);
                if (loss > 0 && random.nextInt(100) < loss) {
                    speexDecoder.processData(null, 0, n3);
                    for (n6 = 1; n6 < nframes; ++n6) {
                        speexDecoder.processData(true);
                    }
                } else {
                    speexDecoder.processData(byArray2, 0, n3);
                    for (n6 = 1; n6 < nframes; ++n6) {
                        speexDecoder.processData(false);
                    }
                }
                if ((n4 = speexDecoder.getProcessedData(byArray3, 0)) > 0) {
                    audioFileWriter.writePacket(byArray3, 0, n4);
                }
                ++n5;
            }
        }
        catch (EOFException eOFException) {
            audioFileWriter.close();
            return;
        }
    }

    private static boolean readSpeexHeader(byte[] byArray, int n, int n2) {
        if (n2 != 80) {
            return false;
        }
        if (!"Speex   ".equals(new String(byArray, 0, 8))) {
            return false;
        }
        mode = byArray[40 + n] & 0xFF;
        sampleRate = JSpeexDec.readInt(byArray, n + 36);
        channels = JSpeexDec.readInt(byArray, n + 48);
        nframes = JSpeexDec.readInt(byArray, n + 64);
        return speexDecoder.init(mode, sampleRate, channels, enhanced);
    }

    protected static int readInt(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | byArray[n + 3] << 24;
    }

    static {
        ogg = true;
        wav = true;
        enhanced = true;
        mode = 0;
        quality = 8;
        nframes = 1;
        sampleRate = -1;
        vbr_quality = -1.0f;
        vbr = false;
        channels = 1;
        loss = 0;
    }
}

