/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;

public class Random
implements Serializable {
    private static final long serialVersionUID = 3905348978240129619L;
    private boolean haveNextNextGaussian;
    private double nextNextGaussian;
    private long seed;

    public synchronized void setSeed(long l) {
        this.seed = (l ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
        this.haveNextNextGaussian = false;
    }

    protected synchronized int next(int n) {
        this.seed = this.seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(this.seed >>> 48 - n);
    }

    public void nextBytes(byte[] byArray) {
        int n;
        int n2 = byArray.length & 0xFFFFFFFC;
        int n3 = 0;
        while (n3 < n2) {
            n = this.next(32);
            byArray[n3] = (byte)n;
            byArray[n3 + 1] = (byte)(n >> 8);
            byArray[n3 + 2] = (byte)(n >> 16);
            byArray[n3 + 3] = (byte)(n >> 24);
            n3 += 4;
        }
        if (n2 < byArray.length) {
            n = this.next(32);
            n3 = n2;
            while (n3 < byArray.length) {
                byArray[n3] = (byte)n;
                n >>= 8;
                ++n3;
            }
        }
    }

    public int nextInt() {
        return this.next(32);
    }

    public int nextInt(int n) {
        int n2;
        int n3;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        if ((n & -n) == n) {
            return (int)((long)n * (long)this.next(31) >> 31);
        }
        while ((n3 = this.next(31)) - (n2 = n3 % n) + (n - 1) < 0) {
        }
        return n2;
    }

    public long nextLong() {
        return ((long)this.next(32) << 32) + (long)this.next(32);
    }

    public boolean nextBoolean() {
        boolean bl = false;
        if (this.next(1) != 0) {
            bl = true;
        }
        return bl;
    }

    public float nextFloat() {
        return (float)this.next(24) / 1.6777216E7f;
    }

    public double nextDouble() {
        return (double)(((long)this.next(26) << 27) + (long)this.next(27)) / 9.007199254740992E15;
    }

    public synchronized double nextGaussian() {
        double d;
        double d2;
        double d3;
        if (this.haveNextNextGaussian) {
            this.haveNextNextGaussian = false;
            return this.nextNextGaussian;
        }
        while ((d3 = (d2 = (double)2 * this.nextDouble() - 1.0) * d2 + (d = (double)2 * this.nextDouble() - 1.0) * d) >= 1.0) {
        }
        double d4 = Math.sqrt(-2.0 * Math.log(d3) / d3);
        this.nextNextGaussian = d * d4;
        this.haveNextNextGaussian = true;
        return d2 * d4;
    }

    public Random() {
        this(System.currentTimeMillis());
    }

    public Random(long l) {
        this.setSeed(l);
    }
}

