/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import org.wiztools.commons.StringUtil;
import org.wiztools.restclient.Base64Exception;
import org.wiztools.restclient.ServiceLocator;
import org.wiztools.restclient.ui.EscapableDialog;
import org.wiztools.restclient.ui.RESTMain;
import org.wiztools.restclient.ui.RESTUserInterface;
import org.wiztools.restclient.util.Util;

class PasswordGenDialog
extends EscapableDialog {
    private static final String helpText;
    private JRadioButton jrb_encode = new JRadioButton("Encode");
    private JRadioButton jrb_decode = new JRadioButton("Decode");
    private JTextField jtf_in = new JTextField(25);
    private JTextField jtf_out = new JTextField(25);
    private final PasswordGenDialog me = this;

    public PasswordGenDialog() {
        super((Frame)ServiceLocator.getInstance(RESTUserInterface.class).getFrame(), true);
        this.setTitle("Password Encoder/Decoder");
        this.init();
    }

    private void init() {
        ButtonGroup bg = new ButtonGroup();
        this.jrb_encode.setMnemonic('e');
        this.jrb_encode.setSelected(true);
        this.jrb_decode.setMnemonic('d');
        bg.add(this.jrb_encode);
        bg.add(this.jrb_decode);
        this.jtf_out.setEditable(false);
        ActionListener closeAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PasswordGenDialog.this.me.setVisible(false);
            }
        };
        JPanel jp = new JPanel();
        jp.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jp.setLayout(new BorderLayout());
        JPanel jp_north = new JPanel();
        jp_north.setLayout(new FlowLayout(1));
        jp_north.add(this.jrb_encode);
        jp_north.add(this.jrb_decode);
        jp.add((Component)jp_north, "North");
        JPanel jp_center = new JPanel();
        jp_center.setLayout(new BorderLayout());
        JPanel jp_center_west = new JPanel();
        jp_center_west.setLayout(new GridLayout(2, 1, 5, 5));
        JLabel jl_in = new JLabel("Input: ");
        jl_in.setDisplayedMnemonic('i');
        jl_in.setLabelFor(this.jtf_in);
        JLabel jl_out = new JLabel("Output: ");
        jp_center_west.add(jl_in);
        jp_center_west.add(jl_out);
        jp_center.add((Component)jp_center_west, "West");
        JPanel jp_center_center = new JPanel();
        jp_center_center.setLayout(new GridLayout(2, 1, 5, 5));
        jp_center_center.add(this.jtf_in);
        jp_center_center.add(this.jtf_out);
        jp_center.add((Component)jp_center_center, "Center");
        jp.add((Component)jp_center, "Center");
        JPanel jp_south = new JPanel();
        jp_south.setLayout(new FlowLayout(1));
        JButton jb_generate = new JButton("Generate");
        jb_generate.setMnemonic('g');
        this.getRootPane().setDefaultButton(jb_generate);
        jb_generate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PasswordGenDialog.this.generate();
            }
        });
        jp_south.add(jb_generate);
        JButton jb_gen_close = new JButton("Close");
        jb_gen_close.addActionListener(closeAction);
        jp_south.add(jb_gen_close);
        jp.add((Component)jp_south, "South");
        JPanel jp_help = new JPanel();
        jp_help.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jp_help.setLayout(new BorderLayout());
        JTextPane jtp_help_center = new JTextPane();
        jtp_help_center.setEditable(false);
        Dimension d = jtp_help_center.getPreferredSize();
        jtp_help_center.setText(helpText);
        jtp_help_center.setPreferredSize(d);
        jtp_help_center.setCaretPosition(0);
        JScrollPane jsp_center = new JScrollPane(jtp_help_center);
        jp_help.add((Component)jsp_center, "Center");
        JPanel jp_help_south = new JPanel();
        jp_help_south.setLayout(new FlowLayout(1));
        JButton jb_close = new JButton("Close");
        jb_close.addActionListener(closeAction);
        jp_help_south.add(jb_close);
        jp_help.add((Component)jp_help_south, "South");
        JTabbedPane jtp = new JTabbedPane();
        jtp.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jtp.addTab("Encoder/Decoder", jp);
        jtp.addTab("Help", jp_help);
        this.setContentPane(jtp);
        this.pack();
    }

    private void generate() {
        String result;
        String inStr = this.jtf_in.getText();
        if (StringUtil.isEmpty(inStr)) {
            JOptionPane.showMessageDialog(this.me, "No input entered.", "Error in input.", 0);
            return;
        }
        if (this.jrb_encode.isSelected()) {
            result = Util.base64encode(inStr);
        } else {
            try {
                result = Util.base64decode(inStr);
            }
            catch (Base64Exception ex) {
                JOptionPane.showMessageDialog(this.me, ex.getMessage(), "Error in input.", 0);
                return;
            }
        }
        this.jtf_out.setText(result);
    }

    @Override
    public void doEscape(AWTEvent event) {
        this.me.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String tmp = null;
        InputStream is = RESTMain.class.getClassLoader().getResourceAsStream("org/wiztools/restclient/PasswordHelp.txt");
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        try {
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            tmp = sb.toString();
        }
        catch (IOException ex) {
            tmp = "Help loading failed.";
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        helpText = tmp;
    }
}

