/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.reqmethod;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.wiztools.restclient.bean.HTTPMethod;
import org.wiztools.restclient.ui.RESTView;
import org.wiztools.restclient.ui.reqmethod.ReqMethodPanel;

public class ReqMethodPanelImpl
extends JPanel
implements ReqMethodPanel {
    @Inject
    RESTView view;
    private final JRadioButton jrb_req_get = new JRadioButton("GET");
    private final JRadioButton jrb_req_post = new JRadioButton("POST");
    private final JRadioButton jrb_req_put = new JRadioButton("PUT");
    private final JRadioButton jrb_req_patch = new JRadioButton("PATCH");
    private final JRadioButton jrb_req_delete = new JRadioButton("DELETE");
    private final JRadioButton jrb_req_head = new JRadioButton("HEAD");
    private final JRadioButton jrb_req_options = new JRadioButton("OPTIONS");
    private final JRadioButton jrb_req_trace = new JRadioButton("TRACE");
    private final JRadioButton jrb_req_custom = new JRadioButton("Custom:");
    private final JTextField jtf_custom = new JTextField(10);

    @Override
    public boolean doesSelectedMethodSupportEntityBody() {
        return this.jrb_req_get.isSelected() || this.jrb_req_post.isSelected() || this.jrb_req_put.isSelected() || this.jrb_req_patch.isSelected() || this.jrb_req_delete.isSelected() || this.jrb_req_custom.isSelected();
    }

    @Override
    public HTTPMethod getSelectedMethod() {
        if (this.jrb_req_get.isSelected()) {
            return HTTPMethod.GET;
        }
        if (this.jrb_req_head.isSelected()) {
            return HTTPMethod.HEAD;
        }
        if (this.jrb_req_post.isSelected()) {
            return HTTPMethod.POST;
        }
        if (this.jrb_req_put.isSelected()) {
            return HTTPMethod.PUT;
        }
        if (this.jrb_req_patch.isSelected()) {
            return HTTPMethod.PATCH;
        }
        if (this.jrb_req_delete.isSelected()) {
            return HTTPMethod.DELETE;
        }
        if (this.jrb_req_options.isSelected()) {
            return HTTPMethod.OPTIONS;
        }
        if (this.jrb_req_trace.isSelected()) {
            return HTTPMethod.TRACE;
        }
        if (this.jrb_req_custom.isSelected()) {
            return HTTPMethod.get(this.jtf_custom.getText());
        }
        throw new RuntimeException("Will NEVER come here!");
    }

    @Override
    public void setSelectedMethod(HTTPMethod method) {
        switch (method.name()) {
            case "GET": {
                this.jrb_req_get.setSelected(true);
                break;
            }
            case "HEAD": {
                this.jrb_req_head.setSelected(true);
                break;
            }
            case "POST": {
                this.jrb_req_post.setSelected(true);
                break;
            }
            case "PUT": {
                this.jrb_req_put.setSelected(true);
                break;
            }
            case "PATCH": {
                this.jrb_req_patch.setSelected(true);
                break;
            }
            case "DELETE": {
                this.jrb_req_delete.setSelected(true);
                break;
            }
            case "OPTIONS": {
                this.jrb_req_options.setSelected(true);
                break;
            }
            case "TRACE": {
                this.jrb_req_trace.setSelected(true);
                break;
            }
            default: {
                this.jrb_req_custom.setSelected(true);
                this.jtf_custom.setText(method.name());
                this.jtf_custom.setEnabled(true);
            }
        }
    }

    @PostConstruct
    protected void init() {
        this.jtf_custom.setEnabled(false);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.jrb_req_get);
        bg.add(this.jrb_req_post);
        bg.add(this.jrb_req_put);
        bg.add(this.jrb_req_patch);
        bg.add(this.jrb_req_delete);
        bg.add(this.jrb_req_head);
        bg.add(this.jrb_req_options);
        bg.add(this.jrb_req_trace);
        bg.add(this.jrb_req_custom);
        this.jrb_req_get.setSelected(true);
        this.jrb_req_get.setMnemonic('g');
        this.jrb_req_post.setMnemonic('p');
        this.jrb_req_put.setMnemonic('t');
        this.jrb_req_delete.setMnemonic('d');
        ActionListener jrbAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (ReqMethodPanelImpl.this.doesSelectedMethodSupportEntityBody()) {
                    ReqMethodPanelImpl.this.view.enableBody();
                } else {
                    ReqMethodPanelImpl.this.view.disableBody();
                }
                if (ReqMethodPanelImpl.this.jrb_req_custom.isSelected()) {
                    ReqMethodPanelImpl.this.jtf_custom.setEnabled(true);
                    ReqMethodPanelImpl.this.jtf_custom.requestFocus();
                } else {
                    ReqMethodPanelImpl.this.jtf_custom.setEnabled(false);
                }
            }
        };
        this.jrb_req_get.addActionListener(jrbAL);
        this.jrb_req_post.addActionListener(jrbAL);
        this.jrb_req_put.addActionListener(jrbAL);
        this.jrb_req_patch.addActionListener(jrbAL);
        this.jrb_req_delete.addActionListener(jrbAL);
        this.jrb_req_head.addActionListener(jrbAL);
        this.jrb_req_options.addActionListener(jrbAL);
        this.jrb_req_trace.addActionListener(jrbAL);
        this.jrb_req_custom.addActionListener(jrbAL);
        JPanel jp_method = new JPanel();
        jp_method.setBorder(BorderFactory.createTitledBorder("HTTP Method"));
        jp_method.setLayout(new GridLayout(5, 2));
        jp_method.add(this.jrb_req_get);
        jp_method.add(this.jrb_req_post);
        jp_method.add(this.jrb_req_put);
        jp_method.add(this.jrb_req_patch);
        jp_method.add(this.jrb_req_delete);
        jp_method.add(this.jrb_req_head);
        jp_method.add(this.jrb_req_options);
        jp_method.add(this.jrb_req_trace);
        jp_method.add(this.jrb_req_custom);
        jp_method.add(this.jtf_custom);
        this.setLayout(new FlowLayout(0));
        this.add(jp_method);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void clear() {
        this.jtf_custom.setText("");
        this.jtf_custom.setEnabled(false);
        this.jrb_req_get.setSelected(true);
    }
}

