/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class AffineTransform
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1330973210523860834L;
    public static final int TYPE_IDENTITY = 0;
    public static final int TYPE_TRANSLATION = 1;
    public static final int TYPE_UNIFORM_SCALE = 2;
    public static final int TYPE_GENERAL_SCALE = 4;
    public static final int TYPE_MASK_SCALE = 6;
    public static final int TYPE_FLIP = 64;
    public static final int TYPE_QUADRANT_ROTATION = 8;
    public static final int TYPE_GENERAL_ROTATION = 16;
    public static final int TYPE_MASK_ROTATION = 24;
    public static final int TYPE_GENERAL_TRANSFORM = 32;
    private double m00;
    private double m10;
    private double m01;
    private double m11;
    private double m02;
    private double m12;
    private transient int type;

    public static AffineTransform getTranslateInstance(double tx, double ty) {
        AffineTransform t = new AffineTransform();
        t.setToTranslation(tx, ty);
        return t;
    }

    public static AffineTransform getRotateInstance(double theta) {
        AffineTransform t = new AffineTransform();
        t.setToRotation(theta);
        return t;
    }

    public static AffineTransform getRotateInstance(double theta, double x, double y) {
        AffineTransform t = new AffineTransform();
        t.setToTranslation(x, y);
        t.rotate(theta);
        t.translate(-x, -y);
        return t;
    }

    public static AffineTransform getScaleInstance(double sx, double sy) {
        AffineTransform t = new AffineTransform();
        t.setToScale(sx, sy);
        return t;
    }

    public static AffineTransform getShearInstance(double shx, double shy) {
        AffineTransform t = new AffineTransform();
        t.setToShear(shx, shy);
        return t;
    }

    public int getType() {
        return this.type;
    }

    public double getDeterminant() {
        return this.m00 * this.m11 - this.m01 * this.m10;
    }

    public void getMatrix(double[] d) {
        d[0] = this.m00;
        d[1] = this.m10;
        d[2] = this.m01;
        d[3] = this.m11;
        if (d.length >= 6) {
            d[4] = this.m02;
            d[5] = this.m12;
        }
    }

    public double getScaleX() {
        return this.m00;
    }

    public double getScaleY() {
        return this.m11;
    }

    public double getShearX() {
        return this.m01;
    }

    public double getShearY() {
        return this.m10;
    }

    public double getTranslateX() {
        return this.m02;
    }

    public double getTranslateY() {
        return this.m12;
    }

    public void translate(double tx, double ty) {
        this.m02 += tx * this.m00 + ty * this.m01;
        this.m12 += tx * this.m10 + ty * this.m11;
        this.updateType();
    }

    public void rotate(double theta) {
        double c = Math.cos(theta);
        double s = Math.sin(theta);
        double n00 = this.m00 * c + this.m01 * s;
        double n01 = this.m00 * -s + this.m01 * c;
        double n10 = this.m10 * c + this.m11 * s;
        double n11 = this.m10 * -s + this.m11 * c;
        this.m00 = n00;
        this.m01 = n01;
        this.m10 = n10;
        this.m11 = n11;
        this.updateType();
    }

    public void rotate(double theta, double x, double y) {
        this.translate(x, y);
        this.rotate(theta);
        this.translate(-x, -y);
    }

    public void scale(double sx, double sy) {
        this.m00 *= sx;
        this.m01 *= sy;
        this.m10 *= sx;
        this.m11 *= sy;
        this.updateType();
    }

    public void shear(double shx, double shy) {
        double n00 = this.m00 + shy * this.m01;
        double n01 = this.m01 + shx * this.m00;
        double n10 = this.m10 + shy * this.m11;
        double n11 = this.m11 + shx * this.m10;
        this.m00 = n00;
        this.m01 = n01;
        this.m10 = n10;
        this.m11 = n11;
        this.updateType();
    }

    public void setToIdentity() {
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m12 = 0.0;
        this.m10 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
        this.type = 0;
    }

    public void setToTranslation(double tx, double ty) {
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m10 = 0.0;
        this.m01 = 0.0;
        this.m02 = tx;
        this.m12 = ty;
        int n = 0;
        if (tx == 0.0 && ty == 0.0) {
            n = 1;
        }
        this.type = n + 1;
    }

    public void setToRotation(double theta) {
        double c = Math.cos(theta);
        double s = Math.sin(theta);
        this.m00 = c;
        this.m01 = -s;
        this.m02 = 0.0;
        this.m10 = s;
        this.m11 = c;
        this.m12 = 0.0;
        int n = 0;
        if (c != 1.0) {
            n = c == 0.0 || c == -1.0 ? 8 : 16;
        }
        this.type = n;
    }

    public void setToRotation(double theta, double x, double y) {
        double c = Math.cos(theta);
        double s = Math.sin(theta);
        this.m00 = c;
        this.m01 = -s;
        this.m02 = x - x * c + y * s;
        this.m10 = s;
        this.m11 = c;
        this.m12 = y - x * s - y * c;
        this.updateType();
    }

    public void setToScale(double sx, double sy) {
        this.m00 = sx;
        this.m12 = 0.0;
        this.m10 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
        this.m11 = sy;
        this.type = sx != sy ? 4 : (sx == 1.0 ? 0 : 2);
    }

    public void setToShear(double shx, double shy) {
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m01 = shx;
        this.m10 = shy;
        this.m12 = 0.0;
        this.m02 = 0.0;
        this.updateType();
    }

    public void setTransform(AffineTransform tx) {
        this.m00 = tx.m00;
        this.m01 = tx.m01;
        this.m02 = tx.m02;
        this.m10 = tx.m10;
        this.m11 = tx.m11;
        this.m12 = tx.m12;
        this.type = tx.type;
    }

    public void setTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        this.m00 = m00;
        this.m10 = m10;
        this.m01 = m01;
        this.m11 = m11;
        this.m02 = m02;
        this.m12 = m12;
        this.updateType();
    }

    public void concatenate(AffineTransform tx) {
        double n00 = this.m00 * tx.m00 + this.m01 * tx.m10;
        double n01 = this.m00 * tx.m01 + this.m01 * tx.m11;
        double n02 = this.m00 * tx.m02 + this.m01 * tx.m12 + this.m02;
        double n10 = this.m10 * tx.m00 + this.m11 * tx.m10;
        double n11 = this.m10 * tx.m01 + this.m11 * tx.m11;
        double n12 = this.m10 * tx.m02 + this.m11 * tx.m12 + this.m12;
        this.m00 = n00;
        this.m01 = n01;
        this.m02 = n02;
        this.m10 = n10;
        this.m11 = n11;
        this.m12 = n12;
        this.updateType();
    }

    public void preConcatenate(AffineTransform tx) {
        double n00 = tx.m00 * this.m00 + tx.m01 * this.m10;
        double n01 = tx.m00 * this.m01 + tx.m01 * this.m11;
        double n02 = tx.m00 * this.m02 + tx.m01 * this.m12 + tx.m02;
        double n10 = tx.m10 * this.m00 + tx.m11 * this.m10;
        double n11 = tx.m10 * this.m01 + tx.m11 * this.m11;
        double n12 = tx.m10 * this.m02 + tx.m11 * this.m12 + tx.m12;
        this.m00 = n00;
        this.m01 = n01;
        this.m02 = n02;
        this.m10 = n10;
        this.m11 = n11;
        this.m12 = n12;
        this.updateType();
    }

    public AffineTransform createInverse() throws NoninvertibleTransformException {
        double det = this.getDeterminant();
        if (det == 0.0) {
            throw new NoninvertibleTransformException("can't invert transform");
        }
        double im00 = this.m11 / det;
        double im10 = -this.m10 / det;
        double im01 = -this.m01 / det;
        double im11 = this.m00 / det;
        double im02 = (this.m01 * this.m12 - this.m02 * this.m11) / det;
        double im12 = (-this.m00 * this.m12 + this.m10 * this.m02) / det;
        return new AffineTransform(im00, im10, im01, im11, im02, im12);
    }

    public Point2D transform(Point2D src, Point2D dst) {
        if (dst == null) {
            dst = new Point2D.Double();
        }
        double x = src.getX();
        double y = src.getY();
        double nx = this.m00 * x + this.m01 * y + this.m02;
        double ny = this.m10 * x + this.m11 * y + this.m12;
        dst.setLocation(nx, ny);
        return dst;
    }

    public void transform(Point2D[] src, int srcOff, Point2D[] dst, int dstOff, int num) {
        while (--num >= 0) {
            dst[dstOff] = this.transform(src[srcOff++], dst[dstOff++]);
        }
    }

    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int num) {
        if (srcPts == dstPts && dstOff > srcOff && num > 1 && srcOff + 2 * num > dstOff) {
            float[] f = new float[2 * num];
            System.arraycopy(srcPts, srcOff, f, 0, 2 * num);
            srcPts = f;
        }
        while (--num >= 0) {
            float x = srcPts[srcOff++];
            float y = srcPts[srcOff++];
            dstPts[dstOff++] = (float)(this.m00 * (double)x + this.m01 * (double)y + this.m02);
            dstPts[dstOff++] = (float)(this.m10 * (double)x + this.m11 * (double)y + this.m12);
        }
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int num) {
        if (srcPts == dstPts && dstOff > srcOff && num > 1 && srcOff + 2 * num > dstOff) {
            double[] d = new double[2 * num];
            System.arraycopy(srcPts, srcOff, d, 0, 2 * num);
            srcPts = d;
        }
        while (--num >= 0) {
            double x = srcPts[srcOff++];
            double y = srcPts[srcOff++];
            dstPts[dstOff++] = this.m00 * x + this.m01 * y + this.m02;
            dstPts[dstOff++] = this.m10 * x + this.m11 * y + this.m12;
        }
    }

    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int num) {
        while (--num >= 0) {
            float x = srcPts[srcOff++];
            float y = srcPts[srcOff++];
            dstPts[dstOff++] = this.m00 * (double)x + this.m01 * (double)y + this.m02;
            dstPts[dstOff++] = this.m10 * (double)x + this.m11 * (double)y + this.m12;
        }
    }

    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int num) {
        while (--num >= 0) {
            double x = srcPts[srcOff++];
            double y = srcPts[srcOff++];
            dstPts[dstOff++] = (float)(this.m00 * x + this.m01 * y + this.m02);
            dstPts[dstOff++] = (float)(this.m10 * x + this.m11 * y + this.m12);
        }
    }

    public Point2D inverseTransform(Point2D src, Point2D dst) throws NoninvertibleTransformException {
        return this.createInverse().transform(src, dst);
    }

    public void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int num) throws NoninvertibleTransformException {
        this.createInverse().transform(srcPts, srcOff, dstPts, dstOff, num);
    }

    public Point2D deltaTransform(Point2D src, Point2D dst) {
        if (dst == null) {
            dst = new Point2D.Double();
        }
        double x = src.getX();
        double y = src.getY();
        double nx = this.m00 * x + this.m01 * y;
        double ny = this.m10 * x + this.m11 * y;
        dst.setLocation(nx, ny);
        return dst;
    }

    public void deltaTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int num) {
        if (srcPts == dstPts && dstOff > srcOff && num > 1 && srcOff + 2 * num > dstOff) {
            double[] d = new double[2 * num];
            System.arraycopy(srcPts, srcOff, d, 0, 2 * num);
            srcPts = d;
        }
        while (--num >= 0) {
            double x = srcPts[srcOff++];
            double y = srcPts[srcOff++];
            dstPts[dstOff++] = this.m00 * x + this.m01 * y;
            dstPts[dstOff++] = this.m10 * x + this.m11 * y;
        }
    }

    public Shape createTransformedShape(Shape src) {
        if (src == null) {
            return null;
        }
        GeneralPath p = new GeneralPath(src);
        p.transform(this);
        return p;
    }

    public String toString() {
        return "AffineTransform[[" + this.m00 + ", " + this.m01 + ", " + this.m02 + "], [" + this.m10 + ", " + this.m11 + ", " + this.m12 + "]]";
    }

    public boolean isIdentity() {
        boolean bl = false;
        if (this.m00 == 1.0 && this.m01 == 0.0 && this.m02 == 0.0 && this.m10 == 0.0 && this.m11 == 1.0 && this.m12 == 0.0) {
            bl = true;
        }
        return bl;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw (Error)new InternalError().initCause(e);
        }
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.m00);
        l = l * 31L + Double.doubleToLongBits(this.m10);
        l = l * 31L + Double.doubleToLongBits(this.m01);
        l = l * 31L + Double.doubleToLongBits(this.m11);
        l = l * 31L + Double.doubleToLongBits(this.m02);
        l = l * 31L + Double.doubleToLongBits(this.m12);
        return (int)(l >> 32 ^ l);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AffineTransform)) {
            return false;
        }
        AffineTransform t = (AffineTransform)obj;
        boolean bl = false;
        if (this.m00 == t.m00 && this.m01 == t.m01 && this.m02 == t.m02 && this.m10 == t.m10 && this.m11 == t.m11 && this.m12 == t.m12) {
            bl = true;
        }
        return bl;
    }

    private final void updateType() {
        double det = this.getDeterminant();
        if (det == 0.0) {
            this.type = 32;
            return;
        }
        if (this.m01 == 0.0 && this.m10 == 0.0) {
            this.type = this.m00 == this.m11 ? (this.m00 == 1.0 ? 0 : 2) : 4;
            if (this.m02 != 0.0 || this.m12 != 0.0) {
                this.type |= 1;
            }
        } else if (this.m00 == this.m11 && this.m01 == -this.m10) {
            int n = this.type = this.m00 == 0.0 ? 8 : 16;
            if (det != 1.0) {
                this.type |= 2;
            }
            if (this.m02 != 0.0 || this.m12 != 0.0) {
                this.type |= 1;
            }
        } else {
            this.type = 32;
        }
    }

    private final void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.updateType();
    }

    public AffineTransform() {
        this.m11 = 1.0;
        this.m00 = 1.0;
    }

    public AffineTransform(AffineTransform tx) {
        this.setTransform(tx);
    }

    public AffineTransform(float m00, float m10, float m01, float m11, float m02, float m12) {
        this.m00 = m00;
        this.m10 = m10;
        this.m01 = m01;
        this.m11 = m11;
        this.m02 = m02;
        this.m12 = m12;
        this.updateType();
    }

    public AffineTransform(float[] f) {
        this.m00 = f[0];
        this.m10 = f[1];
        this.m01 = f[2];
        this.m11 = f[3];
        if (f.length >= 6) {
            this.m02 = f[4];
            this.m12 = f[5];
        }
        this.updateType();
    }

    public AffineTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        this.m00 = m00;
        this.m10 = m10;
        this.m01 = m01;
        this.m11 = m11;
        this.m02 = m02;
        this.m12 = m12;
        this.updateType();
    }

    public AffineTransform(double[] d) {
        this.m00 = d[0];
        this.m10 = d[1];
        this.m01 = d[2];
        this.m11 = d[3];
        if (d.length >= 6) {
            this.m02 = d[4];
            this.m12 = d[5];
        }
        this.updateType();
    }
}

