/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractIterator<E>
implements Iterator<E> {
    protected E next;
    private boolean iterating = false;

    @Override
    public boolean hasNext() {
        if (!this.iterating) {
            this.next = this.advance();
            this.iterating = true;
        }
        return this.next != null;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        E ret = this.next;
        this.next = this.advance();
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove() not supported.");
    }

    protected abstract E advance();

    public E peek() {
        return this.next;
    }

    protected boolean isIterating() {
        return this.iterating;
    }
}

