package TDS::JConv;

use Exporter;
use strict qw(vars);
use vars qw(@ISA @EXPORT);

@ISA = qw(Exporter);
@EXPORT = qw(jconv_t2i);

use JConv;
use Skelton;

sub jconv_t2i;

sub Initialize()
{
    my ($internal, $html, $tdf);
    $internal = $TDS::System::InternalJcode;
    $html = $Skelton::OutputJcode;
    $tdf = $TDS::Collection::TdfJcode;

    # HTML 
    #*jconv_i2h = mkjconv($internal, $html);
    #  tdf 
    #*jconv_i2t = mkjconv($internal, $tdf);
    # tdf ɤ߹
    if ($tdf){
	*jconv_t2i = mkjconv($tdf, $internal);
    } else {
	*jconv_t2i = mkjconv('auto', $internal);
    }
    SetDefaultJcode($internal, $html);
}


1;
