/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.util;

import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.campagnelab.goby.alignments.processors.ObservedIndel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnownIndelSet {
    protected Object2ObjectOpenHashMap<String, Set<ObservedIndel>> indelSet;
    protected static final Logger LOG = LoggerFactory.getLogger(KnownIndelSet.class);

    public KnownIndelSet(String pathToIndelSet) throws IOException, ClassNotFoundException {
        this.indelSet = (Object2ObjectOpenHashMap)BinIO.loadObject((CharSequence)pathToIndelSet);
    }

    public KnownIndelSet() {
        this.indelSet = new Object2ObjectOpenHashMap(40);
    }

    public void addIndel(String chrom, ObservedIndel knownIndel) {
        if (!this.indelSet.containsKey((Object)chrom)) {
            this.indelSet.put((Object)chrom, (Object)new ObjectOpenHashSet(50000));
        }
        ((Set)this.indelSet.get((Object)chrom)).add(knownIndel);
    }

    public Set<ObservedIndel> getAllIndelsInChrom(String chrom) {
        return (Set)this.indelSet.get((Object)chrom);
    }

    public void saveSet(String pathToSet) throws IOException {
        BinIO.storeObject(this.indelSet, (File)new File(pathToSet));
    }
}

