package TDS::Push2Antenna;
# $Id: Push2Antenna.pm,v 1.2 2000/11/26 19:39:46 tom Exp $
################################################################

use strict;
use vars qw(@ISA);

use ObjectTemplate;
use DateTime::Format;
use CGI::Tools;


@ISA = qw(ObjectTemplate);

attributes qw(antennas);

################################################################

sub initialize($)
{
    my $self = shift;

    $self->antennas([]) unless ref $self->antennas;

    $self->SUPER::initialize;
}
sub Push($$)
{
    my ($self, $last_modified) = @_;

#    warn "push";
    
    for (@{$self->antennas}){                # push to antenna
	my $antenna_re = $_ . "re.cgi";
#	warn "update report to $antenna_re";
	
	# set lirs
	require Lirs;
	
	my $lirs = new Lirs;
	$lirs->Set('Url', TDS::IdentInfo->Get('Url'));
	$lirs->Set('Title', TDS::IdentInfo->Get('Title'));
	$lirs->Set('Author-Name', TDS::IdentInfo->Get('Author'));
	$lirs->Set('Last-Modified', time2str_gen($last_modified));
	$lirs->Set('Last-Modified-Detected', time2str_gen(time()));
	
	my $content = "lirs=" . UrlEncode($lirs->AsLirs . "\r\n");
	
	# pushing
	require LWP::UserAgent;
	require HTTP::Request;
	require HTTP::Headers;
	
	my $ua = new LWP::UserAgent;
	$ua->agent(sprintf("ONEW update reporter/2.0(compatible; TDS update reporter/%s)", $TDS::Version));
	my $headers = new HTTP::Headers(Content_Type=>"application/x-www-form-urlencoded",
					Content_Length=>length($content));
	
	my $request = new HTTP::Request(POST=>$antenna_re, $headers, $content);
	my $response = $ua->request($request);
	if ($response->message eq 'OK'){
#		print $response->content;
	} else {
	    die "update reporting is failed";
	}
    }
}
1;
