# -*- coding: utf-8 -*-
# ------------------------------------------------------------------------------
# Name:         instrumentLookup.py
# Purpose:      Multi-lingual instrument translation tables
# Authors:      Jose Cabal-Ugaz
#               Mark Gotham
#
# Copyright:    Copyright © 2012-2020 Michael Scott Asato Cuthbert
# License:      BSD, see license.txt
# ------------------------------------------------------------------------------
from __future__ import annotations

import unittest

_DOC_IGNORE_MODULE_OR_PACKAGE = True

# noinspection SpellCheckingInspection
abbreviationToClassName = {
    'a sax': 'AltoSaxophone',
    'ac b': 'AcousticBass',
    'ac gtr': 'AcousticGuitar',
    'acc': 'Accordion',
    'accdn': 'Accordion',
    'arp': 'Harp',
    'b cl': 'BassClarinet',
    'b dr': 'BassDrum',
    'bag': 'Bagpipes',
    'bar': 'Baritone',
    'bar sax': 'BaritoneSaxophone',
    'bcl': 'BassClarinet',
    'bgo dr': 'BongoDrums',
    'bj': 'Banjo',
    'bjo': 'Banjo',
    'bkl': 'BassClarinet',
    'bn': 'Bassoon',
    'br': 'Viola',
    'bs': 'Bassoon',
    'bs cl': 'BassClarinet',
    'bsn': 'Bassoon',
    'bssn': 'Bassoon',
    'c bsn': 'Contrabassoon',
    'c c': 'SnareDrum',
    'cas': 'Castanets',
    'casts': 'Castanets',
    'cb': 'Contrabass',
    'cbsn': 'Contrabassoon',
    'cel': 'Celesta',
    'cga dr': 'CongaDrum',
    'ch': 'Choir',
    'cl': 'Clarinet',
    'clst': 'Celesta',
    'clv': 'Clavichord',
    'clvd': 'Clavichord',
    'cor': 'Horn',
    'cor ang': 'EnglishHorn',
    'cr tr': 'BassDrum',
    'cwb': 'Cowbell',
    'cym': 'CrashCymbals',
    'e gtr': 'ElectricGuitar',
    'e h': 'EnglishHorn',
    'e hn': 'EnglishHorn',
    'elec b': 'ElectricBass',
    'elec gtr': 'ElectricGuitar',
    'elec org': 'ElectricOrgan',
    'eng hn': 'EnglishHorn',
    'fag': 'Bassoon',
    'fg': 'Bassoon',
    'fing cym': 'FingerCymbals',
    'fl': 'Flute',
    'g c': 'BassDrum',
    'glck': 'Glockenspiel',
    'glock': 'Glockenspiel',
    'glsp': 'Glockenspiel',
    'gng': 'Gong',
    'gr cassa': 'BassDrum',
    'gsp': 'Glockenspiel',
    'hb': 'Oboe',
    'hmca': 'Harmonica',
    'hn': 'Horn',
    'hp': 'Harp',
    'hpd': 'Harpsichord',
    'hpe': 'Harp',
    'hpschd': 'Harpsichord',
    'hrp': 'Harp',
    'k dr': 'Timpani',
    'kal': 'Kalimba',
    'kas': 'Castanets',
    'kl': 'Clarinet',
    'mand': 'Mandolin',
    'mar': 'Marimba',
    'mdln': 'Mandolin',
    'mez': 'MezzoSoprano',
    'mezz': 'MezzoSoprano',
    'mz': 'MezzoSoprano',
    'ob': 'Oboe',
    'oc': 'Ocarina',
    'p fl': 'PanFlute',
    'p org': 'PipeOrgan',
    'pf': 'Piano',
    'pfte': 'Piano',
    'pic': 'Piccolo',
    'picc': 'Piccolo',
    'pk': 'Timpani',
    'pno': 'Piano',
    'rec': 'Recorder',
    's': 'Soprano',
    's sax': 'SopranoSaxophone',
    'sand bl': 'SandpaperBlocks',
    'sax': 'Saxophone',
    'sax a': 'AltoSaxophone',
    'shk fl': 'Shakuhachi',
    'shn': 'Shehnai',
    'sit': 'Sitar',
    'sn dr': 'SnareDrum',
    'st dr': 'SteelDrum',
    't': 'Tenor',
    't sax': 'TenorSaxophone',
    'tamb': 'Tambourine',
    'tamtam': 'Gong',
    'tb': 'Tuba',
    'tba': 'Tuba',
    'tbe': 'Trumpet',
    'tbni': 'Trombone',
    'temp bl': 'TempleBlock',
    'ten dr': 'TenorDrum',
    'tim': 'Timbales',
    'timp': 'Timpani',
    'tmbn': 'Tambourine',
    'tpt': 'Trumpet',
    'tr': 'Trumpet',
    'trb': 'Trombone',
    'trgl': 'Triangle',
    'tri': 'Triangle',
    'uke': 'Ukulele',
    'v': 'Vocalist',
    'va': 'Viola',
    'vc': 'Violoncello',
    'vcelle': 'Violoncello',
    'vcl': 'Violoncello',
    'vib': 'Vibraphone',
    'vibes': 'Vibraphone',
    'vibr': 'Vibraphone',
    'vio': 'Violin',
    'vl': 'Violin',
    'vla': 'Viola',
    'vlc': 'Violoncello',
    'vln': 'Violin',
    'vlon': 'Violin',
    'vn': 'Violin',
    'vni': 'Violin',
    'voc': 'Vocalist',
    'wd bl': 'Woodblock',
    'whs': 'Whistle',
    'windmachine': 'WindMachine',
    'xil': 'Xylophone',
    'xyl': 'Xylophone',
}

# noinspection SpellCheckingInspection
englishToClassName = {
    'accordion': 'Accordion',
    'acoustic bass': 'AcousticBass',
    'acoustic guitar': 'AcousticGuitar',
    'agogo': 'Agogo',
    'alto': 'Alto',
    'alto saxophone': 'AltoSaxophone',
    'bagpipe': 'Bagpipes',
    'bagpipes': 'Bagpipes',
    'banjo': 'Banjo',
    'baritone': 'Baritone',
    'baritone saxophone': 'BaritoneSaxophone',
    'bass': 'Bass',
    'bass clarinet': 'BassClarinet',
    'bass drum': 'BassDrum',
    'bass trombone': 'BassTrombone',
    'bassoon': 'Bassoon',
    'bassoons': 'Bassoon',
    'bell lira': 'Glockenspiel',
    'bell lyre': 'Glockenspiel',
    'bongo drums': 'BongoDrums',
    'brass instrument': 'BrassInstrument',
    'bullseye gong': 'TamTam',
    'castanets': 'Castanets',
    'celesta': 'Celesta',
    'celeste': 'Celesta',
    'cello': 'Violoncello',
    'cellos': 'Violoncello',
    'chau gong': 'TamTam',
    'chimes': 'Glockenspiel',
    'choir': 'Choir',
    'church bells': 'ChurchBells',
    'clarinet': 'Clarinet',
    'clarinets': 'Clarinet',
    'clavichord': 'Clavichord',
    'conductor': 'Conductor',
    'conga drum': 'CongaDrum',
    'contrabass': 'Contrabass',
    'contrabasses': 'Contrabass',
    'contrabassoon': 'Contrabassoon',
    'contrabassoons': 'Contrabassoon',
    'cor anglais': 'EnglishHorn',
    'cowbells': 'Cowbell',
    'crash cymbals': 'CrashCymbals',
    'cymbals': 'Cymbals',
    'double bass': 'Contrabass',
    'double basses': 'Contrabass',
    'dulcimer': 'Dulcimer',
    'electric bass': 'ElectricBass',
    'electric guitar': 'ElectricGuitar',
    'electric organ': 'ElectricOrgan',
    'electric piano': 'ElectricPiano',
    'english horn': 'EnglishHorn',
    'english horns': 'EnglishHorn',
    'finger cymbals': 'FingerCymbals',
    'flute': 'Flute',
    'flutes': 'Flute',
    'french horn': 'Horn',
    'french horns': 'Horn',
    'fretless bass': 'FretlessBass',
    'glockenspiel': 'Glockenspiel',
    'gong': 'Gong',
    'guitar': 'AcousticGuitar',
    'handbells': 'Handbells',
    'harmonica': 'Harmonica',
    'harp': 'Harp',
    'harps': 'Harp',
    'harpsichord': 'Harpsichord',
    'hi-hat': 'HiHatCymbal',
    'hi-hat cymbal': 'HiHatCymbal',
    'horn': 'Horn',
    'horns': 'Horn',
    'jingle bells': 'SleighBells',
    'kalimba': 'Kalimba',
    'kettle drums': 'Timpani',
    'keyboard instrument': 'KeyboardInstrument',
    'koto': 'Koto',
    'lute': 'Lute',
    'mandolin': 'Mandolin',
    'maracas': 'Maracas',
    'marimba': 'Marimba',
    'marine': 'Tambourine',
    'mezzo-soprano': 'MezzoSoprano',
    'mouth organ': 'Harmonica',
    'oboe': 'Oboe',
    'oboes': 'Oboe',
    'ocarina': 'Ocarina',
    'octave flute': 'Piccolo',
    'orchestra bells': 'Glockenspiel',
    'organ': 'Organ',
    'pailas criollas': 'Timbales',
    'pan': 'SteelDrum',
    'pan flute': 'PanFlute',
    'pan pipe': 'PanFlute',
    'panflute': 'PanFlute',
    'panpipes': 'PanFlute',
    'percussion': 'Percussion',
    'percussion instrument': 'Percussion',
    'piano': 'Piano',
    'pianoforte': 'Piano',
    'piccolo': 'Piccolo',
    'pipe organ': 'PipeOrgan',
    'pitched percussion': 'PitchedPercussion',
    'ratchet': 'Ratchet',
    'rattle': 'Ratchet',
    'recorder': 'Recorder',
    'reed organ': 'ReedOrgan',
    'ride cymbals': 'RideCymbals',
    'sampler': 'Sampler',
    'sandpaper blocks': 'SandpaperBlocks',
    'saxophone': 'Saxophone',
    'saxophones': 'Saxophone',
    'shakuhachi': 'Shakuhachi',
    'shamisen': 'Shamisen',
    'shehnai': 'Shehnai',
    'siren': 'Siren',
    'sitar': 'Sitar',
    'sizzle cymbal': 'SizzleCymbal',
    'slapstick': 'Whip',
    'sleigh bells': 'SleighBells',
    'snare drum': 'SnareDrum',
    'sock cymbal': 'HiHatCymbal',
    'soprano': 'Soprano',
    'soprano saxophone': 'SopranoSaxophone',
    'sopranos': 'Soprano',
    'splash cymbals': 'SplashCymbals',
    'steel drum': 'SteelDrum',
    'steel drums': 'SteelDrum',
    'steel pan': 'SteelDrum',
    'steel pans': 'SteelDrum',
    'string instrument': 'StringInstrument',
    'strings': 'StringInstrument',
    'suspended cymbal': 'SuspendedCymbal',
    'taiko': 'Taiko',
    'tam-tam': 'TamTam',
    'tambourine': 'Tambourine',
    'temple block': 'TempleBlock',
    'tenor': 'Tenor',
    'tenor drum': 'TenorDrum',
    'tenor saxophone': 'TenorSaxophone',
    'timbales': 'Timbales',
    'timpani': 'Timpani',
    'tom-tom': 'TomTom',
    'transverse flute': 'Flute',
    'triangle': 'Triangle',
    'trombone': 'Trombone',
    'trombones': 'Trombone',
    'trumpet': 'Trumpet',
    'trumpets': 'Trumpet',
    'tuba': 'Tuba',
    'tubas': 'Tuba',
    'tubular bells': 'TubularBells',
    'tumbadora': 'CongaDrum',
    'turkish drum': 'BassDrum',
    'ukelele': 'Ukulele',
    'ukulele': 'Ukulele',
    'unpitched percussion': 'UnpitchedPercussion',
    'vibraharp': 'Vibraphone',
    'vibraphone': 'Vibraphone',
    'vibraslap': 'Vibraslap',
    'viola': 'Viola',
    'violas': 'Viola',
    'violin': 'Violin',
    'violins': 'Violin',
    'violoncello': 'Violoncello',
    'violoncellos': 'Violoncello',
    'voice': 'Vocalist',
    'whip': 'Whip',
    'whistle': 'Whistle',
    'wind instrument': 'WoodwindInstrument',
    'wind machine': 'WindMachine',
    'woodblock': 'Woodblock',
    'woodwind instrument': 'WoodwindInstrument',
    'xylophone': 'Xylophone',
    'zills': 'FingerCymbals',
    'zils': 'FingerCymbals',
}

# noinspection SpellCheckingInspection
frenchToClassName = {
    'accordéon': 'Accordion',
    'alto': 'Viola',
    'altos': 'Viola',
    'bariton': 'Baritone',
    'baryton': 'Baritone',
    'bas-dessus': 'Soprano',
    'basse': 'Bass',
    'basse acoustique': 'AcousticBass',
    'basse fretless': 'FretlessBass',
    'basse électrique': 'ElectricBass',
    'basse-trombone': 'BassTrombone',
    'basson': 'Bassoon',
    'bassons': 'Bassoon',
    'batterie': 'Percussion',
    'bloc de bois': 'Woodblock',
    'blocs de papier de verre': 'SandpaperBlocks',
    'bongos': 'BongoDrums',
    'caisse claire': 'SnareDrum',
    'caisse roulante': 'TenorDrum',
    'castagnettes': 'Castanets',
    'chant': 'Vocalist',
    'chanteur': 'Vocalist',
    'chanteuse': 'Vocalist',
    'charleston': 'HiHatCymbal',
    'claquebois': 'Xylophone',
    'clarinette': 'Clarinet',
    'clarinette basse': 'BassClarinet',
    'clarinettes': 'Clarinet',
    'clavecin': 'Harpsichord',
    'clavessin': 'Harpsichord',
    'claveçin': 'Harpsichord',
    'clavicorde': 'Clavichord',
    'cloches': 'TubularBells',
    'cloches de vache': 'Cowbell',
    'cloches tubolaires': 'TubularBells',
    'cloches tubulaires': 'TubularBells',
    'cloches à vache': 'Cowbell',
    'clochettes': 'Handbells',
    'clochettes à main': 'Handbells',
    'clochettes à mains': 'Handbells',
    'conga': 'CongaDrum',
    'contralto': 'Alto',
    'contrebasse': 'Contrabass',
    'contrebasses': 'Contrabass',
    'contrebasson': 'Contrabassoon',
    'contrebassons': 'Contrabassoon',
    'cor': 'Horn',
    'cor anglais': 'EnglishHorn',
    "cor d'harmonie": 'Horn',
    'cor français': 'Horn',
    'cordes': 'StringInstrument',
    'corne': 'Horn',
    'cornemuse': 'Bagpipes',
    'cors': 'Horn',
    'crash': 'CrashCymbals',
    'crécelle': 'Ratchet',
    'cuivres': 'BrassInstrument',
    'cymbale sur tiges': 'SizzleCymbal',
    'cymbale suspendue': 'SuspendedCymbal',
    'cymbale à pédale': 'HiHatCymbal',
    'cymbales': 'CrashCymbals',
    'cymbales digitales': 'FingerCymbals',
    'célesta': 'Celesta',
    'droite': 'Recorder',
    'eoliphone': 'WindMachine',
    'flûte': 'Flute',
    'flûte de pan': 'PanFlute',
    'flûte douce': 'Recorder',
    'flûte droite': 'Recorder',
    'flûte piccolo': 'Piccolo',
    'flûte traversière': 'Flute',
    'flûte à bec': 'Recorder',
    'flûtes': 'Flute',
    'fouet': 'Whip',
    'gencerros': 'Cowbell',
    'grande flûte': 'Flute',
    'grelots': 'SleighBells',
    'grosse caisse': 'BassDrum',
    'grésillement cymbale': 'SizzleCymbal',
    'guitare': 'AcousticGuitar',
    'guitare acoustique': 'AcousticGuitar',
    'guitare électrique': 'ElectricGuitar',
    'guitarre': 'AcousticGuitar',
    'guitarre électrique': 'ElectricGuitar',
    'harmonica de bois': 'Xylophone',
    'harpe': 'Harp',
    'harpes': 'Harp',
    'hautbois': 'Oboe',
    'hi-hat': 'HiHatCymbal',
    'instrument à cordes': 'StringInstrument',
    'instrument à percussion': 'Percussion',
    'instrument à vent': 'WoodwindInstrument',
    'instrument à vent de cuivres': 'BrassInstrument',
    'instrument à vent en bois': 'WoodwindInstrument',
    'jeu de clochettes': 'Glockenspiel',
    'jeu de timbres': 'Glockenspiel',
    'luth': 'Lute',
    'machine à vent': 'WindMachine',
    'mandoline': 'Mandolin',
    'orgue': 'Organ',
    'orgue à tuyaux': 'PipeOrgan',
    'orgue électrique': 'ElectricOrgan',
    'papier de verre': 'SandpaperBlocks',
    'petite flûte': 'Piccolo',
    'pianoforte': 'Piano',
    'rochet': 'Ratchet',
    'roseau organe': 'ReedOrgan',
    'sagates': 'FingerCymbals',
    'sagattes': 'FingerCymbals',
    'salut-chapeau cymbale': 'HiHatCymbal',
    'saxophon alto': 'AltoSaxophone',
    'saxophone alto': 'AltoSaxophone',
    'saxophone baryton': 'BaritoneSaxophone',
    'saxophone soprano': 'SopranoSaxophone',
    'saxophone ténor': 'TenorSaxophone',
    'saxophons': 'Saxophone',
    'siffler': 'Whistle',
    'sirène': 'Siren',
    'sonnailles': 'Cowbell',
    'syrinx': 'PanFlute',
    'taille': 'Tenor',
    'tambour': 'SnareDrum',
    'tambour bata': 'BassDrum',
    'tambour congo': 'CongaDrum',
    "tambour d'acier": 'SteelDrum',
    'tambour de basque': 'Tambourine',
    'tambour en acier': 'SteelDrum',
    'tambourin': 'TenorDrum',
    'tambours bongo': 'BongoDrums',
    'temple bloc': 'TempleBlock',
    'timbale': 'Timpani',
    'timbales': 'Timpani',
    'timbales créoles': 'Timbales',
    'timbales cubaines': 'Timbales',
    'timbales latines': 'Timbales',
    'tom': 'TomTom',
    'trombone': 'Trombone',
    'trombone basse': 'BassTrombone',
    'trombones': 'Trombone',
    'trompette': 'Trumpet',
    'trompettes': 'Trumpet',
    'tubas': 'Tuba',
    'tumbadora': 'CongaDrum',
    'tympanon': 'Dulcimer',
    'ténor': 'Tenor',
    'ténor tambour': 'TenorDrum',
    'ukulélé': 'Ukulele',
    'violon': 'Violin',
    'violoncelle': 'Violoncello',
    'violoncelles': 'Violoncello',
    'violons': 'Violin',
    'voix': 'Vocalist',
    'wood-bloc': 'Woodblock',
    'zill': 'FingerCymbals',
    'zills': 'FingerCymbals',
    'échelettes': 'Xylophone',
    'éoliphone': 'WindMachine',
}

# noinspection SpellCheckingInspection
germanToClassName = {
    'aeolophon': 'WindMachine',
    'akkordeon': 'Accordion',
    'akustik-bass': 'AcousticBass',
    'akustikgitarre': 'AcousticGuitar',
    'alt': 'Alto',
    'alt-saxophon': 'AltoSaxophone',
    'altgeige': 'Viola',
    'altsaxophon': 'AltoSaxophone',
    'arpicordo': 'Harpsichord',
    'bariton': 'Baritone',
    'baritonsaxophon': 'BaritoneSaxophone',
    'bass posaune': 'BassTrombone',
    'bass-drum': 'BassDrum',
    'bass-klarinette': 'BassClarinet',
    'bass-posaune': 'BassTrombone',
    'bassklarinette': 'BassClarinet',
    'bassposaune': 'BassTrombone',
    'becken': 'Cymbals',
    'becken freihängend': 'SuspendedCymbal',
    'becken gewönlich': 'CrashCymbals',
    'becken-paar': 'CrashCymbals',
    'beckflöte': 'Recorder',
    'blasinstrument': 'WoodwindInstrument',
    'blechblasinstrument': 'BrassInstrument',
    'blockflöte': 'Recorder',
    'bongo-trommeln': 'BongoDrums',
    'bongos': 'BongoDrums',
    'bratsche': 'Viola',
    'bratschen': 'Viola',
    'cello': 'Violoncello',
    'cembalo': 'Harpsichord',
    'clavicembalo': 'Harpsichord',
    'clavicimbel': 'Harpsichord',
    'conga': 'CongaDrum',
    'conga-trommel': 'CongaDrum',
    'crash-becken': 'CrashCymbals',
    'crashbecken': 'CrashCymbals',
    'dreieck': 'Triangle',
    'dudelsack': 'Bagpipes',
    'e-bass': 'ElectricBass',
    'e-gitarre': 'ElectricGuitar',
    'elektrische gitarre': 'ElectricGuitar',
    'elektrische orgel': 'ElectricOrgan',
    'elektro-gitarre': 'ElectricGuitar',
    'englisch-horn': 'EnglishHorn',
    'englischhorn': 'EnglishHorn',
    'fagott': 'Bassoon',
    'fagotte': 'Bassoon',
    'fagotten': 'Bassoon',
    'fingerzimbeln': 'FingerCymbals',
    'flöte': 'Flute',
    'flöten': 'Flute',
    'fussbecken': 'HiHatCymbal',
    'geige': 'Violin',
    'gitarre': 'AcousticGuitar',
    'glocken': 'TubularBells',
    'grosse trommel': 'BassDrum',
    'guitarre': 'AcousticGuitar',
    'h-hat becken': 'HiHatCymbal',
    'hackbrett': 'Dulcimer',
    'hallo-hat-becken': 'HiHatCymbal',
    'handglocken': 'Handbells',
    'handharmonika': 'Accordion',
    'harfe': 'Harp',
    'harfen': 'Harp',
    'harmonium': 'ReedOrgan',
    'herdenglocken': 'Cowbell',
    'hirtenflöte': 'PanFlute',
    'hoboe': 'Oboe',
    'holzblasinstrument': 'WoodwindInstrument',
    'holzblock': 'Woodblock',
    'holzklapper': 'Whip',
    'holzschnitt': 'Woodblock',
    'hängebecken': 'SuspendedCymbal',
    'hängendes becken': 'SuspendedCymbal',
    'hörner': 'Horn',
    'kastagnetten': 'Castanets',
    'kesselpauke': 'Timpani',
    'kesseltrommel': 'Timpani',
    'kielflügel': 'Harpsichord',
    'klarinette': 'Clarinet',
    'klarinetten': 'Clarinet',
    'klavichord': 'Clavichord',
    'klavier': 'Piano',
    'kleine flöte': 'Piccolo',
    'kleine trommel': 'SnareDrum',
    'knarre': 'Ratchet',
    'kontrabass': 'Contrabass',
    'kontrabässe': 'Contrabass',
    'kontrafagott': 'Contrabassoon',
    'kontrafagotte': 'Contrabassoon',
    'kuba-pauken': 'Timbales',
    'kuhglocken': 'Cowbell',
    'laute': 'Lute',
    'leinentrommel': 'SnareDrum',
    'lyra': 'Glockenspiel',
    'mandoline': 'Mandolin',
    'marimbaphon': 'Marimba',
    'marschtrommel': 'SnareDrum',
    'mezzosopran': 'MezzoSoprano',
    'mundharmonika': 'Harmonica',
    'nietenbecken': 'SizzleCymbal',
    'oboen': 'Oboe',
    'octavflöte': 'Piccolo',
    'okarina': 'Ocarina',
    'orgel': 'Organ',
    'panflöte': 'PanFlute',
    'papagenopfeife': 'PanFlute',
    'pauke': 'Timpani',
    'pauken': 'Timpani',
    'peitsche': 'Whip',
    'perkussionsinstrument': 'Percussion',
    'pfeifen': 'Whistle',
    'pfeifenorgel': 'PipeOrgan',
    'pferdeschlittenglocken': 'SleighBells',
    'pianoforte': 'Piano',
    'pickelflöte': 'Piccolo',
    'pikkolo': 'Piccolo',
    'pikkoloflöte': 'Piccolo',
    'posaune': 'Trombone',
    'posaunen': 'Trombone',
    'querflöte': 'Flute',
    'ratsche': 'Ratchet',
    'rohrenglocke': 'TubularBells',
    'rollschellen': 'SleighBells',
    'röhrenglocke': 'TubularBells',
    'röhrenglocken': 'TubularBells',
    'rührtrommel': 'TenorDrum',
    'saiteninstrument': 'StringInstrument',
    'sandblöcke': 'SandpaperBlocks',
    'sandpapier': 'SandpaperBlocks',
    'sandpapier blöcke': 'SandpaperBlocks',
    'saxophon': 'Saxophone',
    'schellen': 'SleighBells',
    'schellentrommel': 'Tambourine',
    'schlaginstrument': 'Percussion',
    'schlagzeug': 'Percussion',
    'schnabelflöte': 'Recorder',
    'schnarre': 'Ratchet',
    'schnarrtrommel': 'SnareDrum',
    'singstimme': 'Vocalist',
    'sirene': 'Siren',
    'snare-drum': 'SnareDrum',
    'sopran': 'Soprano',
    'sopran-saxophon': 'SopranoSaxophone',
    'sopransaxophon': 'SopranoSaxophone',
    'stahltrommel': 'SteelDrum',
    'steeldrum': 'SteelDrum',
    'stimme': 'Vocalist',
    'streicher': 'StringInstrument',
    'strohfiedel': 'Xylophone',
    'stromgitarre': 'ElectricGuitar',
    'ständerbecken': 'HiHatCymbal',
    'syrinx': 'PanFlute',
    'tambourin': 'Tambourine',
    'tamburin': 'Tambourine',
    'tamtam': 'TamTam',
    'tempel-block': 'TempleBlock',
    'tenor-saxophon': 'TenorSaxophone',
    'tenorsaxophon': 'TenorSaxophone',
    'tenortrommel': 'TenorDrum',
    'tom': 'TomTom',
    'tom tom': 'TomTom',
    'triangel': 'Triangle',
    'trompete': 'Trumpet',
    'trompeten': 'Trumpet',
    'tumba': 'CongaDrum',
    'türkisches hängebecken': 'SuspendedCymbal',
    'ventilhorn': 'Horn',
    'vibraphon': 'Vibraphone',
    'viehschellen': 'Cowbell',
    'viole': 'Viola',
    'violine': 'Violin',
    'violinen': 'Violin',
    'violoncell': 'Violoncello',
    'violoncelle': 'Violoncello',
    'windmaschine': 'WindMachine',
    'wirbeltrommel': 'TenorDrum',
    'xylophon': 'Xylophone',
    'ziehharmonika': 'Accordion',
}

# noinspection SpellCheckingInspection
italianToClassName = {
    'a becco': 'Recorder',
    'archi': 'StringInstrument',
    'armonica': 'Harmonica',
    'armonica a bocca': 'Harmonica',
    'arpa': 'Harp',
    'arpe': 'Harp',
    'arpicordo': 'Harpsichord',
    'baritono': 'Baritone',
    'basso': 'Bass',
    'basso elettrico': 'ElectricBass',
    'batteria': 'Percussion',
    'blocchi di carta vetrata': 'SandpaperBlocks',
    'blocco di legno': 'Woodblock',
    'blocco di legno cinese': 'Woodblock',
    'bonghi': 'BongoDrums',
    'bongos': 'BongoDrums',
    'campanacci': 'Cowbell',
    'campane': 'TubularBells',
    'campane tubolari': 'TubularBells',
    'campane tubulari': 'TubularBells',
    'campanelli': 'Glockenspiel',
    'campanelli a mano': 'Handbells',
    'campanelli da mucca': 'Cowbell',
    'campanelli di vacca': 'Cowbell',
    "canna d'organo": 'ReedOrgan',
    'canto': 'Vocalist',
    'carta vetrata': 'SandpaperBlocks',
    'cassa': 'BassDrum',
    'cassa chiara': 'SnareDrum',
    'cassa rullante': 'TenorDrum',
    'cassetina': 'Woodblock',
    'castagnette': 'Castanets',
    'celeste': 'Celesta',
    'cello': 'Violoncello',
    'cembalo': 'Harpsichord',
    'ceppi di carta vetro': 'SandpaperBlocks',
    'cestello in acciaio': 'SteelDrum',
    'charleston': 'HiHatCymbal',
    'chitarra': 'AcousticGuitar',
    'chitarra acustica': 'AcousticGuitar',
    'chitarra elettrica': 'ElectricGuitar',
    'cimbalini': 'FingerCymbals',
    'cimbalo': 'Harpsichord',
    'cinelli': 'CrashCymbals',
    'clarinetti': 'Clarinet',
    'clarinetti bassi': 'Clarinet',
    'clarinetto': 'Clarinet',
    'clarinetto basso': 'BassClarinet',
    'clarino': 'Trumpet',
    'clavicembalo': 'Harpsichord',
    'clavicordo': 'Clavichord',
    'conga': 'CongaDrum',
    'contrabassi': 'Contrabass',
    'contrabasso': 'Contrabass',
    'contrabbasso': 'Contrabass',
    'contrafagotti': 'Contrabassoon',
    'contrafagotto': 'Contrabassoon',
    'contralto': 'Alto',
    'cornamuse': 'Bagpipes',
    'corni': 'Horn',
    'corno': 'Horn',
    'corno francese': 'Horn',
    'corno inglese': 'EnglishHorn',
    'cricchetto': 'Ratchet',
    'dita piatti': 'FingerCymbals',
    'dritto': 'Recorder',
    'eolifono': 'WindMachine',
    'fagotti': 'Bassoon',
    'fagotto': 'Bassoon',
    'fisarmonica': 'Accordion',
    'fischio': 'Whistle',
    'flauti': 'Flute',
    'flauto': 'Flute',
    'flauto a becco': 'Recorder',
    'flauto di pan': 'PanFlute',
    'flauto diritto': 'Recorder',
    'flauto dolce': 'Recorder',
    'flauto dritto': 'Recorder',
    'flauto piccolo': 'Piccolo',
    'flauto traverso': 'Flute',
    'frusta': 'Whip',
    'gigelira': 'Xylophone',
    'gran cassa': 'BassDrum',
    'grancassa': 'BassDrum',
    'hi-hat': 'HiHatCymbal',
    'hi-hat piatto': 'HiHatCymbal',
    'legni': 'WoodwindInstrument',
    'liuto': 'Lute',
    'macchina del vento': 'WindMachine',
    'machina a venti': 'WindMachine',
    'mandolino': 'Mandolin',
    'metallofono': 'Glockenspiel',
    'mezzosoprano': 'MezzoSoprano',
    'nacchere': 'Castanets',
    'oboi': 'Oboe',
    'organi': 'Organ',
    'organo': 'PipeOrgan',
    'organo a canne': 'PipeOrgan',
    'organo elettrico': 'ElectricOrgan',
    'ottavino': 'Piccolo',
    'percussione': 'Percussion',
    'pianoforte': 'Piano',
    'piatti': 'CrashCymbals',
    'piatti a pedale': 'HiHatCymbal',
    'piatti di crash': 'CrashCymbals',
    'piatto chiodati': 'SizzleCymbal',
    'piatto sospeso': 'SuspendedCymbal',
    'raganella': 'Ratchet',
    'registratore': 'Recorder',
    'rullante': 'SnareDrum',
    'salterio': 'Dulcimer',
    'sassofoni': 'Saxophone',
    'sassofono': 'Saxophone',
    'sassofono alto': 'AltoSaxophone',
    'sassofono baritono': 'BaritoneSaxophone',
    'sassofono contralto': 'AltoSaxophone',
    'sassofono soprano': 'SopranoSaxophone',
    'sassofono tenore': 'TenorSaxophone',
    'sax': 'Saxophone',
    'saxofono': 'Saxophone',
    'saxofono alto': 'AltoSaxophone',
    'saxofono baritono': 'BaritoneSaxophone',
    'saxofono contralto': 'AltoSaxophone',
    'saxofono soprano': 'SopranoSaxophone',
    'saxofono tenore': 'TenorSaxophone',
    'sfrigolio piatto': 'SizzleCymbal',
    'silofono': 'Xylophone',
    'sirena': 'Siren',
    'sirena a mano': 'Siren',
    'siringa': 'PanFlute',
    'sonagli': 'SleighBells',
    'sonagliera': 'SleighBells',
    'stromento a percossa': 'Percussion',
    'stromento a fiato': 'WoodwindInstrument',
    'stromento a percussione': 'Percussion',
    'stromento archi': 'StringInstrument',
    'strumento a percossa': 'Percussion',
    'strumento a fiato': 'WoodwindInstrument',
    'strumento a percussione': 'Percussion',
    'strumento archi': 'StringInstrument',
    'tamborone': 'BassDrum',
    'tamburello': 'Tambourine',
    'tamburi bongo': 'BongoDrums',
    'tamburino': 'Tambourine',
    'tamburo basco': 'Tambourine',
    "tamburo d'acciaio": 'SteelDrum',
    'tamburo grande': 'BassDrum',
    'tamburo grosso': 'BassDrum',
    'tamburo militare': 'SnareDrum',
    'tamburo rullante': 'TenorDrum',
    'tamtam': 'TamTam',
    'tempio di blocco': 'TempleBlock',
    'tenore': 'Tenor',
    'timbales latinoamericani': 'Timbales',
    'timballi': 'Timpani',
    'timballo': 'Timpani',
    'timpanetti': 'Timbales',
    'timpano': 'Timpani',
    'triangolo': 'Triangle',
    'tromba': 'Trumpet',
    'trombe': 'Trumpet',
    'trombone': 'Trombone',
    'trombone basso': 'BassTrombone',
    'tromboni': 'Trombone',
    'tumba': 'CongaDrum',
    'tympani': 'Timpani',
    'vibrafono': 'Vibraphone',
    'viole': 'Viola',
    'violini': 'Violin',
    'violino': 'Violin',
    'violoncelli': 'Violoncello',
    'violoncello': 'Violoncello',
    'voca': 'Vocalist',
    'voce': 'Vocalist',
    'xilifono': 'Xylophone',
    'xilofono': 'Xylophone',
    'xilografia': 'Woodblock',
}

pitchFullNameToName = {
    'a': 'a',
    'a-double-flat': 'a--',
    'a-double-sharp': 'a##',
    'a-flat': 'a-',
    'a-sharp': 'a#',
    'ab': 'a-',
    'abb': 'a--',
    'b': 'b',
    'b-double-flat': 'b--',
    'b-double-sharp': 'b##',
    'b-flat': 'b-',
    'b-sharp': 'b#',
    'bb': 'b-',
    'bbb': 'b--',
    'c': 'c',
    'c-double-flat': 'c--',
    'c-double-sharp': 'c##',
    'c-flat': 'c-',
    'c-sharp': 'c#',
    'cb': 'c-',
    'cbb': 'c--',
    'd': 'd',
    'd-double-flat': 'd--',
    'd-double-sharp': 'd##',
    'd-flat': 'd-',
    'd-sharp': 'd#',
    'db': 'd-',
    'dbb': 'd--',
    'e': 'e',
    'e-double-flat': 'e--',
    'e-double-sharp': 'e##',
    'e-flat': 'e-',
    'e-sharp': 'e#',
    'eb': 'e-',
    'ebb': 'e--',
    'f': 'f',
    'f-double-flat': 'f--',
    'f-double-sharp': 'f##',
    'f-flat': 'f-',
    'f-sharp': 'f#',
    'fb': 'f-',
    'fbb': 'f--',
    'g': 'g',
    'g-double-flat': 'g--',
    'g-double-sharp': 'g##',
    'g-flat': 'g-',
    'g-sharp': 'g#',
    'gb': 'g-',
    'gbb': 'g--',
}

# noinspection SpellCheckingInspection
# TODO: Russian expert to add Cyrillic names
russianToClassName = {
    "al't": 'Alto',
    'angliiskii rozhok': 'EnglishHorn',
    'arfa': 'Harp',
    'bariton': 'Baritone',
    'bas': 'Bass',
    'bass-klarnet': 'BassClarinet',
    'blokfleita': 'Recorder',
    "bol'shoi baraban": 'BassDrum',
    'chelesta': 'Celesta',
    'chembalo': 'Harpsichord',
    'fagot': 'Bassoon',
    'fleita': 'Flute',
    'fleita pikkolo': 'Piccolo',
    "fortep'iano": 'Piano',
    'frantsuzskii baraban': 'SnareDrum',
    'goboi': 'Oboe',
    'golos': 'Vocalist',
    'gorn': 'Horn',
    'klarnet': 'Clarinet',
    'klavesin': 'Harpsichord',
    'klavikord': 'Clavichord',
    "kolokol'chiki": 'Glockenspiel',
    "kontral'to": 'Alto',
    'ksilofon': 'Xylophone',
    'litavra': 'Timpani',
    'malaia fleita': 'Piccolo',
    'mandolina': 'Mandolin',
    'pikkolo': 'Piccolo',
    'rog': 'Horn',
    'rozhok': 'Horn',
    'saksofon': 'Saxophone',
    'skripka': 'Violin',
    'trombon': 'Trombone',
    'truba': 'Trumpet',
    'tsilindricheskii baraban': 'TenorDrum',
    'tsimbaly': 'Dulcimer',
    "violonchel'": 'Violoncello',
}

# noinspection SpellCheckingInspection
spanishToClassName = {
    'acordeón': 'Accordion',
    'armónica de boca': 'Harmonica',
    'arpa': 'Harp',
    'arpas': 'Harp',
    'atabal': 'Timpani',
    'bajo': 'Bass',
    'bajo acústico': 'AcousticBass',
    'bajo eléctrico': 'ElectricBass',
    'barítono': 'Baritone',
    'batería': 'Percussion',
    'bloques de madera': 'Woodblock',
    'bloques de papel de lija': 'SandpaperBlocks',
    'bombo': 'BassDrum',
    'bongo tambores': 'BongoDrums',
    'bongos': 'BongoDrums',
    'caja china': 'Woodblock',
    'caja clara': 'SnareDrum',
    'caja redoblante': 'TenorDrum',
    'caja rodante': 'TenorDrum',
    'campanas': 'TubularBells',
    'campanas de mano': 'Handbells',
    'campanas tubulares': 'TubularBells',
    'campanos': 'Cowbell',
    'campanólogo': 'Glockenspiel',
    'carraca': 'Ratchet',
    'cascabels': 'SleighBells',
    'castañuelas': 'Castanets',
    'caña de órganos': 'ReedOrgan',
    'cello': 'Violoncello',
    'cencerros': 'Cowbell',
    'charles': 'HiHatCymbal',
    'charleston': 'HiHatCymbal',
    'chelo': 'Violoncello',
    'chelos': 'Violoncello',
    'chinchines': 'FingerCymbals',
    'chisporroteo de platillos': 'SizzleCymbal',
    'cimbales': 'Cymbals',
    'clarinete': 'Clarinet',
    'clarinete bajo': 'BassClarinet',
    'clarinetes': 'Clarinet',
    'clave': 'Harpsichord',
    'clavecémbalo': 'Harpsichord',
    'clavecín': 'Harpsichord',
    'clavicordio': 'Clavichord',
    'clavicémbalo': 'Harpsichord',
    'clavicímbalo': 'Harpsichord',
    'con tensores': 'SnareDrum',
    'conga': 'CongaDrum',
    'congas': 'CongaDrum',
    'contrabajo': 'Contrabass',
    'contrabajos': 'Contrabass',
    'contrafagot': 'Contrabassoon',
    'contralto': 'Alto',
    'corneta inglesa': 'EnglishHorn',
    'corno': 'EnglishHorn',
    'corno francés': 'Horn',
    'corno inglés': 'EnglishHorn',
    'cornos francese': 'Horn',
    'crótalos': 'FingerCymbals',
    'cuerdas': 'StringInstrument',
    'cuerno': 'Horn',
    'cuerno inglés': 'EnglishHorn',
    'cémbalo': 'Harpsichord',
    'címbalos': 'Cymbals',
    'de pico': 'Recorder',
    'de pistones': 'Horn',
    'de timbres': 'Glockenspiel',
    'dulce': 'Recorder',
    'dulcema': 'Dulcimer',
    'el tenor del tambor': 'TenorDrum',
    'el viento de la máquina': 'WindMachine',
    'fagot': 'Bassoon',
    'flauta': 'Flute',
    'flauta de boehm': 'Flute',
    'flauta de concierto': 'Flute',
    'flauta de pan': 'PanFlute',
    'flauta de pico': 'Recorder',
    'flauta dulce': 'Recorder',
    'flauta piccolo': 'Piccolo',
    'flauta recta': 'Recorder',
    'flauta traversa': 'Flute',
    'flauta travesera': 'Flute',
    'flautas': 'Flute',
    'flautas de pan': 'PanFlute',
    'flautín': 'Piccolo',
    'fretless': 'FretlessBass',
    'gaita': 'Bagpipes',
    'grabadora': 'Recorder',
    'gran caja': 'BassDrum',
    'gravicémbalo': 'Harpsichord',
    'guitarra': 'AcousticGuitar',
    'guitarra acústica': 'AcousticGuitar',
    'guitarra eléctrica': 'ElectricGuitar',
    'harmónica': 'Harmonica',
    'hi hat': 'HiHatCymbal',
    'hi-hat': 'HiHatCymbal',
    'instrumento de cuerda': 'StringInstrument',
    'instrumento de madera': 'WoodwindInstrument',
    'instrumento de percusión': 'Percussion',
    'instrumento de viento': 'WoodwindInstrument',
    'instrumento de viento-metal': 'BrassInstrument',
    'juego': 'Glockenspiel',
    'juego de timbres': 'Glockenspiel',
    'laúd': 'Lute',
    'liro': 'Glockenspiel',
    'látigo': 'Whip',
    'mandolina': 'Mandolin',
    'matraca': 'Ratchet',
    'mezzosoprano': 'MezzoSoprano',
    'máquina de viento': 'WindMachine',
    'oboes': 'Oboe',
    'octavillo': 'Piccolo',
    'organo': 'Organ',
    'ottavino': 'Piccolo',
    'pailas criollas': 'Timbales',
    'pandereta': 'Tambourine',
    'papel de lija': 'SandpaperBlocks',
    'percusión': 'Percussion',
    'platillo hi-hat': 'HiHatCymbal',
    'platillo sizzle': 'SizzleCymbal',
    'platillo suspendido': 'SuspendedCymbal',
    'platillos': 'Cymbals',
    'platillos crash': 'CrashCymbals',
    'platillos de choque': 'CrashCymbals',
    'platillos suspendidos': 'SuspendedCymbal',
    'platos': 'Cymbals',
    'redoblante': 'SnareDrum',
    'saxo soprano': 'SopranoSaxophone',
    'saxo tenor': 'TenorSaxophone',
    'saxofón': 'Saxophone',
    'saxofón alto': 'AltoSaxophone',
    'saxofón del barítono': 'BaritoneSaxophone',
    'saxofóno': 'Saxophone',
    'saxofóno alto': 'AltoSaxophone',
    'saxofóno barítono': 'BaritoneSaxophone',
    'saxofóno soprano': 'SopranoSaxophone',
    'saxofóno tenor': 'TenorSaxophone',
    'saxofóns': 'Saxophone',
    'saxófono': 'Saxophone',
    'silbar': 'Whistle',
    'sirena': 'Siren',
    'siringa': 'PanFlute',
    'tambor afinable': 'SnareDrum',
    'tambor de acero': 'SteelDrum',
    'tambor de mano': 'Tambourine',
    'tambor mayor': 'TenorDrum',
    'tambor metálico de trinidad y tobago': 'SteelDrum',
    'tambor militar pequeño': 'SnareDrum',
    'templo de bloque': 'TempleBlock',
    'timbal': 'Timpani',
    'timbales': 'Timpani',
    'timbals': 'Timpani',
    'tomtom': 'TomTom',
    'trinquete': 'Ratchet',
    'triángulo': 'Triangle',
    'trombons': 'Trombone',
    'trombón': 'Trombone',
    'trombón bajo': 'BassTrombone',
    'trompa': 'Horn',
    'trompas': 'Horn',
    'trompeta': 'Trumpet',
    'trompetas': 'Trumpet',
    'tubas': 'Tuba',
    'tumbadora': 'CongaDrum',
    'tímpanos': 'Timpani',
    'ukelele': 'Ukulele',
    'vibráfon': 'Vibraphone',
    'vibráfono': 'Vibraphone',
    'violas': 'Viola',
    'violines': 'Violin',
    'violoncelo': 'Violoncello',
    'violoncelos': 'Violoncello',
    'violonchelo': 'Violoncello',
    'violonchelos': 'Violoncello',
    'violín': 'Violin',
    'voz': 'Vocalist',
    'xilofón': 'Xylophone',
    'xilofóno': 'Xylophone',
    'xilófono': 'Xylophone',
    'zampoñas': 'PanFlute',
    'órgano de': 'Glockenspiel',
    'órgano de campanas': 'Glockenspiel',
    'órgano de tubos': 'PipeOrgan',
    'órgano eléctrico': 'ElectricOrgan',
}

transliteration = {
    'accordeon': 'accord\xe9on',
    'acordeon': 'acorde\xf3n',
    'armonica de boca': 'arm\xf3nica de boca',
    'bajo acustico': 'bajo ac\xfastico',
    'bajo electrico': 'bajo el\xe9ctrico',
    'baritono': 'bar\xedtono',
    'basse electrique': 'basse \xe9lectrique',
    'becken freihangend': 'becken freih\xe4ngend',
    'becken gewonlich': 'becken gew\xf6nlich',
    'beckflote': 'beckfl\xf6te',
    'blockflote': 'blockfl\xf6te',
    'campanologo': 'campan\xf3logo',
    'cana de organos': 'ca\xf1a de \xf3rganos',
    'castanuelas': 'casta\xf1uelas',
    'celesta': 'c\xe9lesta',
    'cembalo': 'c\xe9mbalo',
    'clavecembalo': 'clavec\xe9mbalo',
    'clavecin': 'clavec\xedn',
    'clavicembalo': 'clavic\xe9mbalo',
    'clavicimbalo': 'clavic\xedmbalo',
    'cloches a vache': 'cloches \xe0 vache',
    'clochettes a main': 'clochettes \xe0 main',
    'corno frances': 'corno franc\xe9s',
    'corno ingles': 'corno ingl\xe9s',
    'crecelle': 'cr\xe9celle',
    'crotalos': 'cr\xf3talos',
    'cuerno ingles': 'cuerno ingl\xe9s',
    'echelettes': '\xe9chelettes',
    'el viento de la maquina': 'el viento de la m\xe1quina',
    'eoliphone': '\xe9oliphone',
    'flautin': 'flaut\xedn',
    'flote': 'fl\xf6te',
    'flute': 'fl\xfbte',
    'flute a bec': 'fl\xfbte \xe0 bec',
    'flute de pan': 'fl\xfbte de pan',
    'flute douce': 'fl\xfbte douce',
    'flute droite': 'fl\xfbte droite',
    'flute piccolo': 'fl\xfbte piccolo',
    'flute traversiere': 'fl\xfbte traversi\xe8re',
    'grande flute': 'grande fl\xfbte',
    'gravicembalo': 'gravic\xe9mbalo',
    'gresillement cymbale': 'gr\xe9sillement cymbale',
    'guitare electrique': 'guitare \xe9lectrique',
    'guitarra acustica': 'guitarra ac\xfastica',
    'guitarra electrica': 'guitarra el\xe9ctrica',
    'guitarre electrique': 'guitarre \xe9lectrique',
    'hangebecken': 'h\xe4ngebecken',
    'hangendes becken': 'h\xe4ngendes becken',
    'harmonica': 'harm\xf3nica',
    'hirtenflote': 'hirtenfl\xf6te',
    'kielflugel': 'kielfl\xfcgel',
    'kleine flote': 'kleine fl\xf6te',
    'latigo': 'l\xe1tigo',
    'machine a vent': 'machine \xe0 vent',
    'maquina de viento': 'm\xe1quina de viento',
    'octavflote': 'octavfl\xf6te',
    'organo de': '\xf3rgano de',
    'organo de campanas': '\xf3rgano de campanas',
    'organo de tubos': '\xf3rgano de tubos',
    'organo electrico': '\xf3rgano el\xe9ctrico',
    'orgue a tuyaux': 'orgue \xe0 tuyaux',
    'orgue electrique': 'orgue \xe9lectrique',
    'panflote': 'panfl\xf6te',
    'petite flute': 'petite fl\xfbte',
    'pickelflote': 'pickelfl\xf6te',
    'pikkoloflote': 'pikkolofl\xf6te',
    'querflote': 'querfl\xf6te',
    'rohrenglocken': 'r\xf6hrenglocken',
    'ruhrtrommel': 'r\xfchrtrommel',
    'sandblocke': 'sandbl\xf6cke',
    'sandpapier blocke': 'sandpapier bl\xf6cke',
    'saxofon': 'saxof\xf3n',
    'saxofon alto': 'saxof\xf3n alto',
    'saxofon del baritono': 'saxof\xf3n del bar\xedtono',
    'saxofono': 'saxof\xf3no',
    'saxofono alto': 'saxof\xf3no alto',
    'saxofono baritono': 'saxof\xf3no bar\xedtono',
    'saxofono soprano': 'saxof\xf3no soprano',
    'saxofono tenor': 'saxof\xf3no tenor',
    'saxophone tenor': 'saxophone t\xe9nor',
    'schnabelflote': 'schnabelfl\xf6te',
    'sirene': 'sir\xe8ne',
    'tambor metalico de trinidad y tobago': 'tambor met\xe1lico de trinidad y tobago',
    'tambor militar pequeno': 'tambor militar peque\xf1o',
    'tenor': 't\xe9nor',
    'tenor tambour': 't\xe9nor tambour',
    'timbales creoles': 'timbales cr\xe9oles',
    'timpanos': 't\xedmpanos',
    'triangulo': 'tri\xe1ngulo',
    'trombon': 'tromb\xf3n',
    'turkisches hangebecken': 't\xfcrkisches h\xe4ngebecken',
    'ukulele': 'ukul\xe9l\xe9',
    'violin': 'viol\xedn',
    'xilofon': 'xilof\xf3n',
    'xilofono': 'xil\xf3fono',
    'zamponas': 'zampo\xf1as',
}

transposition = {
    'clarinet': {'a': 'm-3',
                 'alto': 'M-6',
                 'b': 'M-2',  # German, much more common than b-natural
                 'b-': 'M-2',
                 'b- bass': 'M-9',
                 'b- contrabass': 'M-16',
                 'bass': 'M-9',
                 'd': 'M2',
                 'e-': 'm3',
                 'e- alto': 'M-6',
                 'e- contrabass': 'M-13',
                 'a-': 'm7',
                 'h': 'm-2',
                 'b-natural': 'm-2',
                 },
    'horn': {'a': 'm-3',
             'c': 'P-8',
             'd': 'm-7',
             'e': 'm-6',
             'e-': 'M-6',
             'english': 'P-5',  # this is how it works...
             'f': 'P-5',
             'g': 'P-4',
             },
    'trumpet': {'a': 'm-3',
                'b': 'M-2',  # German, much more common than b-natural
                'b-': 'M-2',
                'b- bass': 'M-9',
                'c': 'P1',
                'c bass': 'P-8',
                'cornet': 'M-2',
                'd': 'M2',
                'd bass': 'm-7',
                'e-': 'm3',
                'e- bass': 'M-6',
                'h': 'm-2',
                'b-natural': 'm-2',
                'f': 'P4',
                'flugelhorn': 'M-2',
                }
}

# ------------------------------------------------------------------------------

# Make allToClassName dict anew to ensure consistency with constituent parts

allToClassName = {
    **frenchToClassName,
    **germanToClassName,
    **italianToClassName,
    **russianToClassName,
    **spanishToClassName,
    **abbreviationToClassName,
    **englishToClassName,  # leave at end since should overwrite any others.
}

# Special case of transliteration via the relevant language
for _key in transliteration:
    allToClassName[_key] = allToClassName[transliteration[_key]]

del _key


# ------------------------------------------------------------------------------

class Test(unittest.TestCase):

    def testAllToClassNamePopulated(self):
        '''
        Test that the allToClassName dict includes all the keys from the constituent dicts.

        Note: No length test due to duplicate entries
        (i.e. allToClassName is smaller than the sum of its parts).
        '''
        for eachDict in [abbreviationToClassName,
                         englishToClassName,
                         frenchToClassName,
                         germanToClassName,
                         italianToClassName,
                         russianToClassName,
                         spanishToClassName]:

            for key in eachDict:
                self.assertIn(key, allToClassName)

    def testAllToClassNameExamples(self):
        '''
        Test an example from each constituent dict that makes up allToClassName.
        '''

        for testString, langDict in [('a sax', abbreviationToClassName),
                                     ('accordion', englishToClassName),
                                     ('accord\xe9on', frenchToClassName),
                                     ('aeolophon', germanToClassName),
                                     ('a becco', italianToClassName),
                                     ("al't", russianToClassName),
                                     ('acorde\xf3n', spanishToClassName)
                                     ]:
            self.assertEqual(allToClassName[testString], langDict[testString])

    def testAllClassNames(self):
        '''
        Test that all class names are real.
        '''
        from music21 import instrument as instr
        for v in allToClassName.values():
            with self.subTest(name=v):
                getattr(instr, v)


# ------------------------------------------------------------------------------

if __name__ == '__main__':
    import music21

    music21.mainTest(Test)
