/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class MonthNameConverter
implements ObjectConverter {
    public static ConverterContext CONTEXT = new ConverterContext("MonthName");
    public static final DateFormat CONCISE_FORMAT = new SimpleDateFormat("M");
    public static final DateFormat SHORT_FORMAT = new SimpleDateFormat("MM");
    public static final DateFormat MEDIUM_FORMAT = new SimpleDateFormat("MMM");
    public static final DateFormat LONG_FORMAT = new SimpleDateFormat("MMMMM");
    private DateFormat _defaultFormat = MEDIUM_FORMAT;
    static final Calendar CAL = Calendar.getInstance();

    public String toString(Object object, ConverterContext context) {
        if (object == null || !(object instanceof Integer)) {
            return "";
        }
        return this._defaultFormat.format(this.getCalendarByMonth((Integer)object).getTime());
    }

    protected Calendar getCalendarByMonth(int month) {
        CAL.set(2, month);
        return CAL;
    }

    public boolean supportToString(Object object, ConverterContext context) {
        return true;
    }

    public Object fromString(String string, ConverterContext context) {
        Calendar calendar = Calendar.getInstance();
        try {
            Date time = this._defaultFormat.parse(string);
            calendar.setTime(time);
        }
        catch (ParseException e1) {
            try {
                Date time = SHORT_FORMAT.parse(string);
                calendar.setTime(time);
            }
            catch (ParseException e2) {
                try {
                    Date time = MEDIUM_FORMAT.parse(string);
                    calendar.setTime(time);
                }
                catch (ParseException e3) {
                    try {
                        Date time = LONG_FORMAT.parse(string);
                        calendar.setTime(time);
                    }
                    catch (ParseException e4) {
                        try {
                            Date time = CONCISE_FORMAT.parse(string);
                            calendar.setTime(time);
                        }
                        catch (ParseException e5) {
                            return null;
                        }
                    }
                }
            }
        }
        return calendar.get(2);
    }

    public boolean supportFromString(String string, ConverterContext context) {
        return true;
    }

    public DateFormat getDefaultFormat() {
        return this._defaultFormat;
    }

    public void setDefaultFormat(DateFormat defaultFormat) {
        this._defaultFormat = defaultFormat;
    }

    public static void main(String[] args) {
        MonthNameConverter converter = new MonthNameConverter();
        converter.setDefaultFormat(LONG_FORMAT);
        for (int i = 0; i < 12; ++i) {
            String str = converter.toString(new Integer(i), null);
            System.out.println(str);
            System.out.println(converter.fromString(str, null));
        }
    }

    static {
        CAL.set(5, 1);
    }
}

