/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import net.sf.gogui.gtp.GtpClient;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.gui.GtpShellText;
import net.sf.gogui.gui.GuiUtils;
import net.sf.gogui.gui.OptionalMessage;
import net.sf.gogui.gui.SimpleDialogs;
import net.sf.gogui.gui.Utils;
import net.sf.gogui.utils.Platform;
import net.sf.gogui.utils.Preferences;

public class GtpShell
extends JDialog
implements ActionListener,
GtpClient.IOCallback {
    private boolean m_timeStamp;
    private boolean m_disableCompletions;
    private boolean m_isFinalSizeSet;
    private int m_historyMax;
    private int m_historyMin;
    private int m_linesTruncated;
    private int m_numberCommands;
    private static final long serialVersionUID = 0L;
    private Callback m_callback;
    private ComboBoxEditor m_editor;
    private Dimension m_finalSize;
    private JButton m_runButton;
    private JTextField m_textField;
    private JComboBox m_comboBox;
    private JScrollPane m_scrollPane;
    private GtpShellText m_gtpShellText;
    private OptionalMessage m_modifyWarning;
    private Point m_finalLocation;
    private final StringBuffer m_commands = new StringBuffer(4096);
    private final ArrayList m_history = new ArrayList(128);
    private String m_programCommand = "unknown";
    private String m_programName = "unknown";
    private String m_programVersion = "unknown";
    static final /* synthetic */ boolean $assertionsDisabled;

    public GtpShell(Frame frame, Callback callback, Preferences preferences, boolean bl) {
        super(frame, "Shell");
        this.m_callback = callback;
        this.m_historyMin = preferences.getInt("gtpshell-history-min");
        this.m_historyMax = preferences.getInt("gtpshell-history-max");
        JPanel jPanel = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        this.m_gtpShellText = new GtpShellText(this.m_historyMin, this.m_historyMax, this.m_timeStamp, bl);
        this.m_scrollPane = new JScrollPane(this.m_gtpShellText.get(), 22, 31);
        int n = this.m_gtpShellText.get().getFont().getSize();
        this.m_finalSize = new Dimension(n * 40, n * 30);
        jPanel.add((Component)this.m_scrollPane, "Center");
        jPanel.add((Component)this.createCommandInput(), "South");
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("analyze")) {
            this.m_callback.cbAnalyze();
        } else if (string.equals("comboBoxEdited")) {
            this.comboBoxEdited();
        } else if (string.equals("run")) {
            this.comboBoxEdited();
        } else if (string.equals("close")) {
            this.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadHistory() {
        File file = this.getHistoryFile();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            try {
                String string = bufferedReader.readLine();
                while (string != null) {
                    this.appendToHistory(string);
                    string = bufferedReader.readLine();
                }
            }
            finally {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void receivedInvalidResponse(String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.appendInvalidResponse(string);
            return;
        }
        UpdateInvalidResponse updateInvalidResponse = new UpdateInvalidResponse(this, string);
        this.invokeAndWait(updateInvalidResponse);
    }

    public void receivedResponse(boolean bl, String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.appendResponse(bl, string);
            return;
        }
        UpdateResponse updateResponse = new UpdateResponse(this, bl, string);
        this.invokeAndWait(updateResponse);
    }

    public void receivedStdErr(String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.appendLog(string);
            return;
        }
        UpdateStdErr updateStdErr = new UpdateStdErr(this, string);
        this.invokeAndWait(updateStdErr);
    }

    public void saveLog(JFrame jFrame) {
        this.save(jFrame, this.m_gtpShellText.getLog(), this.m_gtpShellText.getLinesTruncated());
    }

    public void saveCommands(JFrame jFrame) {
        this.save(jFrame, this.m_commands.toString(), this.m_linesTruncated);
    }

    public void saveHistory() {
        File file = this.getHistoryFile();
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
            int n = 100;
            int n2 = this.m_history.size();
            if (n2 > n) {
                n2 = n;
            }
            for (int i = this.m_history.size() - n2; i < this.m_history.size(); ++i) {
                printWriter.println(this.m_history.get(i));
            }
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void setCommandInProgess(boolean bl) {
        this.m_comboBox.setEnabled(!bl);
        this.m_runButton.setEnabled(!bl);
        if (!bl) {
            this.m_comboBox.requestFocusInWindow();
            this.m_textField.requestFocusInWindow();
        }
    }

    public void setCommandCompletion(boolean bl) {
        this.m_disableCompletions = !bl;
    }

    public void setTimeStamp(boolean bl) {
        this.m_gtpShellText.setTimeStamp(bl);
    }

    public boolean send(String string, Component component, boolean bl) {
        block9: {
            if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
                throw new AssertionError();
            }
            String string2 = string.trim();
            if (string2.equals("")) {
                return true;
            }
            if (string2.startsWith("#")) {
                this.m_gtpShellText.appendComment(string + "\n");
            } else {
                if (string2.startsWith("boardsize ") || string2.startsWith("black ") || string2.equals("clear_board") || string2.startsWith("genmove ") || string2.startsWith("genmove_black ") || string2.startsWith("genmove_cleanup ") || string2.startsWith("genmove_white ") || string2.startsWith("kgs-genmove_cleanup ") || string2.startsWith("loadsgf ") || string2.startsWith("play ") || string2.startsWith("play_sequence ") || string2.startsWith("white ") || string2.startsWith("quit")) {
                    String string3;
                    if (this.m_modifyWarning == null) {
                        this.m_modifyWarning = new OptionalMessage(this);
                    }
                    if (!this.m_modifyWarning.showWarning(string3 = "The command '" + string + "' " + "will modify the board state " + "and cause the graphical board to be out of sync. " + "You should start a new game before using " + "the graphical board again.")) {
                        return true;
                    }
                }
                try {
                    this.m_callback.sendGtpCommand(string, component != null);
                }
                catch (GtpError gtpError) {
                    Utils.showError(component, this.m_programName, gtpError);
                    if (!bl) break block9;
                    return !SimpleDialogs.showQuestion(component, "Abort?");
                }
            }
        }
        return true;
    }

    public void sentCommand(String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.appendSentCommand(string);
            return;
        }
        UpdateCommand updateCommand = new UpdateCommand(this, string);
        this.invokeAndWait(updateCommand);
    }

    public void setFinalSize(int n, int n2, int n3, int n4) {
        if (this.m_isFinalSizeSet) {
            this.setBounds(n, n2, n3, n4);
        } else {
            this.m_finalSize = new Dimension(n3, n4);
            this.m_finalLocation = new Point(n, n2);
        }
    }

    public void setInitialCompletions(ArrayList arrayList) {
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            this.appendToHistory(arrayList.get(i).toString());
        }
        this.loadHistory();
        this.addAllCompletions(this.m_history);
    }

    public void setProgramCommand(String string) {
        this.m_programCommand = string;
    }

    public void setProgramName(String string) {
        this.m_programName = string;
    }

    public void setProgramVersion(String string) {
        this.m_programVersion = string;
    }

    private void addAllCompletions(ArrayList arrayList) {
        String string = this.m_textField.getText();
        int n = this.m_textField.getCaretPosition();
        if (arrayList.size() > this.m_comboBox.getItemCount()) {
            this.m_comboBox.hidePopup();
        }
        this.m_comboBox.removeAllItems();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            WrapperObject wrapperObject = new WrapperObject((String)arrayList.get(i));
            this.m_comboBox.addItem(wrapperObject);
        }
        this.m_comboBox.setSelectedIndex(-1);
        this.m_textField.setText(string);
        this.m_textField.setCaretPosition(n);
    }

    private void appendInvalidResponse(String string) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        this.m_gtpShellText.appendInvalidResponse(string);
    }

    private void appendLog(String string) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        this.m_gtpShellText.appendLog(string);
    }

    private void appendResponse(boolean bl, String string) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (bl) {
            this.m_gtpShellText.appendError(string);
        } else {
            this.m_gtpShellText.appendInput(string);
        }
        this.setFinalSize();
    }

    private void appendSentCommand(String string) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        this.m_commands.append(string);
        this.m_commands.append("\n");
        ++this.m_numberCommands;
        if (this.m_numberCommands > this.m_historyMax) {
            int n = this.m_numberCommands - this.m_historyMin;
            String string2 = this.m_commands.toString();
            int n2 = GtpShellText.findTruncateIndex(string2, n);
            if (!$assertionsDisabled && n2 == -1) {
                throw new AssertionError();
            }
            this.m_commands.delete(0, n2);
            this.m_linesTruncated += n;
            this.m_numberCommands = 0;
        }
        this.m_gtpShellText.appendOutput(string + "\n");
        this.setFinalSize();
    }

    private void appendToHistory(String string) {
        int n = this.m_history.indexOf(string = string.trim());
        if (n >= 0) {
            this.m_history.remove(n);
        }
        this.m_history.add(string);
    }

    private void comboBoxEdited() {
        Object object = this.m_comboBox.getSelectedItem();
        if (object == null) {
            return;
        }
        String string = object.toString();
        if (string.trim().equals("")) {
            return;
        }
        this.send(string, null, false);
        this.appendToHistory(string);
        this.m_gtpShellText.setPositionToEnd();
        this.m_comboBox.hidePopup();
        this.addAllCompletions(this.m_history);
        this.m_editor.setItem(null);
    }

    private JPanel createCommandInput() {
        Serializable serializable;
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel2, "East");
        this.m_comboBox = new JComboBox();
        this.m_editor = this.m_comboBox.getEditor();
        this.m_textField = (JTextField)this.m_editor.getEditorComponent();
        this.m_textField.setFocusTraversalKeysEnabled(false);
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                int n2 = keyEvent.getModifiers();
                if (n == 27) {
                    return;
                }
                if (n == 9) {
                    GtpShell.this.findBestCompletion();
                    GtpShell.this.popupCompletions();
                } else if (n == 33 && n2 == 1) {
                    GtpShell.this.scrollPage(true);
                } else if (n == 34 && n2 == 1) {
                    GtpShell.this.scrollPage(false);
                } else if (keyEvent.getKeyChar() != '\uffff') {
                    GtpShell.this.popupCompletions();
                }
            }
        };
        this.m_textField.addKeyListener(keyAdapter);
        this.m_comboBox.setEditable(true);
        this.m_comboBox.setFont(this.m_gtpShellText.get().getFont());
        this.m_comboBox.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                GtpShell.this.m_comboBox.requestFocusInWindow();
                GtpShell.this.m_textField.requestFocusInWindow();
            }
        });
        jPanel.add(this.m_comboBox);
        this.m_runButton = new JButton();
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        URL uRL = classLoader.getResource("net/sf/gogui/images/exec.png");
        if (uRL == null) {
            this.m_runButton.setText("Run");
        } else {
            serializable = new ImageIcon(uRL, "Run");
            this.m_runButton.setIcon((Icon)((Object)serializable));
        }
        this.m_runButton.setActionCommand("run");
        this.m_runButton.addActionListener(this);
        jPanel2.add((Component)GuiUtils.createSmallFiller(), "West");
        jPanel2.add((Component)this.m_runButton, "Center");
        if (Platform.isMac()) {
            serializable = new Dimension(20, 1);
            Box.Filler filler = new Box.Filler((Dimension)serializable, (Dimension)serializable, (Dimension)serializable);
            jPanel2.add((Component)filler, "East");
        }
        return jPanel;
    }

    private void findBestCompletion() {
        String string = this.m_textField.getText().trim();
        if (string.equals("")) {
            return;
        }
        String string2 = null;
        for (int i = 0; i < this.m_history.size(); ++i) {
            int n;
            String string3 = (String)this.m_history.get(i);
            if (!string3.startsWith(string)) continue;
            if (string2 == null) {
                string2 = string3;
                continue;
            }
            for (n = string.length(); n < string2.length() && n < string3.length() && string2.charAt(n) == string3.charAt(n); ++n) {
            }
            string2 = string3.substring(0, n);
        }
        if (string2 != null) {
            this.m_textField.setText(string2);
        }
    }

    private File getHistoryFile() {
        String string = System.getProperty("user.home");
        File file = new File(string, ".gogui");
        if (!file.exists()) {
            file.mkdir();
        }
        return new File(file, "gtpshell-history");
    }

    private void invokeAndWait(Runnable runnable) {
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Thread interrupted");
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println("InvocationTargetException");
        }
    }

    private void popupCompletions() {
        int n;
        String string = this.m_textField.getText();
        string = string.replaceAll("^ *", "");
        ArrayList<String> arrayList = new ArrayList<String>(128);
        for (n = 0; n < this.m_history.size(); ++n) {
            String string2 = (String)this.m_history.get(n);
            if (!string2.startsWith(string)) continue;
            arrayList.add(string2);
        }
        this.addAllCompletions(arrayList);
        if (this.m_disableCompletions) {
            return;
        }
        n = arrayList.size();
        if (string.length() > 0 && (n > 1 || n == 1 && !string.equals(arrayList.get(0)))) {
            this.m_comboBox.showPopup();
        }
    }

    private void save(JFrame jFrame, String string, int n) {
        File file = SimpleDialogs.showSave(jFrame, null);
        if (file == null) {
            return;
        }
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(file));
            printStream.println("# Name: " + this.m_programName);
            printStream.println("# Version: " + this.m_programVersion);
            printStream.println("# Command: " + this.m_programCommand);
            printStream.println("# Lines truncated: " + n);
            printStream.print(string);
            printStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(jFrame, "Could not save to file.", "GoGui: Error", 0);
        }
    }

    private void scrollPage(boolean bl) {
        JViewport jViewport = this.m_scrollPane.getViewport();
        Point point = jViewport.getViewPosition();
        int n = this.m_scrollPane.getSize().height - this.m_gtpShellText.get().getFont().getSize();
        if (bl) {
            point.y -= n;
            if (point.y < 0) {
                point.y = 0;
            }
        } else {
            point.y += n;
            int n2 = jViewport.getViewSize().height - this.m_scrollPane.getSize().height;
            if (point.y > n2) {
                point.y = n2;
            }
        }
        jViewport.setViewPosition(point);
    }

    private void setFinalSize() {
        if (this.m_isFinalSizeSet) {
            return;
        }
        this.setSize(this.m_finalSize);
        if (this.m_finalLocation != null) {
            this.setLocation(this.m_finalLocation);
        }
        this.m_isFinalSizeSet = true;
    }

    static {
        $assertionsDisabled = !GtpShell.class.desiredAssertionStatus();
    }

    private static class WrapperObject {
        private final String m_item;

        WrapperObject(String string) {
            this.m_item = string;
        }

        public String toString() {
            return this.m_item;
        }
    }

    private static class UpdateStdErr
    implements Runnable {
        private final String m_text;
        private final GtpShell m_gtpShell;
        static final /* synthetic */ boolean $assertionsDisabled;

        public UpdateStdErr(GtpShell gtpShell, String string) {
            this.m_gtpShell = gtpShell;
            this.m_text = string;
        }

        public void run() {
            if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
                throw new AssertionError();
            }
            this.m_gtpShell.appendLog(this.m_text);
            this.m_gtpShell.setFinalSize();
        }

        static {
            $assertionsDisabled = !(class$net$sf$gogui$gui$GtpShell == null ? (class$net$sf$gogui$gui$GtpShell = GtpShell.class$("net.sf.gogui.gui.GtpShell")) : class$net$sf$gogui$gui$GtpShell).desiredAssertionStatus();
        }
    }

    private static class UpdateResponse
    implements Runnable {
        private final boolean m_error;
        private final String m_text;
        private final GtpShell m_gtpShell;

        public UpdateResponse(GtpShell gtpShell, boolean bl, String string) {
            this.m_gtpShell = gtpShell;
            this.m_error = bl;
            this.m_text = string;
        }

        public void run() {
            this.m_gtpShell.appendResponse(this.m_error, this.m_text);
        }
    }

    private static class UpdateInvalidResponse
    implements Runnable {
        private final String m_text;
        private final GtpShell m_gtpShell;

        public UpdateInvalidResponse(GtpShell gtpShell, String string) {
            this.m_gtpShell = gtpShell;
            this.m_text = string;
        }

        public void run() {
            this.m_gtpShell.appendInvalidResponse(this.m_text);
        }
    }

    private static class UpdateCommand
    implements Runnable {
        private final String m_text;
        private final GtpShell m_gtpShell;

        public UpdateCommand(GtpShell gtpShell, String string) {
            this.m_gtpShell = gtpShell;
            this.m_text = string;
        }

        public void run() {
            this.m_gtpShell.appendSentCommand(this.m_text);
        }
    }

    public static interface Callback {
        public void cbAnalyze();

        public boolean sendGtpCommand(String var1, boolean var2) throws GtpError;
    }
}

