/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.problems.internal.ProblemContext;
import org.gradle.api.problems.internal.ProblemLocation;

@NonNullApi
public class DefaultProblemContext
implements Serializable,
ProblemContext {
    private final List<ProblemLocation> locations;
    private final String description;
    private final RuntimeException cause;
    private final Map<String, Object> additionalData;

    protected DefaultProblemContext(List<ProblemLocation> locations, @Nullable String description, @Nullable RuntimeException cause, Map<String, Object> additionalData) {
        this.locations = ImmutableList.copyOf(locations);
        this.description = description;
        this.cause = cause;
        this.additionalData = ImmutableMap.copyOf(additionalData);
    }

    @Override
    public List<ProblemLocation> getLocations() {
        return this.locations;
    }

    @Override
    public String getDetails() {
        return this.description;
    }

    @Override
    public RuntimeException getException() {
        return this.cause;
    }

    @Override
    public Map<String, Object> getAdditionalData() {
        return this.additionalData;
    }

    private static boolean equals(@Nullable Object a, @Nullable Object b) {
        return a == b || a != null && a.equals(b);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultProblemContext that = (DefaultProblemContext)o;
        return DefaultProblemContext.equals(this.locations, that.locations) && DefaultProblemContext.equals(this.description, that.description) && DefaultProblemContext.equals(this.cause, that.cause) && DefaultProblemContext.equals(this.additionalData, that.additionalData);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.locations, this.description, this.cause, this.additionalData});
    }
}

